/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.inject.Inject;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.user.UserRepository;
import org.visallo.web.parameterProviders.TimeZone;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class TimeZoneParameterProviderFactory
extends ParameterProviderFactory<String> {
    private final ParameterProvider<String> parameterProvider;

    @Inject
    public TimeZoneParameterProviderFactory(UserRepository userRepository, Configuration configuration) {
        this.parameterProvider = new VisalloBaseParameterProvider<String>(userRepository, configuration){

            public String getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                return this.getTimeZone(request);
            }
        };
    }

    public boolean isHandled(Method handleMethod, Class<? extends String> parameterType, Annotation[] parameterAnnotations) {
        return TimeZoneParameterProviderFactory.getTimeZoneAnnotation(parameterAnnotations) != null;
    }

    public ParameterProvider<String> createParameterProvider(Method handleMethod, Class<?> parameterType, Annotation[] parameterAnnotations) {
        return this.parameterProvider;
    }

    private static TimeZone getTimeZoneAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof TimeZone)) continue;
            return (TimeZone)annotation;
        }
        return null;
    }
}

