/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.initializers;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRunner;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.StoppableRunnable;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.initializers.ApplicationBootstrapInitializer;

public class LongRunningProcessRunnerInitializer
extends ApplicationBootstrapInitializer
implements ShutdownListener {
    private static final String CONFIG_THREAD_COUNT = LongRunningProcessRunnerInitializer.class.getName() + ".threadCount";
    private static final int DEFAULT_THREAD_COUNT = 1;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(LongRunningProcessRunnerInitializer.class);
    private final Configuration config;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public LongRunningProcessRunnerInitializer(Configuration config, ShutdownService shutdownService) {
        this.config = config;
        shutdownService.register((ShutdownListener)this);
    }

    @Override
    public void initialize(ServletContext context) {
        LOGGER.debug("Starting LongRunningProcessRunnerInitializer", new Object[0]);
        int threadCount = this.config.getInt(CONFIG_THREAD_COUNT, Integer.valueOf(1));
        this.stoppables.addAll(LongRunningProcessRunner.startThreaded((int)threadCount, (Configuration)this.config));
    }

    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }
}

