/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.initializers;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.visallo.core.config.Configuration;
import org.visallo.core.ingest.graphProperty.GraphPropertyRunner;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.StoppableRunnable;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.initializers.ApplicationBootstrapInitializer;

public class GraphPropertyWorkerRunnerInitializer
extends ApplicationBootstrapInitializer
implements ShutdownListener {
    private static final String CONFIG_THREAD_COUNT = GraphPropertyWorkerRunnerInitializer.class.getName() + ".threadCount";
    private static final int DEFAULT_THREAD_COUNT = 1;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphPropertyWorkerRunnerInitializer.class);
    private final Configuration config;
    private final UserRepository userRepository;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public GraphPropertyWorkerRunnerInitializer(Configuration config, UserRepository userRepository, ShutdownService shutdownService) {
        this.config = config;
        this.userRepository = userRepository;
        shutdownService.register((ShutdownListener)this);
    }

    @Override
    public void initialize(ServletContext context) {
        LOGGER.debug("Starting GraphPropertyWorkerRunnerInitializer", new Object[0]);
        int threadCount = this.config.getInt(CONFIG_THREAD_COUNT, Integer.valueOf(1));
        User user = this.userRepository.getSystemUser();
        this.stoppables.addAll(GraphPropertyRunner.startThreaded((int)threadCount, (User)user));
    }

    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }
}

