/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.core.exception.VisalloException;
import org.visallo.web.ConnectionClosedException;
import org.visallo.web.ResponseTypes;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.clientapi.util.ObjectMapperFactory;

public class VisalloResponse {
    public static final int EXPIRES_1_HOUR = 3600;
    public static final ClientApiSuccess SUCCESS = new ClientApiSuccess();
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public VisalloResponse(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void respondWithClientApiObject(ClientApiObject obj) throws IOException {
        if (obj == null) {
            this.respondWithNotFound();
            return;
        }
        try {
            String jsonObject = ObjectMapperFactory.getInstance().writeValueAsString((Object)obj);
            VisalloResponse.configureResponse(ResponseTypes.JSON_OBJECT, this.response, jsonObject);
        }
        catch (JsonProcessingException e) {
            throw new VisalloException("Could not write json", (Throwable)e);
        }
    }

    public void respondWithNotFound() throws IOException {
        this.response.sendError(404);
    }

    public void respondWithNotFound(String message) throws IOException {
        this.response.sendError(404, message);
    }

    public void respondWithBadRequest(String parameterName, String errorMessage, List<String> invalidValues) throws IOException {
        JSONObject error = new JSONObject();
        error.put(parameterName, (Object)errorMessage);
        if (invalidValues != null) {
            JSONArray values = new JSONArray();
            for (String v : invalidValues) {
                values.put((Object)v);
            }
            error.put("invalidValues", (Object)values);
        }
        this.response.setStatus(400);
        this.respondWithJson(error);
    }

    public void respondWithSuccessJson() {
        JSONObject successJson = new JSONObject();
        successJson.put("success", true);
        this.respondWithJson(successJson);
    }

    public void respondWithJson(JSONObject jsonObject) {
        VisalloResponse.configureResponse(ResponseTypes.JSON_OBJECT, this.response, jsonObject);
    }

    public void respondWithHtml(String html) {
        VisalloResponse.configureResponse(ResponseTypes.HTML, this.response, html);
    }

    public String generateETag(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] md5 = digest.digest(data);
            return Hex.encodeHexString((byte[])md5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VisalloException("Could not find MD5", (Throwable)e);
        }
    }

    public void addETagHeader(String eTag) {
        this.response.setHeader("ETag", "\"" + eTag + "\"");
    }

    public boolean testEtagHeaders(String eTag) throws IOException {
        String ifNoneMatch = this.request.getHeader("If-None-Match");
        if (ifNoneMatch != null) {
            if (ifNoneMatch.startsWith("\"") && ifNoneMatch.length() > 2) {
                ifNoneMatch = ifNoneMatch.substring(1, ifNoneMatch.length() - 1);
            }
            if (eTag.equalsIgnoreCase(ifNoneMatch)) {
                this.addETagHeader(eTag);
                this.respondWithNotModified();
                return true;
            }
        }
        return false;
    }

    public void respondWithNotModified() throws IOException {
        this.response.sendError(304);
    }

    public void write(byte[] bytes) throws IOException {
        ServletOutputStream out = this.response.getOutputStream();
        out.write(bytes);
        out.close();
    }

    public void write(InputStream in) throws IOException {
        ServletOutputStream out = this.response.getOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.close();
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setMaxAge(int numberOfSeconds) {
        this.response.setHeader("Cache-Control", "max-age=" + numberOfSeconds);
    }

    public OutputStream getOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new VisalloException("Could not get response output stream", (Throwable)e);
        }
    }

    public void flushBuffer() {
        try {
            this.response.flushBuffer();
        }
        catch (IOException e) {
            throw new VisalloException("Could not flush response buffer");
        }
    }

    public void setStatus(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void setContentLength(int length) {
        this.response.setContentLength(length);
    }

    public void setCharacterEncoding(String charset) {
        this.response.setCharacterEncoding(charset);
    }

    public static void configureResponse(ResponseTypes type, HttpServletResponse response, Object responseData) {
        Preconditions.checkNotNull((Object)response, (Object)"The provided response was invalid");
        Preconditions.checkNotNull((Object)responseData, (Object)"The provided data was invalid");
        try {
            switch (type) {
                case JSON_OBJECT: {
                    response.setContentType("application/json");
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().write(responseData.toString());
                    break;
                }
                case JSON_ARRAY: {
                    response.setContentType("application/json");
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().write(responseData.toString());
                    break;
                }
                case PLAINTEXT: {
                    response.setContentType("text/plain");
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().write(responseData.toString());
                    break;
                }
                case HTML: {
                    response.setContentType("text/html");
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().write(responseData.toString());
                    break;
                }
                default: {
                    throw new VisalloException("Unsupported response type encountered");
                }
            }
            if (response.getWriter().checkError()) {
                throw new ConnectionClosedException();
            }
        }
        catch (IOException e) {
            throw new VisalloException("Error occurred while writing response", (Throwable)e);
        }
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }
}

