/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.v5analytics.webster.Handler;
import com.v5analytics.webster.handlers.StaticResourceHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.geocoding.DefaultGeocoderRepository;
import org.visallo.core.geocoding.GeocoderRepository;
import org.visallo.core.trace.Trace;
import org.visallo.core.trace.TraceSpan;
import org.visallo.core.util.ServiceLoaderUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.AuthenticationHandler;
import org.visallo.web.BadRequestException;
import org.visallo.web.ConnectionClosedException;
import org.visallo.web.CurrentUser;
import org.visallo.web.ErrorCodeHandler;
import org.visallo.web.RateLimitFilter;
import org.visallo.web.ResponseTypes;
import org.visallo.web.UserAgentFilter;
import org.visallo.web.VisalloCsrfHandler;
import org.visallo.web.VisalloResponse;
import org.visallo.web.WebApp;
import org.visallo.web.WebAppPlugin;
import org.visallo.web.privilegeFilters.AdminPrivilegeFilter;
import org.visallo.web.privilegeFilters.CommentPrivilegeFilter;
import org.visallo.web.privilegeFilters.EditPrivilegeFilter;
import org.visallo.web.privilegeFilters.HistoryReadPrivilegeFilter;
import org.visallo.web.privilegeFilters.PublishPrivilegeFilter;
import org.visallo.web.privilegeFilters.ReadPrivilegeFilter;
import org.visallo.web.routes.Index;
import org.visallo.web.routes.admin.AdminList;
import org.visallo.web.routes.admin.AdminUploadOntology;
import org.visallo.web.routes.admin.PluginList;
import org.visallo.web.routes.config.Configuration;
import org.visallo.web.routes.dashboard.DashboardAll;
import org.visallo.web.routes.dashboard.DashboardDelete;
import org.visallo.web.routes.dashboard.DashboardItemDelete;
import org.visallo.web.routes.dashboard.DashboardItemUpdate;
import org.visallo.web.routes.dashboard.DashboardUpdate;
import org.visallo.web.routes.directory.DirectoryGet;
import org.visallo.web.routes.directory.DirectorySearch;
import org.visallo.web.routes.edge.EdgeCreate;
import org.visallo.web.routes.edge.EdgeDelete;
import org.visallo.web.routes.edge.EdgeDeleteProperty;
import org.visallo.web.routes.edge.EdgeDetails;
import org.visallo.web.routes.edge.EdgeExists;
import org.visallo.web.routes.edge.EdgeGetCount;
import org.visallo.web.routes.edge.EdgeGetHistory;
import org.visallo.web.routes.edge.EdgeGetPropertyHistory;
import org.visallo.web.routes.edge.EdgeMultiple;
import org.visallo.web.routes.edge.EdgeProperties;
import org.visallo.web.routes.edge.EdgePropertyDetails;
import org.visallo.web.routes.edge.EdgeSearch;
import org.visallo.web.routes.edge.EdgeSetProperty;
import org.visallo.web.routes.edge.EdgeSetPropertyVisibility;
import org.visallo.web.routes.edge.EdgeSetVisibility;
import org.visallo.web.routes.element.ElementSearch;
import org.visallo.web.routes.longRunningProcess.LongRunningProcessById;
import org.visallo.web.routes.longRunningProcess.LongRunningProcessCancel;
import org.visallo.web.routes.longRunningProcess.LongRunningProcessDelete;
import org.visallo.web.routes.map.GetGeocoder;
import org.visallo.web.routes.map.MapzenTileProxy;
import org.visallo.web.routes.notification.Notifications;
import org.visallo.web.routes.notification.SystemNotificationDelete;
import org.visallo.web.routes.notification.SystemNotificationSave;
import org.visallo.web.routes.notification.UserNotificationMarkRead;
import org.visallo.web.routes.ontology.Ontology;
import org.visallo.web.routes.ping.Ping;
import org.visallo.web.routes.ping.PingStats;
import org.visallo.web.routes.product.ProductAll;
import org.visallo.web.routes.product.ProductDelete;
import org.visallo.web.routes.product.ProductGet;
import org.visallo.web.routes.product.ProductPreview;
import org.visallo.web.routes.product.ProductUpdate;
import org.visallo.web.routes.resource.MapMarkerImage;
import org.visallo.web.routes.resource.ResourceExternalGet;
import org.visallo.web.routes.resource.ResourceGet;
import org.visallo.web.routes.search.SearchDelete;
import org.visallo.web.routes.search.SearchList;
import org.visallo.web.routes.search.SearchRun;
import org.visallo.web.routes.search.SearchSave;
import org.visallo.web.routes.user.Logout;
import org.visallo.web.routes.user.MeGet;
import org.visallo.web.routes.user.UserGet;
import org.visallo.web.routes.user.UserList;
import org.visallo.web.routes.user.UserSetUiPreferences;
import org.visallo.web.routes.vertex.ResolveDetectedObject;
import org.visallo.web.routes.vertex.ResolveTermEntity;
import org.visallo.web.routes.vertex.UnresolveDetectedObject;
import org.visallo.web.routes.vertex.UnresolveTermEntity;
import org.visallo.web.routes.vertex.VertexDeleteProperty;
import org.visallo.web.routes.vertex.VertexDetails;
import org.visallo.web.routes.vertex.VertexEdges;
import org.visallo.web.routes.vertex.VertexExists;
import org.visallo.web.routes.vertex.VertexFindPath;
import org.visallo.web.routes.vertex.VertexFindRelated;
import org.visallo.web.routes.vertex.VertexGeoSearch;
import org.visallo.web.routes.vertex.VertexGetCount;
import org.visallo.web.routes.vertex.VertexGetCountsByConceptType;
import org.visallo.web.routes.vertex.VertexGetDetectedObjects;
import org.visallo.web.routes.vertex.VertexGetHistory;
import org.visallo.web.routes.vertex.VertexGetPropertyHistory;
import org.visallo.web.routes.vertex.VertexGetPropertyValue;
import org.visallo.web.routes.vertex.VertexGetResolvedTo;
import org.visallo.web.routes.vertex.VertexGetTermMentions;
import org.visallo.web.routes.vertex.VertexHighlightedText;
import org.visallo.web.routes.vertex.VertexImport;
import org.visallo.web.routes.vertex.VertexMultiple;
import org.visallo.web.routes.vertex.VertexNew;
import org.visallo.web.routes.vertex.VertexPosterFrame;
import org.visallo.web.routes.vertex.VertexProperties;
import org.visallo.web.routes.vertex.VertexPropertyDetails;
import org.visallo.web.routes.vertex.VertexRaw;
import org.visallo.web.routes.vertex.VertexRemove;
import org.visallo.web.routes.vertex.VertexSearch;
import org.visallo.web.routes.vertex.VertexSetProperty;
import org.visallo.web.routes.vertex.VertexSetPropertyVisibility;
import org.visallo.web.routes.vertex.VertexSetVisibility;
import org.visallo.web.routes.vertex.VertexThumbnail;
import org.visallo.web.routes.vertex.VertexUploadImage;
import org.visallo.web.routes.vertex.VertexVideoPreviewImage;
import org.visallo.web.routes.workspace.WorkspaceById;
import org.visallo.web.routes.workspace.WorkspaceCreate;
import org.visallo.web.routes.workspace.WorkspaceDelete;
import org.visallo.web.routes.workspace.WorkspaceDiff;
import org.visallo.web.routes.workspace.WorkspaceList;
import org.visallo.web.routes.workspace.WorkspacePublish;
import org.visallo.web.routes.workspace.WorkspaceUndo;
import org.visallo.web.routes.workspace.WorkspaceUpdate;

public class Router
extends HttpServlet {
    private static final long serialVersionUID = 4689515508877380905L;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(Router.class);
    private static final String JETTY_MULTIPART_CONFIG_ELEMENT8 = "org.eclipse.multipartConfig";
    private static final String JETTY_MULTIPART_CONFIG_ELEMENT9 = "org.eclipse.jetty.multipartConfig";
    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
    private static final String GRAPH_TRACE_ENABLE = "graphTraceEnable";
    private WebApp app;
    private org.visallo.core.config.Configuration configuration;
    private GeocoderRepository geocoderRepository;

    public Router(ServletContext servletContext) {
        try {
            Injector injector = (Injector)servletContext.getAttribute(Injector.class.getName());
            injector.injectMembers((Object)this);
            this.app = new WebApp(servletContext, injector);
            AuthenticationHandler authenticatorInstance = new AuthenticationHandler();
            Class<AuthenticationHandler> authenticator = AuthenticationHandler.class;
            Class<VisalloCsrfHandler> csrfProtector = VisalloCsrfHandler.class;
            this.app.get("/", new Class[]{UserAgentFilter.class, csrfProtector, Index.class});
            this.app.get("/configuration", new Class[]{csrfProtector, Configuration.class});
            this.app.post("/logout", new Class[]{csrfProtector, Logout.class});
            this.app.get("/ontology", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, Ontology.class});
            this.app.get("/notification/all", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, Notifications.class});
            this.app.post("/notification/mark-read", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, UserNotificationMarkRead.class});
            this.app.post("/notification/system", new Class[]{authenticator, csrfProtector, AdminPrivilegeFilter.class, SystemNotificationSave.class});
            this.app.delete("/notification/system", new Class[]{authenticator, csrfProtector, AdminPrivilegeFilter.class, SystemNotificationDelete.class});
            this.app.get("/resource", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ResourceGet.class});
            this.app.get("/resource/external", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ResourceExternalGet.class});
            this.app.get("/map/marker/image", new Class[]{csrfProtector, MapMarkerImage.class});
            if (!(this.geocoderRepository instanceof DefaultGeocoderRepository)) {
                this.configuration.set("web.ui.geocoder.enabled", (Object)true);
                this.app.get("/map/geocode", new Class[]{authenticator, GetGeocoder.class});
            }
            if (this.configuration.getBoolean("web.ui.mapzen.enabled", true)) {
                if (this.configuration.get("mapzen.tile.api.key", null) == null) {
                    LOGGER.warn("MapZen api key not found: %s", new Object[]{"mapzen.tile.api.key"});
                }
                this.app.get("/mapzen/{mapzenUri*}", new Class[]{authenticator, MapzenTileProxy.class});
            }
            this.app.post("/search/save", new Class[]{authenticator, csrfProtector, SearchSave.class});
            this.app.get("/search/all", new Class[]{authenticator, csrfProtector, SearchList.class});
            this.app.get("/search/run", new Class[]{authenticator, csrfProtector, SearchRun.class});
            this.app.post("/search/run", new Class[]{authenticator, csrfProtector, SearchRun.class});
            this.app.delete("/search", new Class[]{authenticator, csrfProtector, SearchDelete.class});
            this.app.get("/element/search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ElementSearch.class});
            this.app.post("/element/search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ElementSearch.class});
            this.app.delete("/vertex", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexRemove.class});
            this.app.get("/vertex/highlighted-text", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexHighlightedText.class});
            this.app.get("/vertex/raw", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexRaw.class});
            this.app.get("/vertex/exists", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexExists.class});
            this.app.post("/vertex/exists", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexExists.class});
            this.app.get("/vertex/thumbnail", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexThumbnail.class});
            this.app.get("/vertex/poster-frame", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexPosterFrame.class});
            this.app.get("/vertex/video-preview", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexVideoPreviewImage.class});
            this.app.get("/vertex/details", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexDetails.class});
            this.app.get("/vertex/history", new Class[]{authenticator, csrfProtector, HistoryReadPrivilegeFilter.class, VertexGetHistory.class});
            this.app.get("/vertex/property/details", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexPropertyDetails.class});
            this.app.post("/vertex/import", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexImport.class});
            this.app.post("/vertex/resolve-term", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, ResolveTermEntity.class});
            this.app.post("/vertex/unresolve-term", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, UnresolveTermEntity.class});
            this.app.post("/vertex/resolve-detected-object", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, ResolveDetectedObject.class});
            this.app.post("/vertex/unresolve-detected-object", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, UnresolveDetectedObject.class});
            this.app.get("/vertex/detected-objects", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGetDetectedObjects.class});
            this.app.get("/vertex/property", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGetPropertyValue.class});
            this.app.get("/vertex/property/history", new Class[]{authenticator, csrfProtector, HistoryReadPrivilegeFilter.class, VertexGetPropertyHistory.class});
            this.app.post("/vertex/property", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexSetProperty.class});
            this.app.post("/vertex/property/visibility", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexSetPropertyVisibility.class});
            this.app.post("/vertex/comment", new Class[]{authenticator, csrfProtector, CommentPrivilegeFilter.class, VertexSetProperty.class});
            this.app.delete("/vertex/property", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexDeleteProperty.class});
            this.app.delete("/vertex/comment", new Class[]{authenticator, csrfProtector, CommentPrivilegeFilter.class, VertexDeleteProperty.class});
            this.app.get("/vertex/term-mentions", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGetTermMentions.class});
            this.app.get("/vertex/resolved-to", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGetResolvedTo.class});
            this.app.post("/vertex/visibility", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexSetVisibility.class});
            this.app.get("/vertex/properties", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexProperties.class});
            this.app.get("/vertex/edges", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexEdges.class});
            this.app.post("/vertex/multiple", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexMultiple.class});
            this.app.post("/vertex/new", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexNew.class});
            this.app.get("/vertex/search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexSearch.class});
            this.app.post("/vertex/search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexSearch.class});
            this.app.get("/vertex/geo-search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGeoSearch.class});
            this.app.post("/vertex/upload-image", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, VertexUploadImage.class});
            this.app.get("/vertex/find-path", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexFindPath.class});
            this.app.post("/vertex/find-related", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexFindRelated.class});
            this.app.get("/vertex/counts-by-concept-type", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGetCountsByConceptType.class});
            this.app.get("/vertex/count", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, VertexGetCount.class});
            this.app.post("/edge/property", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, EdgeSetProperty.class});
            this.app.post("/edge/property/visibility", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, EdgeSetPropertyVisibility.class});
            this.app.post("/edge/comment", new Class[]{authenticator, csrfProtector, CommentPrivilegeFilter.class, EdgeSetProperty.class});
            this.app.delete("/edge", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, EdgeDelete.class});
            this.app.delete("/edge/property", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, EdgeDeleteProperty.class});
            this.app.delete("/edge/comment", new Class[]{authenticator, csrfProtector, CommentPrivilegeFilter.class, EdgeDeleteProperty.class});
            this.app.get("/edge/history", new Class[]{authenticator, csrfProtector, HistoryReadPrivilegeFilter.class, EdgeGetHistory.class});
            this.app.get("/edge/property/history", new Class[]{authenticator, csrfProtector, HistoryReadPrivilegeFilter.class, EdgeGetPropertyHistory.class});
            this.app.get("/edge/exists", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeExists.class});
            this.app.post("/edge/exists", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeExists.class});
            this.app.post("/edge/multiple", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeMultiple.class});
            this.app.post("/edge/create", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, EdgeCreate.class});
            this.app.get("/edge/properties", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeProperties.class});
            this.app.post("/edge/visibility", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, EdgeSetVisibility.class});
            this.app.get("/edge/property/details", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgePropertyDetails.class});
            this.app.get("/edge/details", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeDetails.class});
            this.app.get("/edge/count", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeGetCount.class});
            this.app.get("/edge/search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeSearch.class});
            this.app.post("/edge/search", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, EdgeSearch.class});
            this.app.get("/workspace/all", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, WorkspaceList.class});
            this.app.post("/workspace/create", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, WorkspaceCreate.class});
            this.app.get("/workspace/diff", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, WorkspaceDiff.class});
            this.app.post("/workspace/update", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, WorkspaceUpdate.class});
            this.app.get("/workspace", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, WorkspaceById.class});
            this.app.delete("/workspace", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, WorkspaceDelete.class});
            this.app.post("/workspace/publish", new Class[]{authenticator, csrfProtector, PublishPrivilegeFilter.class, WorkspacePublish.class});
            this.app.post("/workspace/undo", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, WorkspaceUndo.class});
            this.app.get("/dashboard/all", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, DashboardAll.class});
            this.app.post("/dashboard", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, DashboardUpdate.class});
            this.app.delete("/dashboard", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, DashboardDelete.class});
            this.app.post("/dashboard/item", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, DashboardItemUpdate.class});
            this.app.delete("/dashboard/item", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, DashboardItemDelete.class});
            this.app.get("/product/all", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ProductAll.class});
            this.app.get("/product", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ProductGet.class});
            this.app.get("/product/preview", new Class[]{authenticator, csrfProtector, ReadPrivilegeFilter.class, ProductPreview.class});
            this.app.post("/product", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, ProductUpdate.class});
            this.app.delete("/product", new Class[]{authenticator, csrfProtector, EditPrivilegeFilter.class, ProductDelete.class});
            this.app.get("/user/me", new Class[]{authenticator, csrfProtector, MeGet.class});
            this.app.post("/user/ui-preferences", new Class[]{authenticator, csrfProtector, UserSetUiPreferences.class});
            this.app.get("/user/all", new Class[]{authenticator, csrfProtector, UserList.class});
            this.app.post("/user/all", new Class[]{authenticator, csrfProtector, UserList.class});
            this.app.get("/user", new Class[]{authenticator, csrfProtector, AdminPrivilegeFilter.class, UserGet.class});
            this.app.get("/directory/get", new Class[]{authenticator, csrfProtector, DirectoryGet.class});
            this.app.get("/directory/search", new Class[]{authenticator, csrfProtector, DirectorySearch.class});
            this.app.get("/long-running-process", new Class[]{authenticator, csrfProtector, LongRunningProcessById.class});
            this.app.delete("/long-running-process", new Class[]{authenticator, csrfProtector, LongRunningProcessDelete.class});
            this.app.post("/long-running-process/cancel", new Class[]{authenticator, csrfProtector, LongRunningProcessCancel.class});
            this.app.get("/admin/all", new Class[]{authenticator, csrfProtector, AdminPrivilegeFilter.class, AdminList.class});
            this.app.get("/admin/plugins", new Class[]{authenticator, csrfProtector, AdminPrivilegeFilter.class, PluginList.class});
            this.app.post("/admin/upload-ontology", new Class[]{authenticator, csrfProtector, AdminPrivilegeFilter.class, AdminUploadOntology.class});
            this.app.get("/ping", new Class[]{RateLimitFilter.class, Ping.class});
            this.app.get("/ping/stats", new Class[]{authenticator, AdminPrivilegeFilter.class, PingStats.class});
            List webAppPlugins = IterableUtils.toList((Iterable)ServiceLoaderUtil.load(WebAppPlugin.class, (org.visallo.core.config.Configuration)this.configuration));
            for (WebAppPlugin webAppPlugin : webAppPlugins) {
                LOGGER.info("Loading webapp plugin: %s", new Object[]{webAppPlugin.getClass().getName()});
                try {
                    webAppPlugin.init(this.app, servletContext, (Handler)authenticatorInstance);
                }
                catch (Exception e) {
                    throw new VisalloException("Could not initialize webapp plugin: " + webAppPlugin.getClass().getName(), (Throwable)e);
                }
            }
            this.app.get("/css/images/ui-icons_222222_256x240.png", new Handler[]{new StaticResourceHandler(((Object)((Object)this)).getClass(), "/org/visallo/web/routes/resource/ui-icons_222222_256x240.png", "image/png")});
            this.app.onException(VisalloAccessDeniedException.class, new Handler[]{new ErrorCodeHandler(403)});
        }
        catch (Exception ex) {
            LOGGER.error("Failed to initialize Router", (Throwable)ex);
            throw new RuntimeException("Failed to initialize " + ((Object)((Object)this)).getClass().getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("servicing %s", new Object[]{request.getRequestURI()});
        TraceSpan trace = null;
        CurrentUser.setUserInLogMappedDiagnosticContexts(request);
        try {
            if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
                request.setAttribute(JETTY_MULTIPART_CONFIG_ELEMENT8, (Object)MULTI_PART_CONFIG);
                request.setAttribute(JETTY_MULTIPART_CONFIG_ELEMENT9, (Object)MULTI_PART_CONFIG);
            }
            if (this.isGraphTraceEnabled((ServletRequest)request)) {
                String traceDescription = request.getRequestURI();
                HashMap parameters = new HashMap();
                for (Map.Entry reqParameters : request.getParameterMap().entrySet()) {
                    parameters.put(reqParameters.getKey(), Joiner.on((String)", ").join((Object[])reqParameters.getValue()));
                }
                trace = Trace.on((String)traceDescription, parameters);
            }
            response.addHeader("Accept-Ranges", "bytes");
            this.app.handle(request, response);
        }
        catch (ConnectionClosedException cce) {
            LOGGER.debug("Connection closed by client", (Throwable)cce);
        }
        catch (Throwable e) {
            this.handleException(request, response, e);
        }
        finally {
            if (trace != null) {
                trace.close();
            }
            Trace.off();
            CurrentUser.clearUserFromLogMappedDiagnosticContexts();
        }
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) throws IOException, ServletException {
        if (e.getCause() instanceof VisalloResourceNotFoundException) {
            this.handleNotFound(response, (VisalloResourceNotFoundException)e.getCause());
            return;
        }
        if (e.getCause() instanceof BadRequestException) {
            this.handleBadRequest(response, (BadRequestException)e.getCause());
            return;
        }
        if (e.getCause() instanceof VisalloAccessDeniedException) {
            this.handleAccessDenied(response, (VisalloAccessDeniedException)e.getCause());
            return;
        }
        String message = String.format("Unhandled exception for %s %s", request.getMethod(), request.getRequestURI());
        if (this.app.isDevModeEnabled()) {
            throw new ServletException(message, e);
        }
        LOGGER.warn(message, e);
        response.sendError(500, e.getMessage());
    }

    private void handleAccessDenied(HttpServletResponse response, VisalloAccessDeniedException accessDenied) throws IOException {
        response.sendError(403, accessDenied.getMessage());
    }

    private void handleNotFound(HttpServletResponse response, VisalloResourceNotFoundException notFoundException) throws IOException {
        response.sendError(404, notFoundException.getMessage());
    }

    private void handleBadRequest(HttpServletResponse response, BadRequestException badRequestException) {
        LOGGER.error("bad request", (Throwable)badRequestException);
        JSONObject error = new JSONObject();
        error.put(badRequestException.getParameterName(), (Object)badRequestException.getMessage());
        if (badRequestException.getInvalidValues() != null) {
            JSONArray values = new JSONArray();
            for (String v : badRequestException.getInvalidValues()) {
                values.put((Object)v);
            }
            error.put("invalidValues", (Object)values);
        }
        response.setStatus(400);
        VisalloResponse.configureResponse(ResponseTypes.JSON_OBJECT, response, error);
    }

    private boolean isGraphTraceEnabled(ServletRequest req) {
        return req.getParameter(GRAPH_TRACE_ENABLE) != null || req instanceof HttpServletRequest && ((HttpServletRequest)req).getHeader(GRAPH_TRACE_ENABLE) != null;
    }

    @Inject
    public void setConfiguration(org.visallo.core.config.Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setGeocoderRepository(GeocoderRepository geocoderRepository) {
        this.geocoderRepository = geocoderRepository;
    }

    public WebApp getApp() {
        return this.app;
    }
}

