/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessOptions;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.RequestResponseHandler;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class LessResourceHandler
implements RequestResponseHandler {
    private static LessEngine lessCompiler;
    private String lessResourceName;

    public LessResourceHandler(String lessResourceName) {
        this.lessResourceName = lessResourceName;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) throws Exception {
        response.setContentType("text/css");
        try (InputStream input = this.getClass().getResourceAsStream(this.lessResourceName);
             StringWriter writer = new StringWriter();){
            IOUtils.copy((InputStream)input, (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String inputLess = writer.toString();
            String output = this.lessCompiler().compile(inputLess);
            try (PrintWriter outWriter = response.getWriter();){
                outWriter.println(output);
            }
        }
    }

    private synchronized LessEngine lessCompiler() {
        if (lessCompiler == null) {
            lessCompiler = new LessEngine();
            LessOptions options = new LessOptions();
            options.setCompress(true);
            options.setCharset("UTF-8");
            lessCompiler = new LessEngine(options);
        }
        return lessCompiler;
    }
}

