/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.RequestResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.util.js.BabelExecutor;
import org.visallo.web.util.js.CachedCompilation;
import org.visallo.web.util.js.SourceMapType;

public class JsxResourceHandler
implements RequestResponseHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(JsxResourceHandler.class);
    private static final BabelExecutor babelExecutor = new BabelExecutor();
    private String jsResourceName;
    private String jsResourcePath;
    private String toJsResourcePath;
    private SourceMapType sourceMapType;
    private Future<CachedCompilation> compilationTask;
    private volatile CachedCompilation previousCompilation;

    public JsxResourceHandler(String jsResourceName, String jsResourcePath, String toJsResourcePath) {
        this(jsResourceName, jsResourcePath, toJsResourcePath, SourceMapType.INLINE);
    }

    public JsxResourceHandler(String jsResourceName, String jsResourcePath, String toJsResourcePath, SourceMapType sourceMapType) {
        this.jsResourceName = jsResourceName;
        this.jsResourcePath = jsResourcePath;
        this.toJsResourcePath = toJsResourcePath;
        this.sourceMapType = sourceMapType;
        this.compilationTask = babelExecutor.submit(() -> this.compileIfNecessary(null));
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) throws Exception {
        CachedCompilation cache = this.getCache();
        if (request.getRequestURI().endsWith(".map")) {
            this.write(response, "application/json", cache.getSourceMap());
        } else if (request.getRequestURI().endsWith(".src")) {
            this.write(response, "application/javascript", cache.getInput());
        } else {
            if (this.sourceMapType == SourceMapType.EXTERNAL && cache.getSourceMap() != null) {
                response.setHeader("X-SourceMap", request.getRequestURI() + ".map");
            }
            this.write(response, "application/javascript", cache.getOutput());
        }
    }

    private CachedCompilation getCache() throws IOException, InterruptedException, ExecutionException, ScriptException {
        CachedCompilation cache;
        if (this.compilationTask == null) {
            cache = this.compileIfNecessary(this.previousCompilation);
        } else if (this.compilationTask.isDone()) {
            try {
                this.previousCompilation = this.compilationTask.get();
                this.compilationTask = null;
                cache = this.compileIfNecessary(this.previousCompilation);
            }
            catch (ExecutionException e) {
                cache = this.compileIfNecessary(this.previousCompilation);
            }
        } else {
            cache = this.compilationTask.get();
        }
        this.previousCompilation = cache;
        return cache;
    }

    private void write(HttpServletResponse response, String contentType, String output) throws IOException {
        if (output != null) {
            try (PrintWriter outWriter = response.getWriter();){
                response.setContentType(contentType);
                outWriter.println(output);
            }
        } else {
            throw new VisalloException("Errors during compilation: " + this.jsResourceName);
        }
    }

    private CachedCompilation compileIfNecessary(CachedCompilation previousCompilation) {
        block27: {
            try {
                URL url = this.getClass().getResource(this.jsResourceName);
                long lastModified = url.openConnection().getLastModified();
                if (previousCompilation != null && !previousCompilation.isNecessary(lastModified)) break block27;
                CachedCompilation newCache = new CachedCompilation();
                newCache.setLastModified(lastModified);
                try (InputStream input = this.getClass().getResourceAsStream(this.jsResourceName);
                     StringWriter writer = new StringWriter();){
                    IOUtils.copy((InputStream)input, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                    String inputJavascript = writer.toString();
                    newCache.setInput(inputJavascript);
                    newCache.setPath(this.toJsResourcePath);
                    newCache.setResourcePath(this.jsResourceName);
                    babelExecutor.compileWithSharedEngine(newCache, this.sourceMapType);
                }
                return newCache;
            }
            catch (IOException e) {
                throw new VisalloException("Unable to read last modified");
            }
            catch (ScriptException e) {
                LOGGER.error("%s in file %s", new Object[]{e.getCause().getMessage(), this.jsResourcePath.replaceAll("^\\/jsc", "")});
                return null;
            }
        }
        return previousCompilation;
    }
}

