/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.RequestResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.AbstractCommandLineRunner;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.BasicErrorManager;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.CheckLevel;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.CompilationLevel;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.Compiler;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.CompilerOptions;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.ErrorManager;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.JSError;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.Result;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.SourceFile;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.SourceMap;
import org.visallo.web.closurecompiler.com.google.javascript.jscomp.WarningLevel;
import org.visallo.web.util.js.CachedCompilation;

public class JavascriptResourceHandler
implements RequestResponseHandler {
    private static final int EXECUTOR_CONCURRENT = 3;
    private static final long EXECUTOR_IDLE_THREAD_RELEASE_SECONDS = 5L;
    private static final ThreadPoolExecutor compilationExecutor = new ThreadPoolExecutor(3, 3, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private String jsResourceName;
    private String jsResourcePath;
    private boolean enableSourceMaps;
    private String closureExternResourcePath;
    private Future<CachedCompilation> compilationTask;
    private volatile CachedCompilation previousCompilation;

    public JavascriptResourceHandler(String jsResourceName, String jsResourcePath, boolean enableSourceMaps) {
        this(jsResourceName, jsResourcePath, enableSourceMaps, null);
    }

    public JavascriptResourceHandler(String jsResourceName, String jsResourcePath, boolean enableSourceMaps, String closureExternResourcePath) {
        this.jsResourceName = jsResourceName;
        this.jsResourcePath = jsResourcePath;
        this.enableSourceMaps = enableSourceMaps;
        this.closureExternResourcePath = closureExternResourcePath;
        this.compilationTask = compilationExecutor.submit(() -> this.compileIfNecessary(null));
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) throws Exception {
        CachedCompilation cache = this.getCache();
        if (request.getRequestURI().endsWith(".map")) {
            this.write(response, "application/json", cache.getSourceMap());
        } else if (request.getRequestURI().endsWith(".src")) {
            this.write(response, "application/javascript", cache.getInput());
        } else {
            if (this.enableSourceMaps && cache.getSourceMap() != null) {
                response.setHeader("X-SourceMap", request.getRequestURI() + ".map");
            }
            this.write(response, "application/javascript", cache.getOutput());
        }
    }

    private CachedCompilation getCache() throws IOException, InterruptedException, ExecutionException {
        CachedCompilation cache;
        if (this.compilationTask == null) {
            cache = this.compileIfNecessary(this.previousCompilation);
        } else if (this.compilationTask.isDone()) {
            this.previousCompilation = this.compilationTask.get();
            this.compilationTask = null;
            cache = this.compileIfNecessary(this.previousCompilation);
        } else {
            cache = this.compilationTask.get();
        }
        this.previousCompilation = cache;
        return cache;
    }

    private void write(HttpServletResponse response, String contentType, String output) throws IOException {
        if (output != null) {
            try (PrintWriter outWriter = response.getWriter();){
                response.setContentType(contentType);
                outWriter.println(output);
            }
        } else {
            throw new VisalloException("Errors during minify: " + this.jsResourceName);
        }
    }

    private CachedCompilation compileIfNecessary(CachedCompilation previousCompilation) throws IOException {
        URL url = this.getClass().getResource(this.jsResourceName);
        long lastModified = url.openConnection().getLastModified();
        if (previousCompilation == null || previousCompilation.isNecessary(lastModified)) {
            CachedCompilation newCache = new CachedCompilation();
            newCache.setLastModified(lastModified);
            try (InputStream input = this.getClass().getResourceAsStream(this.jsResourceName);
                 StringWriter writer = new StringWriter();){
                IOUtils.copy((InputStream)input, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                String inputJavascript = writer.toString();
                newCache.setInput(inputJavascript);
                this.runClosureCompilation(newCache);
            }
            return newCache;
        }
        return previousCompilation;
    }

    private CachedCompilation runClosureCompilation(CachedCompilation cachedCompilation) throws IOException {
        Compiler.setLoggingLevel((Level)Level.INFO);
        Compiler compiler = new Compiler((ErrorManager)new JavascriptResourceHandlerErrorManager());
        CompilerOptions compilerOptions = new CompilerOptions();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(compilerOptions);
        WarningLevel.VERBOSE.setOptionsForWarningLevel(compilerOptions);
        compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT6);
        compilerOptions.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
        compilerOptions.setEnvironment(CompilerOptions.Environment.BROWSER);
        compilerOptions.setSourceMapOutputPath("");
        compilerOptions.setSourceMapFormat(SourceMap.Format.V3);
        compilerOptions.setSourceMapDetailLevel(SourceMap.DetailLevel.ALL);
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>();
        inputs.add(SourceFile.fromCode((String)(this.jsResourcePath + ".src"), (String)cachedCompilation.getInput()));
        List externs = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions)compilerOptions);
        InputStream visalloExterns = JavascriptResourceHandler.class.getResourceAsStream("visallo-externs.js");
        externs.add(SourceFile.fromInputStream((String)"visallo-externs.js", (InputStream)visalloExterns, (Charset)Charset.forName("UTF-8")));
        if (this.closureExternResourcePath != null) {
            externs.add(SourceFile.fromInputStream((String)this.closureExternResourcePath, (InputStream)this.getClass().getResourceAsStream(this.closureExternResourcePath), (Charset)Charset.forName("UTF-8")));
        }
        Result result = compiler.compile(externs, inputs, compilerOptions);
        if (result.success) {
            cachedCompilation.setOutput(compiler.toSource());
            if (this.enableSourceMaps) {
                StringBuilder sb = new StringBuilder();
                result.sourceMap.appendTo((Appendable)sb, this.jsResourcePath);
                cachedCompilation.setSourceMap(sb.toString());
            }
        }
        return cachedCompilation;
    }

    static {
        compilationExecutor.allowCoreThreadTimeOut(true);
    }

    private static class JavascriptResourceHandlerErrorManager
    extends BasicErrorManager {
        private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(JavascriptResourceHandlerErrorManager.class);

        private JavascriptResourceHandlerErrorManager() {
        }

        public void println(CheckLevel checkLevel, JSError jsError) {
            if (checkLevel.equals((Object)CheckLevel.ERROR)) {
                LOGGER.error("%s:%s %s", new Object[]{jsError.sourceName, jsError.getLineNumber(), jsError.description});
            }
        }

        protected void printSummary() {
            if (this.getErrorCount() > 0) {
                LOGGER.error("%d error(s)", new Object[]{this.getErrorCount()});
            }
        }
    }
}

