/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.MDC;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.SessionUser;
import org.visallo.web.util.RemoteAddressUtil;

public class CurrentUser {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(CurrentUser.class);
    public static final String SESSIONUSER_ATTRIBUTE_NAME = "user.current";
    public static final String STRING_ATTRIBUTE_NAME = "username";
    private static final String MDC_USER_ID = "userId";
    private static final String MDC_USER_NAME = "userName";
    private static final String MDC_CLIENT_IP_ADDRESS = "clientIpAddress";

    public static void set(HttpServletRequest request, String userId, String userName) {
        request.getSession().setAttribute(SESSIONUSER_ATTRIBUTE_NAME, (Object)new SessionUser(userId));
        request.getSession().setAttribute(STRING_ATTRIBUTE_NAME, (Object)userName);
    }

    public static String getUserId(HttpSession session) {
        SessionUser sessionUser = CurrentUser.getSessionUser(session);
        if (sessionUser == null) {
            LOGGER.debug("sessionUser is null", new Object[0]);
            return null;
        }
        return sessionUser.getUserId();
    }

    private static SessionUser getSessionUser(HttpSession session) {
        if (session == null) {
            LOGGER.debug("session is null", new Object[0]);
            return null;
        }
        try {
            return (SessionUser)session.getAttribute(SESSIONUSER_ATTRIBUTE_NAME);
        }
        catch (IllegalStateException e) {
            LOGGER.debug("Session has expired. Cannot read attributes.", new Object[0]);
            return null;
        }
    }

    private static String getSessionUserName(HttpSession session) {
        if (session == null) {
            LOGGER.debug("session is null", new Object[0]);
            return null;
        }
        return (String)session.getAttribute(STRING_ATTRIBUTE_NAME);
    }

    public static String getUserId(HttpServletRequest request) {
        return CurrentUser.getUserId(request.getSession(false));
    }

    public static void clearUserFromSession(HttpServletRequest request) {
        request.getSession().removeAttribute(SESSIONUSER_ATTRIBUTE_NAME);
        request.getSession().removeAttribute(STRING_ATTRIBUTE_NAME);
    }

    public static void clearUserFromLogMappedDiagnosticContexts() {
        MDC.remove((String)MDC_USER_ID);
        MDC.remove((String)MDC_USER_NAME);
        MDC.remove((String)MDC_CLIENT_IP_ADDRESS);
    }

    public static void setUserInLogMappedDiagnosticContexts(HttpServletRequest request) {
        String userName;
        String userId = CurrentUser.getUserId(request);
        if (userId != null) {
            MDC.put((String)MDC_USER_ID, (String)userId);
        }
        if ((userName = CurrentUser.getSessionUserName(request.getSession(false))) != null) {
            MDC.put((String)MDC_USER_NAME, (String)userName);
        }
        MDC.put((String)MDC_CLIENT_IP_ADDRESS, (String)RemoteAddressUtil.getClientIpAddr(request));
    }
}

