/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;

public class CacheServletFilter
implements Filter {
    private Configuration configuration;
    private Integer maxAge;

    public void init(FilterConfig filterConfig) throws ServletException {
        InjectHelper.inject((Object)this);
        String maxAgeString = this.configuration.get("web.cacheServletFilter.maxAge", null);
        if (maxAgeString != null) {
            this.maxAge = Integer.parseInt(maxAgeString);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse && this.maxAge != null) {
            ((HttpServletResponse)response).setHeader("Cache-Control", "max-age=" + this.maxAge);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

