/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.workspace;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import java.util.ArrayList;
import org.vertexium.Authorizations;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiWorkspace;

public class WorkspaceCreate
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceCreate.class);
    private static final String DEFAULT_WORKSPACE_TITLE = "Default";
    private final WorkspaceRepository workspaceRepository;
    private final WorkQueueRepository workQueueRepository;

    @Inject
    public WorkspaceCreate(WorkspaceRepository workspaceRepository, WorkQueueRepository workQueueRepository) {
        this.workspaceRepository = workspaceRepository;
        this.workQueueRepository = workQueueRepository;
    }

    @Handle
    public ClientApiWorkspace handle(@Optional(name="title") String title, User user, Authorizations authorizations) throws Exception {
        if (title == null) {
            title = "Default - " + user.getDisplayName();
        }
        Workspace workspace = this.workspaceRepository.add(title, user);
        LOGGER.info("Created workspace: %s, title: %s", new Object[]{workspace.getWorkspaceId(), workspace.getDisplayTitle()});
        ClientApiWorkspace clientApiWorkspace = this.workspaceRepository.toClientApi(workspace, user, true, authorizations);
        this.workQueueRepository.pushWorkspaceChange(clientApiWorkspace, new ArrayList(), user.getUserId(), null);
        return clientApiWorkspace;
    }
}

