/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import com.v5analytics.webster.resultWriters.ResultWriter;
import com.v5analytics.webster.resultWriters.ResultWriterBase;
import com.v5analytics.webster.resultWriters.ResultWriterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.security.ACLProvider;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.util.ObjectMapperFactory;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class VisalloDefaultResultWriterFactory
implements ResultWriterFactory {
    public static final String WEB_RESPONSE_HEADER_X_FRAME_OPTIONS = "web.response.header.X-Frame-Options";
    public static final String WEB_RESPONSE_HEADER_X_FRAME_OPTIONS_DEFAULT = "DENY";
    private final String responseHeaderXFrameOptions;
    private ACLProvider aclProvider;
    private UserRepository userRepository;

    @Inject
    public VisalloDefaultResultWriterFactory(ACLProvider aclProvider, UserRepository userRepository, Configuration configuration) {
        this.aclProvider = aclProvider;
        this.userRepository = userRepository;
        this.responseHeaderXFrameOptions = configuration.get(WEB_RESPONSE_HEADER_X_FRAME_OPTIONS, WEB_RESPONSE_HEADER_X_FRAME_OPTIONS_DEFAULT);
    }

    public ResultWriter createResultWriter(Method handleMethod) {
        return new ResultWriterBase(handleMethod){
            private boolean resultIsClientApiObject;
            private boolean resultIsInputStream;

            protected String getContentType(Method handleMethod) {
                if (JSONObject.class.equals(handleMethod.getReturnType())) {
                    return "application/json";
                }
                if (ClientApiObject.class.isAssignableFrom(handleMethod.getReturnType())) {
                    this.resultIsClientApiObject = true;
                    return "application/json";
                }
                if (InputStream.class.isAssignableFrom(handleMethod.getReturnType())) {
                    this.resultIsInputStream = true;
                }
                return super.getContentType(handleMethod);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void writeResult(HttpServletRequest request, HttpServletResponse response, Object result) throws IOException {
                block24: {
                    if (result != null) {
                        if (!response.containsHeader("X-Frame-Options")) {
                            response.addHeader("X-Frame-Options", VisalloDefaultResultWriterFactory.this.responseHeaderXFrameOptions);
                        }
                        if (!response.containsHeader("X-Content-Type-Options")) {
                            response.addHeader("X-Content-Type-Options", "nosniff");
                        }
                        response.setCharacterEncoding("UTF-8");
                        if (this.resultIsClientApiObject || result instanceof JSONObject) {
                            response.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                            response.addHeader("Pragma", "no-cache");
                            response.addHeader("Expires", "0");
                        }
                        if (this.resultIsClientApiObject) {
                            String jsonObject;
                            ClientApiObject clientApiObject = (ClientApiObject)result;
                            User user = VisalloBaseParameterProvider.getUser(request, VisalloDefaultResultWriterFactory.this.userRepository);
                            clientApiObject = VisalloDefaultResultWriterFactory.this.aclProvider.appendACL(clientApiObject, user);
                            try {
                                jsonObject = ObjectMapperFactory.getInstance().writeValueAsString((Object)clientApiObject);
                            }
                            catch (JsonProcessingException e) {
                                throw new VisalloException("Could not convert clientApiObject to string", (Throwable)e);
                            }
                            response.getWriter().write(jsonObject);
                        } else {
                            if (this.resultIsInputStream) {
                                try (InputStream in = (InputStream)result;){
                                    IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
                                    break block24;
                                }
                                finally {
                                    response.flushBuffer();
                                }
                            }
                            super.writeResult(request, response, result);
                        }
                    }
                }
            }
        };
    }
}

