/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.v5analytics.webster.App;
import com.v5analytics.webster.RequestResponseHandler;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.FetchHint;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.web.WebApp;

public abstract class MinimalRequestHandler
implements RequestResponseHandler {
    private static final String LOCALE_LANGUAGE_PARAMETER = "localeLanguage";
    private static final String LOCALE_COUNTRY_PARAMETER = "localeCountry";
    private static final String LOCALE_VARIANT_PARAMETER = "localeVariant";
    private final Configuration configuration;

    protected MinimalRequestHandler(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected WebApp getWebApp(HttpServletRequest request) {
        return (WebApp)App.getApp((HttpServletRequest)request);
    }

    protected Locale getLocale(HttpServletRequest request) {
        String language = this.getOptionalParameter(request, LOCALE_LANGUAGE_PARAMETER);
        String country = this.getOptionalParameter(request, LOCALE_COUNTRY_PARAMETER);
        String variant = this.getOptionalParameter(request, LOCALE_VARIANT_PARAMETER);
        if (language != null) {
            return WebApp.getLocal(language, country, variant);
        }
        return request.getLocale();
    }

    protected ResourceBundle getBundle(HttpServletRequest request) {
        WebApp webApp = this.getWebApp(request);
        Locale locale = this.getLocale(request);
        return webApp.getBundle(locale);
    }

    protected String getString(HttpServletRequest request, String key) {
        ResourceBundle resourceBundle = this.getBundle(request);
        return resourceBundle.getString(key);
    }

    protected String getRequiredParameter(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return this.getParameter(request, parameterName, false);
    }

    protected String[] getOptionalParameterArray(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return this.getParameterValues(request, parameterName, true);
    }

    protected String[] getRequiredParameterArray(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return this.getParameterValues(request, parameterName, false);
    }

    protected Long getOptionalParameterLong(HttpServletRequest request, String parameterName, long defaultValue) {
        Long defaultValueLong = defaultValue;
        return this.getOptionalParameterLong(request, parameterName, defaultValueLong);
    }

    protected Long getOptionalParameterLong(HttpServletRequest request, String parameterName, Long defaultValue) {
        String val = this.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Long.parseLong(val);
    }

    protected Integer getOptionalParameterInt(HttpServletRequest request, String parameterName, Integer defaultValue) {
        String val = this.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    protected EnumSet<FetchHint> getOptionalParameterFetchHints(HttpServletRequest request, String parameterName, EnumSet<FetchHint> defaultFetchHints) {
        String val = this.getOptionalParameter(request, parameterName);
        if (val == null) {
            return defaultFetchHints;
        }
        return EnumSet.copyOf(Lists.transform(Arrays.asList(val.split(",")), (Function)new Function<String, FetchHint>(){

            @Nullable
            public FetchHint apply(String input) {
                return FetchHint.valueOf((String)input);
            }
        }));
    }

    protected boolean getOptionalParameterBoolean(HttpServletRequest request, String parameterName, boolean defaultValue) {
        Boolean defaultValueBoolean = defaultValue;
        return this.getOptionalParameterBoolean(request, parameterName, defaultValueBoolean);
    }

    protected Boolean getOptionalParameterBoolean(HttpServletRequest request, String parameterName, Boolean defaultValue) {
        String val = this.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }

    protected Double getOptionalParameterDouble(HttpServletRequest request, String parameterName, Double defaultValue) {
        String val = this.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Double.parseDouble(val);
    }

    protected Float getOptionalParameterFloat(HttpServletRequest request, String parameterName, Float defaultValue) {
        String val = this.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Float.valueOf(Float.parseFloat(val));
    }

    protected long getRequiredParameterAsLong(HttpServletRequest request, String parameterName) {
        return Long.parseLong(this.getRequiredParameter(request, parameterName));
    }

    protected int getRequiredParameterAsInt(HttpServletRequest request, String parameterName) {
        return Integer.parseInt(this.getRequiredParameter(request, parameterName));
    }

    protected double getRequiredParameterAsDouble(HttpServletRequest request, String parameterName) {
        return Double.parseDouble(this.getRequiredParameter(request, parameterName));
    }

    protected String getOptionalParameter(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return this.getParameter(request, parameterName, true);
    }

    protected String[] getOptionalParameterAsStringArray(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return this.getParameterValues(request, parameterName, true);
    }

    protected String[] getParameterValues(HttpServletRequest request, String parameterName, boolean optional) {
        Object value;
        String[] paramValues = request.getParameterValues(parameterName);
        if (paramValues == null && (value = request.getAttribute(parameterName)) instanceof String[]) {
            paramValues = (String[])value;
        }
        if (paramValues == null) {
            if (!optional) {
                throw new VisalloException(String.format("Parameter: '%s' is required in the request", parameterName));
            }
            return null;
        }
        return paramValues;
    }

    private String getParameter(HttpServletRequest request, String parameterName, boolean optional) {
        String paramValue = request.getParameter(parameterName);
        if (paramValue == null) {
            Object paramValueObject = request.getAttribute(parameterName);
            if (paramValueObject != null) {
                paramValue = paramValueObject.toString();
            }
            if (paramValue == null) {
                if (!optional) {
                    throw new VisalloException(String.format("Parameter: '%s' is required in the request", parameterName));
                }
                return null;
            }
        }
        return paramValue;
    }

    protected String getAttributeString(HttpServletRequest request, String name) {
        String attr = (String)request.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        return this.getRequiredParameter(request, name);
    }
}

