/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.user;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.model.user.UserVisalloProperties;
import org.visallo.vertexium.model.user.VertexiumUser;

@RunWith(value=MockitoJUnitRunner.class)
public class VertexiumUserTest {
    @Mock
    private Vertex userVertex;

    @Test
    public void testGetCustomPropertiesFilterBuiltInProperties() {
        ArrayList<Property> properties = new ArrayList<Property>();
        Property builtInProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)builtInProp.getName()).thenReturn((Object)UserVisalloProperties.PASSWORD_HASH.getPropertyName());
        Mockito.when((Object)builtInProp.getValue()).thenReturn((Object)"secret");
        properties.add(builtInProp);
        Property notBuiltInProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)notBuiltInProp.getName()).thenReturn((Object)"otherProp");
        Mockito.when((Object)notBuiltInProp.getValue()).thenReturn((Object)"open");
        properties.add(notBuiltInProp);
        Mockito.when((Object)this.userVertex.getProperties()).thenReturn(properties);
        VertexiumUser user = new VertexiumUser(this.userVertex);
        Map customProperties = user.getCustomProperties();
        Assert.assertFalse((boolean)customProperties.containsKey(UserVisalloProperties.PASSWORD_HASH.getPropertyName()));
        Assert.assertTrue((boolean)customProperties.containsKey("otherProp"));
        Assert.assertEquals((Object)"open", customProperties.get("otherProp"));
    }
}

