/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.search;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.util.IterableUtils;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.search.SearchProperties;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.DirectVisibilityTranslator;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.vertexium.model.search.VertexiumSearchRepository;
import org.visallo.web.clientapi.model.ClientApiSearch;
import org.visallo.web.clientapi.model.ClientApiSearchListResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class VertexiumSearchRepositoryTest {
    private static final Visibility VISIBILITY = Visibility.EMPTY;
    private static final String USER1_ID = "USER123";
    private static final String USER2_ID = "USER456";
    private static final String WORKSPACE_ID = "WS123";
    private static final String ID = "123";
    private static final String NAME = "search1";
    private static final String ID2 = "456";
    private static final String NAME2 = "search2";
    private static final String URL = "/vertex/search";
    private static final JSONObject PARAMETERS = new JSONObject((Map)ImmutableMap.of((Object)"key1", (Object)"value1"));
    private VertexiumSearchRepository searchRepository;
    private InMemoryGraph graph;
    private Authorizations authorizations;
    @Mock
    private UserRepository userRepository;
    @Mock
    private GraphAuthorizationRepository graphAuthorizationRepository;
    @Mock
    private Configuration configuration;
    @Mock
    private User user1;
    @Mock
    private User user2;
    @Mock
    private Injector injector;
    @Mock
    private User systemUser;
    @Mock
    private AuthorizationRepository authorizationRepository;
    @Mock
    private PrivilegeRepository privilegeRepository;
    @Mock
    private WorkQueueRepository workQueueRepository;
    @Mock
    private WorkspaceRepository workspaceRepository;

    @Before
    public void setUp() {
        InjectHelper.setInjector((Injector)this.injector);
        this.graph = InMemoryGraph.create();
        this.authorizations = this.graph.createAuthorizations(new String[]{"search", "user"});
        DirectVisibilityTranslator visibilityTranslator = new DirectVisibilityTranslator();
        GraphRepository graphRepository = new GraphRepository((Graph)this.graph, (VisibilityTranslator)visibilityTranslator, null, this.workQueueRepository);
        this.searchRepository = new VertexiumSearchRepository((Graph)this.graph, graphRepository, this.userRepository, this.configuration, this.graphAuthorizationRepository, this.authorizationRepository, this.privilegeRepository, this.workspaceRepository);
        Mockito.when((Object)this.user1.getUserId()).thenReturn((Object)USER1_ID);
        Mockito.when((Object)this.user2.getUserId()).thenReturn((Object)USER2_ID);
        this.graph.addVertex(USER1_ID, VISIBILITY, this.authorizations);
        this.graph.addVertex(USER2_ID, VISIBILITY, this.authorizations);
        this.graph.flush();
        Mockito.when((Object)this.userRepository.getSystemUser()).thenReturn((Object)this.systemUser);
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)Matchers.eq((Object)this.systemUser), new String[]{(String)Matchers.eq((Object)"search")})).thenReturn((Object)this.authorizations);
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)Matchers.any(User.class), new String[]{(String)Matchers.eq((Object)"search"), (String)Matchers.eq((Object)"user")})).thenReturn((Object)this.authorizations);
    }

    @Test
    public void testSaveSearch() {
        String foundId = this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        Assert.assertEquals((Object)ID, (Object)foundId);
        Vertex userVertex = this.graph.getVertex(USER1_ID, this.authorizations);
        List hasSavedSearchEdges = IterableUtils.toList((Iterable)userVertex.getEdges(Direction.OUT, "http://visallo.org/search#hasSavedSearch", this.authorizations));
        Assert.assertEquals((long)1L, (long)hasSavedSearchEdges.size());
        Vertex savedSearchVertex = ((Edge)hasSavedSearchEdges.get(0)).getOtherVertex(USER1_ID, this.authorizations);
        Assert.assertEquals((Object)"http://visallo.org/search#savedSearch", (Object)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)savedSearchVertex, null));
        Assert.assertEquals((Object)NAME, (Object)SearchProperties.NAME.getPropertyValue((Element)savedSearchVertex, null));
        Assert.assertEquals((Object)URL, (Object)SearchProperties.URL.getPropertyValue((Element)savedSearchVertex, null));
        Assert.assertEquals((Object)PARAMETERS.toString(), (Object)((JSONObject)SearchProperties.PARAMETERS.getPropertyValueRequired((Element)savedSearchVertex)).toString());
    }

    @Test
    public void testSaveGlobalSearch() {
        try {
            this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
            Assert.fail((String)"Expected VisalloAccessDeniedException");
        }
        catch (VisalloAccessDeniedException visalloAccessDeniedException) {
            // empty catch block
        }
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        String foundId = this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
        Assert.assertEquals((Object)ID, (Object)foundId);
        Vertex savedSearchVertex = this.graph.getVertex(ID, this.authorizations);
        List hasSavedSearchEdges = IterableUtils.toList((Iterable)savedSearchVertex.getEdges(Direction.IN, "http://visallo.org/search#hasSavedSearch", this.authorizations));
        Assert.assertEquals((long)1L, (long)hasSavedSearchEdges.size());
        Assert.assertEquals((Object)"http://visallo.org/search#savedSearch", (Object)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)savedSearchVertex, null));
        Assert.assertEquals((Object)NAME, (Object)SearchProperties.NAME.getPropertyValue((Element)savedSearchVertex, null));
        Assert.assertEquals((Object)URL, (Object)SearchProperties.URL.getPropertyValue((Element)savedSearchVertex, null));
        Assert.assertEquals((Object)PARAMETERS.toString(), (Object)((JSONObject)SearchProperties.PARAMETERS.getPropertyValueRequired((Element)savedSearchVertex)).toString());
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)false);
        try {
            this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
            Assert.fail((String)"Expected VisalloAccessDeniedException");
        }
        catch (VisalloAccessDeniedException visalloAccessDeniedException) {
            // empty catch block
        }
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        foundId = this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        Assert.assertEquals((Object)ID, (Object)foundId);
    }

    @Test
    public void testSaveSearchAlternatingPrivateGlobalPrivate() {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        this.assertSavedSearchState(false);
        this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
        this.assertSavedSearchState(true);
        this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        this.assertSavedSearchState(false);
    }

    @Test
    public void testSaveSearchAlternatingGlobalPrivateGlobal() {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
        this.assertSavedSearchState(true);
        this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        this.assertSavedSearchState(false);
        this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
        this.assertSavedSearchState(true);
    }

    @Test
    public void testGetSavedSearches() {
        VertexBuilder vb = this.graph.prepareVertex(ID, VISIBILITY);
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)vb, (Object)"http://visallo.org/search#savedSearch", VISIBILITY);
        SearchProperties.NAME.setProperty((ElementMutation)vb, (Object)NAME, VISIBILITY);
        SearchProperties.URL.setProperty((ElementMutation)vb, (Object)URL, VISIBILITY);
        SearchProperties.PARAMETERS.setProperty((ElementMutation)vb, (Object)PARAMETERS, VISIBILITY);
        vb.save(this.authorizations);
        this.graph.addEdge(USER1_ID, ID, "http://visallo.org/search#hasSavedSearch", VISIBILITY, this.authorizations);
        this.graph.flush();
        ClientApiSearchListResponse response = this.searchRepository.getSavedSearches(this.user1);
        Assert.assertEquals((long)1L, (long)response.searches.size());
        for (ClientApiSearch search : response.searches) {
            if (search.id.equals(ID)) {
                this.assertSearch(search);
                continue;
            }
            throw new VisalloException("Invalid search item");
        }
    }

    @Test
    public void testGetSavedSearch() {
        VertexBuilder vb = this.graph.prepareVertex(ID, VISIBILITY);
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation)vb, (Object)"http://visallo.org/search#savedSearch", VISIBILITY);
        SearchProperties.NAME.setProperty((ElementMutation)vb, (Object)NAME, VISIBILITY);
        SearchProperties.URL.setProperty((ElementMutation)vb, (Object)URL, VISIBILITY);
        SearchProperties.PARAMETERS.setProperty((ElementMutation)vb, (Object)PARAMETERS, VISIBILITY);
        vb.save(this.authorizations);
        this.graph.addEdge(USER1_ID, ID, "http://visallo.org/search#hasSavedSearch", VISIBILITY, this.authorizations);
        this.graph.flush();
        ClientApiSearch search = this.searchRepository.getSavedSearch(ID, this.user1);
        this.assertSearch(search);
    }

    @Test
    public void testGetSavedSearchOnWorkspaceShouldReturnIfGlobal() {
        this.setupForSearchOnWorkspaceTests(true);
        this.assertSearch(this.searchRepository.getSavedSearchOnWorkspace(ID, this.user1, WORKSPACE_ID));
        this.assertSearch(this.searchRepository.getSavedSearchOnWorkspace(ID, this.user2, WORKSPACE_ID));
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, this.user2)).thenReturn((Object)false);
        this.assertSearch(this.searchRepository.getSavedSearchOnWorkspace(ID, this.user2, WORKSPACE_ID));
    }

    @Test
    public void testGetSavedSearchOnWorkspaceIfPrivate() {
        this.setupForSearchOnWorkspaceTests(false);
        this.assertSearch(this.searchRepository.getSavedSearchOnWorkspace(ID, this.user1, WORKSPACE_ID));
        this.assertSearch(this.searchRepository.getSavedSearchOnWorkspace(ID, this.user2, WORKSPACE_ID));
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, this.user2)).thenReturn((Object)false);
        Assert.assertEquals(null, (Object)this.searchRepository.getSavedSearchOnWorkspace(ID, this.user2, WORKSPACE_ID));
        this.searchRepository.saveSearch(ID2, NAME2, URL, PARAMETERS, this.user2);
        Assert.assertEquals(null, (Object)this.searchRepository.getSavedSearchOnWorkspace(ID2, this.user1, WORKSPACE_ID));
    }

    private void setupForSearchOnWorkspaceTests(boolean expectGlobal) {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        Mockito.when((Object)this.workspaceRepository.getCreatorUserId((String)Matchers.eq((Object)WORKSPACE_ID), (User)Matchers.any(User.class))).thenReturn((Object)USER1_ID);
        Mockito.when((Object)this.userRepository.findById(USER1_ID)).thenReturn((Object)this.user1);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, this.user1)).thenReturn((Object)true);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, this.user2)).thenReturn((Object)true);
        if (expectGlobal) {
            this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
        } else {
            this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        }
    }

    @Test
    public void testDeleteSearch() {
        String foundId = this.searchRepository.saveSearch(ID, NAME, URL, PARAMETERS, this.user1);
        Assert.assertEquals((Object)ID, (Object)foundId);
        this.searchRepository.deleteSearch(ID, this.user1);
        Assert.assertEquals(null, (Object)this.graph.getVertex(ID, this.authorizations));
    }

    @Test
    public void testDeleteGlobalSearch() {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        String foundId = this.searchRepository.saveGlobalSearch(ID, NAME, URL, PARAMETERS, this.user1);
        Assert.assertEquals((Object)ID, (Object)foundId);
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)false);
        try {
            this.searchRepository.deleteSearch(ID, this.user1);
            Assert.fail((String)"Expected VisalloAccessDeniedException");
        }
        catch (VisalloAccessDeniedException visalloAccessDeniedException) {
            // empty catch block
        }
        Mockito.when((Object)this.privilegeRepository.hasPrivilege(this.user1, "SEARCH_SAVE_GLOBAL")).thenReturn((Object)true);
        this.searchRepository.deleteSearch(ID, this.user1);
        Assert.assertEquals(null, (Object)this.graph.getVertex(ID, this.authorizations));
    }

    private void assertSearch(ClientApiSearch search) {
        Assert.assertEquals((Object)ID, (Object)search.id);
        Assert.assertEquals((Object)NAME, (Object)search.name);
        Assert.assertEquals((Object)URL, (Object)search.url);
        Assert.assertEquals((long)PARAMETERS.keySet().size(), (long)search.parameters.size());
        Assert.assertEquals((Object)PARAMETERS.getString("key1"), search.parameters.get("key1"));
    }

    private void assertSavedSearchState(boolean expectGlobal) {
        ClientApiSearchListResponse response = this.searchRepository.getSavedSearches(this.user1);
        Assert.assertEquals((long)1L, (long)response.searches.size());
        Assert.assertEquals((Object)this.searchRepository.isSearchGlobal(ID, this.authorizations), (Object)expectGlobal);
        Assert.assertEquals((Object)this.searchRepository.isSearchPrivateToUser(ID, this.user1, this.authorizations), (Object)(!expectGlobal ? 1 : 0));
    }
}

