/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.ontology;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.semanticweb.owlapi.model.IRI;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.inmemory.InMemoryAuthorizations;
import org.vertexium.inmemory.InMemoryGraph;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.lock.NonLockingLockRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.model.user.InMemoryGraphAuthorizationRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.DirectVisibilityTranslator;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.vertexium.model.ontology.VertexiumOntologyRepository;
import org.visallo.web.clientapi.model.PropertyType;

@RunWith(value=MockitoJUnitRunner.class)
public class VertexiumOntologyRepositoryTest {
    private static final String TEST_OWL = "test.owl";
    private static final String TEST_CHANGED_OWL = "test_changed.owl";
    private static final String TEST01_OWL = "test01.owl";
    private static final String TEST_IRI = "http://visallo.org/test";
    private static final String TEST_HIERARCHY_IRI = "http://visallo.org/testhierarchy";
    private static final String TEST_HIERARCHY_OWL = "test_hierarchy.owl";
    private static final String TEST01_IRI = "http://visallo.org/test01";
    private VertexiumOntologyRepository ontologyRepository;
    private Authorizations authorizations;
    private Graph graph;
    private GraphAuthorizationRepository graphAuthorizationRepository;
    private LockRepository lockRepository;
    private GraphRepository graphRepository;
    @Mock
    private Configuration configuration;
    @Mock
    private TermMentionRepository termMentionRepository;
    @Mock
    private WorkQueueRepository workQueueRepository;

    @Before
    public void setup() throws Exception {
        this.graph = InMemoryGraph.create();
        this.authorizations = new InMemoryAuthorizations(new String[0]);
        this.graphAuthorizationRepository = new InMemoryGraphAuthorizationRepository();
        this.lockRepository = new NonLockingLockRepository();
        DirectVisibilityTranslator visibilityTranslator = new DirectVisibilityTranslator();
        this.graphRepository = new GraphRepository(this.graph, (VisibilityTranslator)visibilityTranslator, this.termMentionRepository, this.workQueueRepository);
    }

    @Test
    public void changingDisplayAnnotationsShouldSucceed() throws Exception {
        this.loadTestOwlFile();
        File changedOwl = new File(VertexiumOntologyRepositoryTest.class.getResource(TEST_CHANGED_OWL).toURI());
        this.ontologyRepository.importFile(changedOwl, IRI.create((String)TEST_IRI), this.authorizations);
        this.validateChangedOwlRelationships();
        this.validateChangedOwlConcepts();
        this.validateChangedOwlProperties();
    }

    @Test
    public void testGettingParentConceptReturnsParentProperties() throws Exception {
        this.loadHierarchyOwlFile();
        Concept concept = this.ontologyRepository.getConceptByIRI("http://visallo.org/testhierarchy#person");
        Concept parentConcept = this.ontologyRepository.getParentConcept(concept);
        Assert.assertEquals((long)1L, (long)parentConcept.getProperties().size());
    }

    @Test
    public void dependenciesBetweenOntologyFilesShouldNotChangeParentProperties() throws Exception {
        this.loadTestOwlFile();
        File changedOwl = new File(VertexiumOntologyRepositoryTest.class.getResource(TEST01_OWL).toURI());
        this.ontologyRepository.importFile(changedOwl, IRI.create((String)TEST01_IRI), this.authorizations);
        this.validateTestOwlRelationship();
        this.validateTestOwlConcepts(1, 3);
        this.validateTestOwlProperties();
        OntologyProperty aliasProperty = this.ontologyRepository.getPropertyByIRI("http://visallo.org/test01#alias");
        Concept person = this.ontologyRepository.getConceptByIRI("http://visallo.org/test#person");
        Assert.assertTrue((boolean)person.getProperties().stream().anyMatch(p -> p.getIri().equals(aliasProperty.getIri())));
    }

    private void validateTestOwlRelationship() {
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI("http://visallo.org/test#personKnowsPerson");
        Assert.assertEquals((Object)"Knows", (Object)relationship.getDisplayName());
        Assert.assertEquals((Object)"prop('http://visallo.org/test#firstMet') || ''", (Object)relationship.getTimeFormula());
        Assert.assertTrue((boolean)relationship.getRangeConceptIRIs().contains("http://visallo.org/test#person"));
        Assert.assertTrue((boolean)relationship.getDomainConceptIRIs().contains("http://visallo.org/test#person"));
        relationship = this.ontologyRepository.getRelationshipByIRI("http://visallo.org/test#personIsRelatedToPerson");
        Assert.assertEquals((Object)"Is Related To", (Object)relationship.getDisplayName());
        String[] intents = relationship.getIntents();
        Assert.assertTrue((intents.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test", (Object)intents[0]);
        Assert.assertTrue((boolean)relationship.getRangeConceptIRIs().contains("http://visallo.org/test#person"));
        Assert.assertTrue((boolean)relationship.getDomainConceptIRIs().contains("http://visallo.org/test#person"));
    }

    private void validateTestOwlProperties() {
        OntologyProperty nameProperty = this.ontologyRepository.getPropertyByIRI("http://visallo.org/test#name");
        Assert.assertEquals((Object)"Name", (Object)nameProperty.getDisplayName());
        Assert.assertEquals((Object)PropertyType.STRING, (Object)nameProperty.getDataType());
        Assert.assertEquals((Object)"_.compact([\n            dependentProp('http://visallo.org/test#firstName'),\n            dependentProp('http://visallo.org/test#middleName'),\n            dependentProp('http://visallo.org/test#lastName')\n            ]).join(', ')", (Object)nameProperty.getDisplayFormula().trim());
        ImmutableList dependentPropertyIris = nameProperty.getDependentPropertyIris();
        Assert.assertEquals((long)3L, (long)dependentPropertyIris.size());
        Assert.assertTrue((boolean)dependentPropertyIris.contains((Object)"http://visallo.org/test#firstName"));
        Assert.assertTrue((boolean)dependentPropertyIris.contains((Object)"http://visallo.org/test#middleName"));
        Assert.assertTrue((boolean)dependentPropertyIris.contains((Object)"http://visallo.org/test#lastName"));
        List<String> intents = Arrays.asList(nameProperty.getIntents());
        Assert.assertEquals((long)1L, (long)intents.size());
        Assert.assertTrue((boolean)intents.contains("test3"));
        Assert.assertEquals((Object)"dependentProp('http://visallo.org/test#lastName') && dependentProp('http://visallo.org/test#firstName')", (Object)nameProperty.getValidationFormula());
        Assert.assertEquals((Object)"Personal Information", (Object)nameProperty.getPropertyGroup());
        Assert.assertEquals((Object)"test", (Object)nameProperty.getDisplayType());
        Assert.assertFalse((boolean)nameProperty.getAddable());
        Assert.assertFalse((boolean)nameProperty.getUpdateable());
        Assert.assertFalse((boolean)nameProperty.getDeleteable());
        Map possibleValues = nameProperty.getPossibleValues();
        Assert.assertEquals((long)2L, (long)possibleValues.size());
        Assert.assertEquals((Object)"test 1", possibleValues.get("T1"));
        Assert.assertEquals((Object)"test 2", possibleValues.get("T2"));
        Concept person = this.ontologyRepository.getConceptByIRI("http://visallo.org/test#person");
        Assert.assertTrue((boolean)person.getProperties().stream().anyMatch(p -> p.getIri().equals(nameProperty.getIri())));
        OntologyProperty firstMetProperty = this.ontologyRepository.getPropertyByIRI("http://visallo.org/test#firstMet");
        Assert.assertEquals((Object)"First Met", (Object)firstMetProperty.getDisplayName());
        Assert.assertEquals((Object)PropertyType.DATE, (Object)firstMetProperty.getDataType());
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI("http://visallo.org/test#personKnowsPerson");
        Assert.assertTrue((boolean)relationship.getProperties().stream().anyMatch(p -> p.getIri().equals(firstMetProperty.getIri())));
    }

    private void validateTestOwlConcepts(int expectedIntentSize, int expectedIriSize) throws IOException {
        Concept contact = this.ontologyRepository.getConceptByIRI("http://visallo.org/test#contact");
        Assert.assertEquals((Object)"Contact", (Object)contact.getDisplayName());
        Assert.assertEquals((Object)"rgb(149, 138, 218)", (Object)contact.getColor());
        Assert.assertEquals((Object)"test", (Object)contact.getDisplayType());
        List<String> intents = Arrays.asList(contact.getIntents());
        Assert.assertEquals((long)expectedIntentSize, (long)intents.size());
        Assert.assertTrue((boolean)intents.contains("face"));
        Concept person = this.ontologyRepository.getConceptByIRI("http://visallo.org/test#person");
        Assert.assertEquals((Object)"Person", (Object)person.getDisplayName());
        intents = Arrays.asList(person.getIntents());
        Assert.assertEquals((long)expectedIntentSize, (long)intents.size());
        Assert.assertTrue((boolean)intents.contains("person"));
        Assert.assertEquals((Object)"prop('http://visallo.org/test#birthDate') || ''", (Object)person.getTimeFormula());
        Assert.assertEquals((Object)"prop('http://visallo.org/test#name') || ''", (Object)person.getTitleFormula());
        byte[] bytes = IOUtils.toByteArray((InputStream)VertexiumOntologyRepositoryTest.class.getResourceAsStream("glyphicons_003_user@2x.png"));
        Assert.assertArrayEquals((byte[])bytes, (byte[])person.getGlyphIcon());
        Assert.assertEquals((Object)"rgb(28, 137, 28)", (Object)person.getColor());
        Set conceptAndAllChildren = this.ontologyRepository.getConceptAndAllChildren(contact);
        List iris = Lists.newArrayList();
        conceptAndAllChildren.stream().forEach(c -> iris.add(c.getIRI()));
        Assert.assertEquals((long)expectedIriSize, (long)iris.size());
        Assert.assertTrue((boolean)iris.contains(contact.getIRI()));
        Assert.assertTrue((boolean)iris.contains(person.getIRI()));
    }

    private void validateChangedOwlRelationships() throws IOException {
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI("http://visallo.org/test#personKnowsPerson");
        Assert.assertEquals((Object)"Person Knows Person", (Object)relationship.getDisplayName());
        Assert.assertNull((Object)relationship.getTimeFormula());
        Assert.assertFalse((boolean)relationship.getRangeConceptIRIs().contains("http://visallo.org/test#person2"));
        Assert.assertTrue((boolean)relationship.getRangeConceptIRIs().contains("http://visallo.org/test#person"));
        Assert.assertTrue((boolean)relationship.getDomainConceptIRIs().contains("http://visallo.org/test#person"));
    }

    private void validateChangedOwlConcepts() throws IOException {
        Concept contact = this.ontologyRepository.getConceptByIRI("http://visallo.org/test#contact");
        Concept person = this.ontologyRepository.getConceptByIRI("http://visallo.org/test#person");
        Assert.assertEquals((Object)"Person", (Object)person.getDisplayName());
        List<String> intents = Arrays.asList(person.getIntents());
        Assert.assertEquals((long)1L, (long)intents.size());
        Assert.assertFalse((boolean)intents.contains("person"));
        Assert.assertFalse((boolean)intents.contains("face"));
        Assert.assertTrue((boolean)intents.contains("test"));
        Assert.assertNull((Object)person.getTimeFormula());
        Assert.assertEquals((Object)"prop('http://visallo.org/test#name') || ''", (Object)person.getTitleFormula());
        Assert.assertNull((Object)person.getGlyphIcon());
        Assert.assertEquals((Object)"rgb(28, 137, 28)", (Object)person.getColor());
        Set conceptAndAllChildren = this.ontologyRepository.getConceptAndAllChildren(contact);
        List iris = Lists.newArrayList();
        conceptAndAllChildren.stream().forEach(c -> iris.add(c.getIRI()));
        Assert.assertEquals((long)2L, (long)iris.size());
        Assert.assertTrue((boolean)iris.contains(contact.getIRI()));
        Assert.assertTrue((boolean)iris.contains(person.getIRI()));
    }

    private void validateChangedOwlProperties() throws IOException {
        OntologyProperty nameProperty = this.ontologyRepository.getPropertyByIRI("http://visallo.org/test#name");
        Assert.assertEquals((Object)"http://visallo.org/test#name", (Object)nameProperty.getDisplayName());
        Assert.assertEquals((Object)PropertyType.STRING, (Object)nameProperty.getDataType());
        Assert.assertEquals((Object)"_.compact([\n            dependentProp('http://visallo.org/test#firstName'),\n            dependentProp('http://visallo.org/test#lastName')\n            ]).join(', ')", (Object)nameProperty.getDisplayFormula().trim());
        ImmutableList dependentPropertyIris = nameProperty.getDependentPropertyIris();
        Assert.assertEquals((long)3L, (long)dependentPropertyIris.size());
        Assert.assertTrue((boolean)dependentPropertyIris.contains((Object)"http://visallo.org/test#firstName"));
        Assert.assertTrue((boolean)dependentPropertyIris.contains((Object)"http://visallo.org/test#middleName"));
        Assert.assertTrue((boolean)dependentPropertyIris.contains((Object)"http://visallo.org/test#lastName"));
        List<String> intents = Arrays.asList(nameProperty.getIntents());
        Assert.assertEquals((long)1L, (long)intents.size());
        Assert.assertTrue((boolean)intents.contains("test3"));
        Assert.assertEquals((Object)"dependentProp('http://visallo.org/test#lastName') && dependentProp('http://visallo.org/test#firstName')", (Object)nameProperty.getValidationFormula());
        Assert.assertEquals((Object)"Personal Information", (Object)nameProperty.getPropertyGroup());
        Assert.assertEquals((Object)"test 2", (Object)nameProperty.getDisplayType());
        Assert.assertTrue((boolean)nameProperty.getAddable());
        Assert.assertTrue((boolean)nameProperty.getUpdateable());
        Assert.assertTrue((boolean)nameProperty.getDeleteable());
        Map possibleValues = nameProperty.getPossibleValues();
        Assert.assertNull((Object)possibleValues);
        OntologyProperty firstMetProperty = this.ontologyRepository.getPropertyByIRI("http://visallo.org/test#firstMet");
        Assert.assertEquals((Object)"First Met", (Object)firstMetProperty.getDisplayName());
        Assert.assertEquals((Object)PropertyType.DATE, (Object)firstMetProperty.getDataType());
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI("http://visallo.org/test#personKnowsPerson");
        Assert.assertTrue((boolean)relationship.getProperties().stream().anyMatch(p -> p.getIri().equals(firstMetProperty.getIri())));
    }

    private void loadTestOwlFile() throws Exception {
        this.createTestOntologyRepository(TEST_OWL, TEST_IRI);
        this.validateTestOwlRelationship();
        this.validateTestOwlConcepts(1, 2);
        this.validateTestOwlProperties();
    }

    private void loadHierarchyOwlFile() throws Exception {
        this.createTestOntologyRepository(TEST_HIERARCHY_OWL, TEST_HIERARCHY_IRI);
    }

    private VertexiumOntologyRepository createTestOntologyRepository(String owlFileResourcePath, String iri) throws Exception {
        this.ontologyRepository = new VertexiumOntologyRepository(this.graph, this.graphRepository, this.configuration, this.graphAuthorizationRepository, this.lockRepository){

            public void loadOntologies(Configuration config, Authorizations authorizations) throws Exception {
                Concept rootConcept = this.getOrCreateConcept(null, "http://visallo.org#root", "root", null);
                this.getOrCreateConcept(rootConcept, "http://www.w3.org/2002/07/owl#Thing", "thing", null);
                this.clearCache();
            }
        };
        File testOwl = new File(VertexiumOntologyRepositoryTest.class.getResource(owlFileResourcePath).toURI());
        this.ontologyRepository.importFile(testOwl, IRI.create((String)iri), this.authorizations);
        return this.ontologyRepository;
    }
}

