/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.ontology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.util.ConvertingIterable;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.OntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.Relationship;

public class InMemoryRelationship
extends Relationship {
    private String relationshipIRI;
    private String displayName;
    private List<Relationship> inverseOfs = new ArrayList<Relationship>();
    private List<String> intents = new ArrayList<String>();
    private boolean userVisible = true;
    private boolean deleteable;
    private boolean updateable;
    private String titleFormula;
    private String subtitleFormula;
    private String timeFormula;

    protected InMemoryRelationship(String parentIRI, String relationshipIRI, List<String> domainConceptIRIs, List<String> rangeConceptIRIs, Collection<OntologyProperty> properties) {
        super(parentIRI, domainConceptIRIs, rangeConceptIRIs, properties);
        this.relationshipIRI = relationshipIRI;
    }

    public String getIRI() {
        return this.relationshipIRI;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Iterable<String> getInverseOfIRIs() {
        return new ConvertingIterable<Relationship, String>(this.inverseOfs){

            protected String convert(Relationship o) {
                return o.getIRI();
            }
        };
    }

    public boolean getUserVisible() {
        return this.userVisible;
    }

    public boolean getDeleteable() {
        return this.deleteable;
    }

    public boolean getUpdateable() {
        return this.updateable;
    }

    public String getTitleFormula() {
        return this.titleFormula;
    }

    public String getSubtitleFormula() {
        return this.subtitleFormula;
    }

    public String getTimeFormula() {
        return this.timeFormula;
    }

    public String[] getIntents() {
        return this.intents.toArray(new String[this.intents.size()]);
    }

    public void addIntent(String intent, Authorizations authorizations) {
        this.intents.add(intent);
    }

    public void removeIntent(String intent, Authorizations authorizations) {
        this.intents.remove(intent);
    }

    public void setProperty(String name, Object value, Authorizations authorizations) {
        if (OntologyProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = (String)value;
        } else if (OntologyProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = (String)value;
        } else if (OntologyProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = (String)value;
        } else if (OntologyProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = (String)value;
        } else if (OntologyProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = (Boolean)value;
        } else if (OntologyProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = (Boolean)value;
        } else if (OntologyProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = (Boolean)value;
        }
    }

    public void removeProperty(String name, Authorizations authorizations) {
        if (OntologyProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = null;
        } else if (OntologyProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = null;
        } else if (OntologyProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = null;
        } else {
            throw new VisalloException("Remove not implemented for property " + name);
        }
    }

    public void addInverseOf(Relationship inverseOfRelationship) {
        this.inverseOfs.add(inverseOfRelationship);
    }
}

