/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.ontology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.vertexium.Authorizations;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyProperties;
import org.visallo.core.util.JSONUtil;

public class InMemoryConcept
extends Concept {
    private String title;
    private String color;
    private String displayName;
    private String displayType;
    private String titleFormula;
    private String subtitleFormula;
    private String timeFormula;
    private String conceptIRI;
    private List<String> addRelatedConceptWhiteList;
    private byte[] glyphIcon;
    private byte[] glyphIconSelected;
    private byte[] mapGlyphIcon;
    private boolean userVisible = true;
    private boolean updateable = true;
    private boolean deleteable = true;
    private Boolean searchable;
    private Boolean addable;
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<String> intents = new ArrayList<String>();

    public InMemoryConcept(String conceptIRI, String parentIRI) {
        super(parentIRI, new ArrayList());
        this.conceptIRI = conceptIRI;
    }

    public String getIRI() {
        return this.conceptIRI;
    }

    public String[] getIntents() {
        return this.intents.toArray(new String[this.intents.size()]);
    }

    public void addIntent(String intent, Authorizations authorizations) {
        this.intents.add(intent);
    }

    public void removeIntent(String intent, Authorizations authorizations) {
        this.intents.remove(intent);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasGlyphIconResource() {
        return this.glyphIcon != null;
    }

    public boolean hasGlyphIconSelectedResource() {
        return this.glyphIconSelected != null;
    }

    public String getColor() {
        return this.color;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getTitleFormula() {
        return this.titleFormula;
    }

    public Boolean getSearchable() {
        return this.searchable;
    }

    public String getSubtitleFormula() {
        return this.subtitleFormula;
    }

    public String getTimeFormula() {
        return this.timeFormula;
    }

    public boolean getUserVisible() {
        return this.userVisible;
    }

    public boolean getDeleteable() {
        return this.deleteable;
    }

    public boolean getUpdateable() {
        return this.updateable;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<String> getAddRelatedConceptWhiteList() {
        return this.addRelatedConceptWhiteList;
    }

    public void setProperty(String name, Object value, Authorizations authorizations) {
        if (OntologyProperties.COLOR.getPropertyName().equals(name)) {
            this.color = (String)value;
        } else if (OntologyProperties.DISPLAY_TYPE.getPropertyName().equals(name)) {
            this.displayType = (String)value;
        } else if (OntologyProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = (String)value;
        } else if (OntologyProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = (String)value;
        } else if (OntologyProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = (String)value;
        } else if (OntologyProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = (Boolean)value;
        } else if (OntologyProperties.GLYPH_ICON.getPropertyName().equals(name)) {
            this.glyphIcon = (byte[])value;
        } else if (OntologyProperties.GLYPH_ICON_SELECTED.getPropertyName().equals(name)) {
            this.glyphIconSelected = (byte[])value;
        } else if (OntologyProperties.MAP_GLYPH_ICON.getPropertyName().equals(name)) {
            this.mapGlyphIcon = (byte[])value;
        } else if (OntologyProperties.TITLE.getPropertyName().equals(name)) {
            this.title = (String)value;
        } else if (OntologyProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = (String)value;
        } else if (OntologyProperties.ADD_RELATED_CONCEPT_WHITE_LIST.getPropertyName().equals(name)) {
            this.addRelatedConceptWhiteList = JSONUtil.toStringList((JSONArray)JSONUtil.parseArray((String)((String)value)));
        } else if (OntologyProperties.SEARCHABLE.getPropertyName().equals(name)) {
            this.searchable = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.parseBoolean((String)value));
        } else if (OntologyProperties.ADDABLE.getPropertyName().equals(name)) {
            this.addable = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(Boolean.parseBoolean((String)value));
        } else if (OntologyProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else if (OntologyProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else {
            this.metadata.put(name, value.toString());
        }
    }

    public void removeProperty(String name, Authorizations authorizations) {
        if (OntologyProperties.TITLE_FORMULA.getPropertyName().equals(name)) {
            this.titleFormula = null;
        } else if (OntologyProperties.SUBTITLE_FORMULA.getPropertyName().equals(name)) {
            this.subtitleFormula = null;
        } else if (OntologyProperties.TIME_FORMULA.getPropertyName().equals(name)) {
            this.timeFormula = null;
        } else {
            throw new VisalloException("Remove not implemented for property " + name);
        }
    }

    public byte[] getGlyphIcon() {
        return this.glyphIcon;
    }

    public byte[] getGlyphIconSelected() {
        return this.glyphIconSelected;
    }

    public byte[] getMapGlyphIcon() {
        return this.mapGlyphIcon;
    }

    public String getConceptIRI() {
        return this.conceptIRI;
    }
}

