/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.vertexium.Element;
import org.vertexium.query.Query;
import org.visallo.core.exception.VisalloException;

public class StreamUtil {
    private StreamUtil() {
    }

    public static Stream<Element> stream(Query ... queries) {
        return Arrays.stream(queries).map(query -> StreamSupport.stream(query.elements().spliterator(), false)).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Iterable<T> ... iterables) {
        List<Iterator> iterators = Arrays.stream(iterables).map(Iterable::iterator).collect(Collectors.toList());
        return StreamUtil.stream(iterators.toArray(new Iterator[iterables.length]));
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Iterator<T> ... iterators) {
        return StreamUtil.withCloseHandler(Arrays.stream(iterators).map(StreamUtil::streamForIterator).reduce(Stream::concat).orElseGet(Stream::empty), iterators);
    }

    @SafeVarargs
    private static <T> Stream<T> withCloseHandler(Stream<T> stream, Iterator<T> ... iterators) {
        stream.onClose(() -> {
            for (Iterator iterator : iterators) {
                if (!(iterator instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception ex) {
                    throw new VisalloException(String.format("exception occurred when closing %s", iterator.getClass().getName()), ex);
                }
            }
        });
        return stream;
    }

    private static <T> Stream<T> streamForIterator(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }
}

