/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.security;

import org.vertexium.Visibility;

public class VisalloVisibility {
    public static final String SUPER_USER_VISIBILITY_STRING = "visallo";
    private final Visibility visibility;

    public VisalloVisibility() {
        this.visibility = new Visibility("");
    }

    public VisalloVisibility(String visibility) {
        this.visibility = visibility == null || visibility.length() == 0 ? new Visibility("") : this.addSuperUser(visibility);
    }

    public VisalloVisibility(Visibility visibility) {
        this.visibility = visibility == null || visibility.getVisibilityString().length() == 0 || visibility.getVisibilityString().contains(SUPER_USER_VISIBILITY_STRING) ? visibility : this.addSuperUser(visibility.getVisibilityString());
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    private Visibility addSuperUser(String visibility) {
        return new Visibility("(" + visibility + ")|" + SUPER_USER_VISIBILITY_STRING);
    }

    public String toString() {
        return this.getVisibility().toString();
    }

    public static Visibility and(Visibility visibility, String additionalVisibility) {
        if (visibility.getVisibilityString().length() == 0) {
            return new Visibility(additionalVisibility);
        }
        return new Visibility("(" + visibility.getVisibilityString() + ")&(" + additionalVisibility + ")");
    }

    public static Visibility or(Visibility visibility, String additionalVisibility) {
        if (visibility.getVisibilityString().length() == 0) {
            return new Visibility(additionalVisibility);
        }
        return new Visibility("(" + visibility.getVisibilityString() + ")|(" + additionalVisibility + ")");
    }
}

