/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.textHighlighting;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.web.clientapi.model.SandboxStatus;

public abstract class OffsetItem
implements Comparable {
    public static final int VIDEO_TRANSCRIPT_INDEX_BITS = 12;
    public static final int VIDEO_TRANSCRIPT_OFFSET_BITS = 20;

    public abstract long getStart();

    public int getVideoTranscriptEntryIndex() {
        return (int)(this.getStart() >> 20);
    }

    public abstract long getEnd();

    public abstract String getType();

    public abstract String getId();

    public abstract String getProcess();

    public String getOutVertexId() {
        return null;
    }

    public String getResolvedToVertexId() {
        return null;
    }

    public String getResolvedToEdgeId() {
        return null;
    }

    public abstract TermMentionFor getTermMentionFor();

    public abstract SandboxStatus getSandboxStatus();

    public JSONObject getInfoJson() {
        try {
            JSONObject infoJson = new JSONObject();
            infoJson.put("id", (Object)this.getId());
            infoJson.put("start", this.getStart());
            infoJson.put("end", this.getEnd());
            infoJson.put("outVertexId", (Object)this.getOutVertexId());
            infoJson.put("sandboxStatus", (Object)this.getSandboxStatus().toString());
            if (this.getResolvedToVertexId() != null) {
                infoJson.put("resolvedToVertexId", (Object)this.getResolvedToVertexId());
            }
            if (this.getResolvedToEdgeId() != null) {
                infoJson.put("resolvedToEdgeId", (Object)this.getResolvedToEdgeId());
            }
            infoJson.put("type", (Object)this.getType());
            if (this.getTermMentionFor() != null) {
                infoJson.put("termMentionFor", (Object)this.getTermMentionFor().toString());
            }
            infoJson.put("process", (Object)this.getProcess());
            return infoJson;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getCssClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        if (this.getResolvedToVertexId() != null) {
            classes.add("resolved");
        }
        return classes;
    }

    public JSONObject toJson() {
        try {
            JSONObject json = new JSONObject();
            json.put("info", (Object)this.getInfoJson());
            JSONArray cssClasses = new JSONArray();
            for (String cssClass : this.getCssClasses()) {
                cssClasses.put((Object)cssClass);
            }
            json.put("cssClasses", (Object)cssClasses);
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldHighlight() {
        return true;
    }

    public String getTitle() {
        return null;
    }

    public String toString() {
        return "id: " + this.getId() + ", start: " + this.getStart() + ", end: " + this.getEnd() + ", title: " + this.getTitle();
    }

    public int compareTo(Object o) {
        if (!(o instanceof OffsetItem)) {
            return -1;
        }
        OffsetItem other = (OffsetItem)o;
        if (OffsetItem.getOffset(this.getStart()) != OffsetItem.getOffset(other.getStart())) {
            return OffsetItem.getOffset(this.getStart()) < OffsetItem.getOffset(other.getStart()) ? -1 : 1;
        }
        if (OffsetItem.getOffset(this.getEnd()) != OffsetItem.getOffset(other.getEnd())) {
            return OffsetItem.getOffset(this.getEnd()) < OffsetItem.getOffset(other.getEnd()) ? -1 : 1;
        }
        int termMentionForCompare = TermMentionFor.compare(this.getTermMentionFor(), other.getTermMentionFor());
        if (termMentionForCompare != 0) {
            return termMentionForCompare;
        }
        if (this.getResolvedToVertexId() == null && other.getResolvedToVertexId() == null) {
            return 0;
        }
        if (this.getResolvedToVertexId() == null) {
            return 1;
        }
        if (other.getResolvedToVertexId() == null) {
            return -1;
        }
        return this.getResolvedToVertexId().compareTo(other.getResolvedToVertexId());
    }

    public static long getOffset(long offset) {
        return offset & 0xFFFFFL;
    }
}

