/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.graph;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Date;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.Element;
import org.vertexium.ElementBuilder;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.PropertyJustificationMetadata;
import org.visallo.core.model.graph.VisibilityAndElementMutation;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.VertexiumMetadataUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;

public class GraphRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphRepository.class);
    public static final String VISALLO_VERSION_KEY = "visallo.version";
    public static final int VISALLO_VERSION = 3;
    public static final double SET_PROPERTY_CONFIDENCE = 0.5;
    private final Graph graph;
    private final VisibilityTranslator visibilityTranslator;
    private final TermMentionRepository termMentionRepository;

    @Inject
    public GraphRepository(Graph graph, VisibilityTranslator visibilityTranslator, TermMentionRepository termMentionRepository) {
        this.graph = graph;
        this.visibilityTranslator = visibilityTranslator;
        this.termMentionRepository = termMentionRepository;
    }

    public void verifyVersion() {
        this.verifyVersion(3);
    }

    public void verifyVersion(int requiredVersion) {
        Object version = this.graph.getMetadata(VISALLO_VERSION_KEY);
        if (version == null) {
            this.writeVersion();
            return;
        }
        if (!(version instanceof Integer)) {
            throw new VisalloException("Invalid visallo.version found. Expected Integer, found " + version.getClass().getName());
        }
        Integer versionInt = (Integer)version;
        if (versionInt != requiredVersion) {
            throw new VisalloException("Invalid visallo.version found. Expected " + requiredVersion + ", found " + versionInt);
        }
        LOGGER.info("Visallo graph version verified: %d", versionInt);
    }

    public void writeVersion() {
        this.writeVersion(3);
    }

    public void writeVersion(int version) {
        this.graph.setMetadata(VISALLO_VERSION_KEY, (Object)version);
        LOGGER.info("Wrote %s: %d", VISALLO_VERSION_KEY, version);
    }

    public <T extends Element> VisibilityAndElementMutation<T> updateElementVisibilitySource(Element element, SandboxStatus sandboxStatus, String visibilitySource, String workspaceId, Authorizations authorizations) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(element);
        visibilityJson = sandboxStatus != SandboxStatus.PUBLIC ? VisibilityJson.updateVisibilitySourceAndAddWorkspaceId((VisibilityJson)visibilityJson, (String)visibilitySource, (String)workspaceId) : VisibilityJson.updateVisibilitySource((VisibilityJson)visibilityJson, (String)visibilitySource);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        Visibility visibility = visalloVisibility.getVisibility();
        ExistingElementMutation m = element.prepareMutation().alterElementVisibility(visibility);
        if (VisalloProperties.VISIBILITY_JSON.hasProperty(element)) {
            Property visibilityJsonProperty = VisalloProperties.VISIBILITY_JSON.getProperty(element);
            m.alterPropertyVisibility(visibilityJsonProperty.getKey(), VisalloProperties.VISIBILITY_JSON.getPropertyName(), defaultVisibility);
        }
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation<?>)m, visibilityJson, defaultVisibility);
        if (VisalloProperties.CONCEPT_TYPE.hasProperty(element)) {
            Property conceptTypeProperty = VisalloProperties.CONCEPT_TYPE.getProperty(element);
            m.alterPropertyVisibility(conceptTypeProperty.getKey(), VisalloProperties.CONCEPT_TYPE.getPropertyName(), visibility);
            Metadata metadata = conceptTypeProperty.getMetadata();
            VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, defaultVisibility);
        }
        m.save(authorizations);
        return new VisibilityAndElementMutation(visalloVisibility, m);
    }

    public <T extends Element> Property updatePropertyVisibilitySource(Element element, String propertyKey, String propertyName, String oldVisibilitySource, String newVisibilitySource, String workspaceId, User user, Authorizations authorizations) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        Property property = this.getProperty(element, propertyKey, propertyName, oldVisibilitySource, workspaceId);
        if (property == null) {
            throw new VisalloResourceNotFoundException("Could not find property " + propertyKey + ":" + propertyName + " on element " + element.getId());
        }
        VisibilityJson newVisibilityJson = new VisibilityJson(newVisibilitySource);
        Visibility newVisibility = this.visibilityTranslator.toVisibility(newVisibilityJson).getVisibility();
        LOGGER.info("%s Altering property visibility %s [%s:%s] from [%s] to [%s]", user.getUserId(), element.getId(), propertyKey, propertyName, oldVisibilitySource, newVisibility.toString());
        ExistingElementMutation m = element.prepareMutation().alterPropertyVisibility(property, newVisibility);
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(m, property, newVisibilityJson, defaultVisibility);
        Element newElement = m.save(authorizations);
        Property newProperty = newElement.getProperty(propertyKey, propertyName, newVisibility);
        Preconditions.checkNotNull((Object)newProperty, (Object)("Could not find altered property " + propertyKey + ":" + propertyName + " on element " + element.getId()));
        return newProperty;
    }

    private Property getProperty(Element element, String propertyKey, String propertyName, String visibilitySource, String workspaceId) {
        Property property = element.getProperty(propertyKey, propertyName, this.getVisibilityWithWorkspace(visibilitySource, workspaceId));
        if (property == null) {
            property = element.getProperty(propertyKey, propertyName, this.getVisibilityWithWorkspace(visibilitySource, null));
        }
        return property;
    }

    public <T extends Element> VisibilityAndElementMutation<T> setProperty(T element, String propertyName, String propertyKey, Object value, Metadata metadata, String oldVisibilitySource, String newVisibilitySource, String workspaceId, String justificationText, ClientApiSourceInfo sourceInfo, User user, Authorizations authorizations) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        Visibility oldPropertyVisibility = this.getVisibilityWithWorkspace(oldVisibilitySource, workspaceId);
        Property oldProperty = element.getProperty(propertyKey, propertyName, oldPropertyVisibility);
        boolean isUpdate = oldProperty != null;
        Metadata propertyMetadata = isUpdate ? oldProperty.getMetadata() : new Metadata();
        propertyMetadata = VertexiumMetadataUtil.mergeMetadata(propertyMetadata, metadata);
        ExistingElementMutation elementMutation = element.prepareMutation();
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)newVisibilitySource, (String)workspaceId);
        VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(propertyMetadata, visibilityJson, defaultVisibility);
        VisalloProperties.MODIFIED_DATE_METADATA.setMetadata(propertyMetadata, new Date(), defaultVisibility);
        VisalloProperties.MODIFIED_BY_METADATA.setMetadata(propertyMetadata, user.getUserId(), defaultVisibility);
        VisalloProperties.CONFIDENCE_METADATA.setMetadata(propertyMetadata, Double.valueOf(0.5), defaultVisibility);
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        Visibility propertyVisibility = visalloVisibility.getVisibility();
        if (justificationText != null) {
            PropertyJustificationMetadata propertyJustificationMetadata = new PropertyJustificationMetadata(justificationText);
            this.termMentionRepository.removeSourceInfoEdge(element, propertyKey, propertyName, visalloVisibility, authorizations);
            VisalloProperties.JUSTIFICATION_METADATA.setMetadata(propertyMetadata, propertyJustificationMetadata, defaultVisibility);
        } else if (sourceInfo != null) {
            Vertex outVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            VisalloProperties.JUSTIFICATION.removeMetadata(propertyMetadata);
            this.termMentionRepository.addSourceInfo(element, element.getId(), TermMentionFor.PROPERTY, propertyKey, propertyName, propertyVisibility, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, outVertex, propertyVisibility, authorizations);
        }
        Property publicProperty = element.getProperty(propertyKey, propertyName);
        if (publicProperty != null && workspaceId != null && SandboxStatus.getFromVisibilityString((String)publicProperty.getVisibility().getVisibilityString(), (String)workspaceId) == SandboxStatus.PUBLIC) {
            element.markPropertyHidden(publicProperty, new Visibility(workspaceId), authorizations);
        } else if (isUpdate && oldVisibilitySource != null && !oldVisibilitySource.equals(newVisibilitySource)) {
            elementMutation.alterPropertyVisibility(oldProperty, propertyVisibility);
        }
        elementMutation.addPropertyValue(propertyKey, propertyName, value, propertyMetadata, propertyVisibility);
        return new VisibilityAndElementMutation(visalloVisibility, elementMutation);
    }

    private Visibility getVisibilityWithWorkspace(String visibilitySource, String workspaceId) {
        Visibility visibility = null;
        if (visibilitySource != null) {
            VisibilityJson oldVisibilityJson = new VisibilityJson();
            oldVisibilityJson.setSource(visibilitySource);
            oldVisibilityJson.addWorkspace(workspaceId);
            visibility = this.visibilityTranslator.toVisibility(oldVisibilityJson).getVisibility();
        }
        return visibility;
    }

    public Vertex addVertex(String vertexId, String conceptType, String visibilitySource, String workspaceId, String justificationText, ClientApiSourceInfo sourceInfo, User user, Authorizations authorizations) {
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)visibilitySource, (String)workspaceId);
        return this.addVertex(vertexId, conceptType, visibilityJson, justificationText, sourceInfo, user, authorizations);
    }

    public Vertex addVertex(String vertexId, String conceptType, VisibilityJson visibilityJson, String justificationText, ClientApiSourceInfo sourceInfo, User user, Authorizations authorizations) {
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        VertexBuilder vertexBuilder = vertexId != null ? this.graph.prepareVertex(vertexId, visalloVisibility.getVisibility()) : this.graph.prepareVertex(visalloVisibility.getVisibility());
        this.updateElementMetadataProperties((ElementBuilder)vertexBuilder, conceptType, visibilityJson, user);
        boolean justificationAdded = this.addJustification((ElementBuilder)vertexBuilder, justificationText, visalloVisibility, visibilityJson, user);
        Vertex vertex = vertexBuilder.save(authorizations);
        this.graph.flush();
        if (justificationAdded) {
            this.termMentionRepository.removeSourceInfoEdgeFromVertex(vertex.getId(), vertex.getId(), null, null, visalloVisibility, authorizations);
        } else if (sourceInfo != null) {
            VisalloProperties.JUSTIFICATION.removeProperty((ElementMutation)vertexBuilder, visalloVisibility.getVisibility());
            Vertex sourceDataVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            this.termMentionRepository.addSourceInfoToVertex(vertex, vertex.getId(), TermMentionFor.VERTEX, null, null, null, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, sourceDataVertex, visalloVisibility.getVisibility(), authorizations);
        }
        return vertex;
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String predicateLabel, String justificationText, ClientApiSourceInfo sourceInfo, String visibilitySource, String workspaceId, User user, Authorizations authorizations) {
        VisibilityJson visibilityJson = VisibilityJson.updateVisibilitySourceAndAddWorkspaceId(null, (String)visibilitySource, (String)workspaceId);
        return this.addEdge(edgeId, outVertex, inVertex, predicateLabel, justificationText, sourceInfo, visibilityJson, user, authorizations);
    }

    public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String predicateLabel, String justificationText, ClientApiSourceInfo sourceInfo, VisibilityJson visibilityJson, User user, Authorizations authorizations) {
        VisalloVisibility visalloVisibility = this.visibilityTranslator.toVisibility(visibilityJson);
        EdgeBuilder edgeBuilder = edgeId == null ? this.graph.prepareEdge(outVertex, inVertex, predicateLabel, visalloVisibility.getVisibility()) : this.graph.prepareEdge(edgeId, outVertex, inVertex, predicateLabel, visalloVisibility.getVisibility());
        this.updateElementMetadataProperties((ElementBuilder)edgeBuilder, "relationship", visibilityJson, user);
        boolean justificationAdded = this.addJustification((ElementBuilder)edgeBuilder, justificationText, visalloVisibility, visibilityJson, user);
        Edge edge = (Edge)edgeBuilder.save(authorizations);
        if (justificationAdded) {
            this.termMentionRepository.removeSourceInfoEdgeFromEdge(edge, null, null, visalloVisibility, authorizations);
        } else if (sourceInfo != null) {
            VisalloProperties.JUSTIFICATION.removeProperty((ElementMutation)edgeBuilder, visalloVisibility.getVisibility());
            Vertex sourceDataVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            this.termMentionRepository.addSourceInfoEdgeToEdge(edge, edge.getId(), TermMentionFor.EDGE, null, null, null, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, sourceDataVertex, visalloVisibility.getVisibility(), authorizations);
        }
        return edge;
    }

    private void updateElementMetadataProperties(ElementBuilder elementBuilder, String conceptType, VisibilityJson visibilityJson, User user) {
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        Date now = new Date();
        VisalloProperties.CONCEPT_TYPE.setProperty((ElementMutation<?>)elementBuilder, conceptType, defaultVisibility);
        VisalloProperties.VISIBILITY_JSON.setProperty((ElementMutation<?>)elementBuilder, visibilityJson, defaultVisibility);
        VisalloProperties.MODIFIED_DATE.setProperty((ElementMutation<?>)elementBuilder, now, defaultVisibility);
        VisalloProperties.MODIFIED_BY.setProperty((ElementMutation<?>)elementBuilder, user.getUserId(), defaultVisibility);
    }

    private boolean addJustification(ElementBuilder elementBuilder, String justificationText, VisalloVisibility visalloVisibility, VisibilityJson visibilityJson, User user) {
        Visibility visibility = visalloVisibility.getVisibility();
        if (justificationText != null) {
            Metadata metadata = new Metadata();
            Visibility metadataVisibility = this.visibilityTranslator.getDefaultVisibility();
            VisalloProperties.MODIFIED_DATE_METADATA.setMetadata(metadata, new Date(), metadataVisibility);
            VisalloProperties.MODIFIED_BY_METADATA.setMetadata(metadata, user.getUserId(), metadataVisibility);
            VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, visibilityJson, metadataVisibility);
            PropertyJustificationMetadata value = new PropertyJustificationMetadata(justificationText);
            VisalloProperties.JUSTIFICATION.setProperty((ElementMutation<?>)elementBuilder, value, metadata, visibility);
            return true;
        }
        return false;
    }
}

