/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest.graphProperty;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vertexium.Element;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkData;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorker;
import org.visallo.core.ingest.graphProperty.GraphPropertyWorkerPrepareData;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionBuilder;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class RegexGraphPropertyWorker
extends GraphPropertyWorker {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(RegexGraphPropertyWorker.class);
    private final Pattern pattern;

    public RegexGraphPropertyWorker(String regEx) {
        this.pattern = Pattern.compile(regEx, 8);
    }

    protected abstract Concept getConcept();

    @Override
    public void prepare(GraphPropertyWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        LOGGER.debug("Extractor prepared for entity type [%s] with regular expression: %s", this.getConcept().getIRI(), this.pattern.toString());
    }

    @Override
    public void execute(InputStream in, GraphPropertyWorkData data) throws Exception {
        LOGGER.debug("Extracting pattern [%s] from provided text", this.pattern);
        String text = CharStreams.toString((Readable)new InputStreamReader(in, Charsets.UTF_8));
        Matcher matcher = this.pattern.matcher(text);
        Vertex outVertex = (Vertex)data.getElement();
        ArrayList<Vertex> termMentions = new ArrayList<Vertex>();
        while (matcher.find()) {
            String patternGroup = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            Vertex termMention = new TermMentionBuilder().outVertex(outVertex).propertyKey(data.getProperty().getKey()).propertyName(data.getProperty().getName()).start(start).end(end).title(patternGroup).conceptIri(this.getConcept().getIRI()).visibilityJson(data.getVisibilityJson()).process(this.getClass().getName()).save(this.getGraph(), this.getVisibilityTranslator(), this.getUser(), this.getAuthorizations());
            termMentions.add(termMention);
        }
        this.applyTermMentionFilters(outVertex, termMentions);
        this.pushTextUpdated(data);
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (property.getName().equals(VisalloProperties.RAW.getPropertyName())) {
            return false;
        }
        String mimeType = (String)property.getMetadata().getValue(VisalloProperties.MIME_TYPE.getPropertyName());
        return mimeType != null && mimeType.startsWith("text");
    }
}

