/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.formula;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class RequireJsSupport
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private static VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(RequireJsSupport.class);

    public String getClassName() {
        return "RequireJsSupport";
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (Object arg : args) {
            LOGGER.debug(Context.toString((Object)arg), new Object[0]);
        }
    }

    public static void consoleWarn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (Object arg : args) {
            LOGGER.warn(Context.toString((Object)arg), new Object[0]);
        }
    }

    public static void consoleError(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (Object arg : args) {
            LOGGER.error(Context.toString((Object)arg), new Object[0]);
        }
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        RequireJsSupport shell = (RequireJsSupport)RequireJsSupport.getTopLevelScope((Scriptable)thisObj);
        for (Object arg : args) {
            shell.processSource(cx, Context.toString((Object)arg));
        }
    }

    public static String readFully(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        RequireJsSupport shell = (RequireJsSupport)RequireJsSupport.getTopLevelScope((Scriptable)thisObj);
        if (args.length == 1) {
            return shell.getFileContents(Context.toString((Object)args[0]));
        }
        return null;
    }

    private void processSource(Context cx, String filename) throws IOException {
        String fileContents = this.getFileContents(filename);
        cx.evaluateString((Scriptable)this, fileContents, filename, 1, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFileContents(String file) {
        LOGGER.debug("reading file: %s", file);
        try (InputStream is = RequireJsSupport.class.getResourceAsStream(file);){
            if (is == null) {
                throw new VisalloException("File not found: " + file);
            }
            String string = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
            return string;
        }
        catch (IOException ex) {
            throw new VisalloException("Could not read file contents: " + file, ex);
        }
    }
}

