/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Vertex;
import org.visallo.core.ingest.video.VideoFrameInfo;
import org.visallo.core.ingest.video.VideoPropertyHelper;
import org.visallo.core.ingest.video.VideoTranscript;
import org.visallo.core.model.textHighlighting.OffsetItem;
import org.visallo.core.model.textHighlighting.VertexOffsetItem;
import org.visallo.web.clientapi.model.SandboxStatus;

public class EntityHighlighter {
    public String getHighlightedText(String text, Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        List<OffsetItem> offsetItems = this.convertTermMentionsToOffsetItems(termMentions, workspaceId, authorizations);
        return EntityHighlighter.getHighlightedText(text, offsetItems);
    }

    public static String getHighlightedText(String text, List<OffsetItem> offsetItems) throws JSONException {
        Collections.sort(offsetItems);
        StringBuilder result = new StringBuilder();
        PriorityQueue<Integer> endOffsets = new PriorityQueue<Integer>();
        int lastStart = 0;
        for (int i = 0; i < offsetItems.size(); ++i) {
            OffsetItem offsetItem = offsetItems.get(i);
            boolean overlapsPreviousItem = false;
            if (offsetItem instanceof VertexOffsetItem) {
                for (int j = 0; j < i; ++j) {
                    OffsetItem compareItem = offsetItems.get(j);
                    if (!(compareItem instanceof VertexOffsetItem) || OffsetItem.getOffset(compareItem.getEnd()) < OffsetItem.getOffset(offsetItem.getEnd()) && OffsetItem.getOffset(compareItem.getEnd()) <= OffsetItem.getOffset(offsetItem.getStart())) continue;
                    overlapsPreviousItem = true;
                    offsetItems.remove(i--);
                    break;
                }
            }
            if (overlapsPreviousItem || OffsetItem.getOffset(offsetItem.getStart()) < 0L || OffsetItem.getOffset(offsetItem.getEnd()) < 0L || !offsetItem.shouldHighlight()) continue;
            while (endOffsets.size() > 0 && (long)((Integer)endOffsets.peek()).intValue() <= OffsetItem.getOffset(offsetItem.getStart())) {
                int end = (Integer)endOffsets.poll();
                result.append(StringEscapeUtils.escapeHtml((String)EntityHighlighter.safeSubstring(text, lastStart, end)));
                result.append("</span>");
                lastStart = end;
            }
            result.append(StringEscapeUtils.escapeHtml((String)EntityHighlighter.safeSubstring(text, lastStart, (int)OffsetItem.getOffset(offsetItem.getStart()))));
            JSONObject infoJson = offsetItem.getInfoJson();
            result.append("<span");
            result.append(" class=\"");
            result.append(StringUtils.join(offsetItem.getCssClasses(), (String)" "));
            result.append("\"");
            if (offsetItem.getTitle() != null) {
                result.append(" title=\"");
                result.append(StringEscapeUtils.escapeHtml((String)offsetItem.getTitle()));
                result.append("\"");
            }
            result.append(" data-info=\"");
            result.append(StringEscapeUtils.escapeHtml((String)infoJson.toString()));
            result.append("\"");
            result.append(">");
            endOffsets.add((int)OffsetItem.getOffset(offsetItem.getEnd()));
            lastStart = (int)OffsetItem.getOffset(offsetItem.getStart());
        }
        while (endOffsets.size() > 0) {
            int end = (Integer)endOffsets.poll();
            result.append(StringEscapeUtils.escapeHtml((String)EntityHighlighter.safeSubstring(text, lastStart, end)));
            result.append("</span>");
            lastStart = end;
        }
        result.append(StringEscapeUtils.escapeHtml((String)EntityHighlighter.safeSubstring(text, lastStart)));
        return result.toString().replaceAll("&nbsp;", " ");
    }

    public VideoTranscript getHighlightedVideoTranscript(VideoTranscript videoTranscript, Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        List<OffsetItem> offsetItems = this.convertTermMentionsToOffsetItems(termMentions, workspaceId, authorizations);
        return this.getHighlightedVideoTranscript(videoTranscript, offsetItems);
    }

    private VideoTranscript getHighlightedVideoTranscript(VideoTranscript videoTranscript, List<OffsetItem> offsetItems) {
        Map<Integer, List<OffsetItem>> videoTranscriptOffsetItems = this.convertOffsetItemsToVideoTranscriptOffsetItems(videoTranscript, offsetItems);
        return this.getHighlightedVideoTranscript(videoTranscript, videoTranscriptOffsetItems);
    }

    private VideoTranscript getHighlightedVideoTranscript(VideoTranscript videoTranscript, Map<Integer, List<OffsetItem>> videoTranscriptOffsetItems) {
        VideoTranscript result = new VideoTranscript();
        int entryIndex = 0;
        for (VideoTranscript.TimedText videoTranscriptEntry : videoTranscript.getEntries()) {
            VideoTranscript.TimedText entry = videoTranscript.getEntries().get(entryIndex);
            List<OffsetItem> offsetItems = videoTranscriptOffsetItems.get(entryIndex);
            String highlightedText = offsetItems == null ? entry.getText() : EntityHighlighter.getHighlightedText(entry.getText(), offsetItems);
            result.add(videoTranscriptEntry.getTime(), highlightedText);
            ++entryIndex;
        }
        return result;
    }

    private Map<Integer, List<OffsetItem>> convertOffsetItemsToVideoTranscriptOffsetItems(VideoTranscript videoTranscript, List<OffsetItem> offsetItems) {
        HashMap<Integer, List<OffsetItem>> results = new HashMap<Integer, List<OffsetItem>>();
        for (OffsetItem offsetItem : offsetItems) {
            Integer videoTranscriptEntryIndex = EntityHighlighter.getVideoTranscriptEntryIndex(videoTranscript, offsetItem);
            ArrayList<OffsetItem> currentList = (ArrayList<OffsetItem>)results.get(videoTranscriptEntryIndex);
            if (currentList == null) {
                currentList = new ArrayList<OffsetItem>();
                results.put(videoTranscriptEntryIndex, currentList);
            }
            currentList.add(offsetItem);
        }
        return results;
    }

    private static int getVideoTranscriptEntryIndex(VideoTranscript videoTranscript, OffsetItem offsetItem) {
        Integer videoTranscriptEntryIndex = null;
        VideoFrameInfo videoFrameInfo = VideoPropertyHelper.getVideoFrameInfo(offsetItem.getId());
        if (videoFrameInfo != null) {
            videoTranscriptEntryIndex = videoTranscript.findEntryIndexFromStartTime(videoFrameInfo.getFrameStartTime());
        }
        if (videoTranscriptEntryIndex == null) {
            videoTranscriptEntryIndex = offsetItem.getVideoTranscriptEntryIndex();
        }
        return videoTranscriptEntryIndex;
    }

    private static String safeSubstring(String text, int beginIndex) {
        beginIndex = Math.min(beginIndex, text.length());
        return text.substring(beginIndex);
    }

    private static String safeSubstring(String text, int beginIndex, int endIndex) {
        beginIndex = Math.min(beginIndex, text.length());
        endIndex = Math.min(endIndex, text.length());
        return text.substring(beginIndex, endIndex);
    }

    public List<OffsetItem> convertTermMentionsToOffsetItems(Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        ArrayList<OffsetItem> termMetadataOffsetItems = new ArrayList<OffsetItem>();
        for (Vertex termMention : termMentions) {
            String visibility = termMention.getVisibility().getVisibilityString();
            SandboxStatus sandboxStatus = SandboxStatus.getFromVisibilityString((String)visibility, (String)workspaceId);
            termMetadataOffsetItems.add(new VertexOffsetItem(termMention, sandboxStatus, authorizations));
        }
        return termMetadataOffsetItems;
    }
}

