/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.concurrent.Callable;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class TimingCallable<V>
implements Callable<V> {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(TimingCallable.class);
    private final String message;

    public TimingCallable(String message) {
        this.message = message;
    }

    @Override
    public final V call() throws Exception {
        long startTime = System.currentTimeMillis();
        V result = this.callWithTime();
        long endTime = System.currentTimeMillis();
        LOGGER.debug("time for %s: %dms", this.message, endTime - startTime);
        return result;
    }

    protected abstract V callWithTime() throws Exception;
}

