/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.visallo.core.status.PausableTimerContext;
import org.visallo.core.status.PausableTimerContextAware;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class TeeInputStream {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(TeeInputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int LOOP_REPORT_INTERVAL = 10000;
    private final InputStream source;
    private final MyInputStream[] tees;
    private final byte[] cyclicBuffer;
    private int cyclicBufferOffsetIndex;
    private long cyclicBufferOffset;
    private int cyclicBufferValidSize;
    private final Object cyclicBufferLock = new Object();
    private boolean sourceComplete;

    public TeeInputStream(InputStream source, String[] splitNames) {
        this(source, splitNames, 0x100000);
    }

    public TeeInputStream(InputStream source, int splits) {
        this(source, new String[splits], 0x100000);
    }

    public TeeInputStream(InputStream source, int splits, int bufferSize) {
        this(source, new String[splits], bufferSize);
    }

    public TeeInputStream(InputStream source, String[] splitNames, int bufferSize) {
        this.source = source;
        this.cyclicBuffer = new byte[bufferSize];
        this.cyclicBufferOffsetIndex = 0;
        this.cyclicBufferOffset = 0L;
        this.cyclicBufferValidSize = 0;
        this.sourceComplete = false;
        this.tees = new MyInputStream[splitNames.length];
        for (int i = 0; i < this.tees.length; ++i) {
            this.tees[i] = new MyInputStream(splitNames[i]);
        }
    }

    public InputStream[] getTees() {
        return this.tees;
    }

    private boolean isClosed(int idx) {
        return this.tees[idx].isClosed();
    }

    public void close() throws IOException {
        for (MyInputStream tee : this.tees) {
            ((InputStream)tee).close();
        }
    }

    public void loopUntilTeesAreClosed() throws Exception {
        boolean allClosed = false;
        long lastReport = new Date().getTime();
        while (!allClosed) {
            allClosed = true;
            for (int i = 0; i < this.tees.length; ++i) {
                if (this.isClosed(i)) continue;
                allClosed = false;
                if (!LOGGER.isDebugEnabled() || new Date().getTime() <= lastReport + 10000L) break;
                MyInputStream teeWithLowestOffset = this.findTeeWithLowestTeeOffset();
                if (teeWithLowestOffset == null) {
                    LOGGER.debug("All tees are complete", new Object[0]);
                } else {
                    LOGGER.debug("Waiting for tee: %s (offset: %d)", teeWithLowestOffset.splitName, teeWithLowestOffset.offset);
                }
                lastReport = new Date().getTime();
                break;
            }
            this.loop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() throws Exception {
        Object object = this.cyclicBufferLock;
        synchronized (object) {
            this.updateOffsets();
            if (!this.sourceComplete && this.cyclicBufferValidSize < this.cyclicBuffer.length) {
                int read;
                int readOffset = this.cyclicBufferOffsetIndex + this.cyclicBufferValidSize;
                int readLen = this.cyclicBuffer.length - this.cyclicBufferValidSize;
                int partialRedLen = Math.min(this.cyclicBuffer.length - readOffset, readLen);
                if (partialRedLen > 0) {
                    read = this.source.read(this.cyclicBuffer, readOffset, partialRedLen);
                    if (read == -1) {
                        this.sourceComplete = true;
                    } else {
                        this.cyclicBufferValidSize += read;
                        readLen -= read;
                        readOffset += read;
                    }
                }
                if (!this.sourceComplete && readLen > 0 && readOffset >= this.cyclicBuffer.length) {
                    read = this.source.read(this.cyclicBuffer, readOffset %= this.cyclicBuffer.length, readLen);
                    if (read == -1) {
                        this.sourceComplete = true;
                    } else {
                        this.cyclicBufferValidSize += read;
                    }
                }
                this.cyclicBufferLock.notifyAll();
            } else {
                this.cyclicBufferLock.wait(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOffsets() {
        Object object = this.cyclicBufferLock;
        synchronized (object) {
            long lowestOffset = this.findLowestTeeOffset();
            if (lowestOffset > this.cyclicBufferOffset) {
                int delta = (int)(lowestOffset - this.cyclicBufferOffset);
                this.cyclicBufferOffset += (long)delta;
                this.cyclicBufferOffsetIndex += delta;
                this.cyclicBufferOffsetIndex %= this.cyclicBuffer.length;
                this.cyclicBufferValidSize -= delta;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findLowestTeeOffset() {
        Object object = this.cyclicBufferLock;
        synchronized (object) {
            long lowestOffset = Long.MAX_VALUE;
            for (MyInputStream tee : this.tees) {
                if (tee.isClosed() || tee.offset >= lowestOffset) continue;
                lowestOffset = tee.offset;
            }
            return lowestOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyInputStream findTeeWithLowestTeeOffset() {
        Object object = this.cyclicBufferLock;
        synchronized (object) {
            MyInputStream teeWithLowestOffset = null;
            for (MyInputStream tee : this.tees) {
                if (tee.isClosed() || teeWithLowestOffset != null && tee.offset >= teeWithLowestOffset.offset) continue;
                teeWithLowestOffset = tee;
            }
            return teeWithLowestOffset;
        }
    }

    public int getMaxNonblockingReadLength(int teeIndex) {
        return this.tees[teeIndex].getMaxNonblockingReadLength();
    }

    private class MyInputStream
    extends InputStream
    implements PausableTimerContextAware {
        private final String splitName;
        private boolean closed = false;
        private long offset = 0L;
        private PausableTimerContext pausableTimerContext;

        public MyInputStream(String splitName) {
            this.splitName = splitName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            int n;
            this.pauseTimer();
            try {
                Object object = TeeInputStream.this.cyclicBufferLock;
                synchronized (object) {
                    if (this.closed) {
                        int n2 = -1;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                        this.resumeTimer();
                        return n2;
                    }
                }
            }
            catch (Throwable throwable) {
                this.resumeTimer();
                throw throwable;
            }
            {
                int result = this.readInternal();
                if (result != -1) {
                    ++this.offset;
                }
                TeeInputStream.this.cyclicBufferLock.notifyAll();
                n = result;
            }
            this.resumeTimer();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            this.pauseTimer();
            try {
                Object object = TeeInputStream.this.cyclicBufferLock;
                synchronized (object) {
                    if (this.closed) {
                        int n2 = -1;
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl7 : MonitorExitStatement: MONITOREXIT : var4_4
                        this.resumeTimer();
                        return n2;
                    }
                }
            }
            catch (Throwable throwable) {
                this.resumeTimer();
                throw throwable;
            }
            {
                if (b.length == 0 || len == 0) {
                    int n3 = 0;
                    // MONITOREXIT @DISABLED, blocks:[5, 8] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.resumeTimer();
                    return n3;
                }
                int readLength = this.readInternal(b, off, len);
                if (readLength != -1) {
                    this.offset += (long)readLength;
                }
                TeeInputStream.this.cyclicBufferLock.notifyAll();
                n = readLength;
            }
            this.resumeTimer();
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readInternal() throws IOException {
            Object object = TeeInputStream.this.cyclicBufferLock;
            synchronized (object) {
                if (this.offset < TeeInputStream.this.cyclicBufferOffset) {
                    throw new IOException("attempting to read previous data is not permitted. offset: " + this.offset + ", cyclicBufferOffset: " + TeeInputStream.this.cyclicBufferOffset);
                }
                while (this.getMaxNonblockingReadLength() <= 0) {
                    if (TeeInputStream.this.sourceComplete) {
                        return -1;
                    }
                    try {
                        TeeInputStream.this.cyclicBufferLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Cyclic buffer wait failed", e);
                    }
                }
                int readOffset = (int)(this.offset - TeeInputStream.this.cyclicBufferOffset + (long)TeeInputStream.this.cyclicBufferOffsetIndex) % TeeInputStream.this.cyclicBuffer.length;
                return TeeInputStream.this.cyclicBuffer[readOffset];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readInternal(byte[] b, int off, int len) throws IOException {
            Object object = TeeInputStream.this.cyclicBufferLock;
            synchronized (object) {
                if (this.offset < TeeInputStream.this.cyclicBufferOffset) {
                    throw new IOException("attempting to read previous data is not permitted. offset: " + this.offset + ", cyclicBufferOffset: " + TeeInputStream.this.cyclicBufferOffset);
                }
                while (this.getMaxNonblockingReadLength() <= 0) {
                    if (TeeInputStream.this.sourceComplete) {
                        return -1;
                    }
                    try {
                        TeeInputStream.this.cyclicBufferLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Cyclic buffer wait failed", e);
                    }
                }
                int readOffset = (int)(this.offset - TeeInputStream.this.cyclicBufferOffset + (long)TeeInputStream.this.cyclicBufferOffsetIndex) % TeeInputStream.this.cyclicBuffer.length;
                int readLen = Math.min(len, this.getMaxNonblockingReadLength());
                int bytesRead = 0;
                int partialReadLen = Math.min(TeeInputStream.this.cyclicBuffer.length - readOffset, readLen);
                if (partialReadLen > 0) {
                    System.arraycopy(TeeInputStream.this.cyclicBuffer, readOffset, b, off, partialReadLen);
                    readLen -= partialReadLen;
                    off += partialReadLen;
                    readOffset += partialReadLen;
                    bytesRead += partialReadLen;
                }
                if (readLen > 0) {
                    System.arraycopy(TeeInputStream.this.cyclicBuffer, readOffset %= TeeInputStream.this.cyclicBuffer.length, b, off, readLen);
                    bytesRead += readLen;
                }
                return bytesRead;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            LOGGER.debug("Closing tee: " + this.splitName, new Object[0]);
            try {
                super.close();
            }
            finally {
                Object object = TeeInputStream.this.cyclicBufferLock;
                synchronized (object) {
                    this.closed = true;
                    this.offset = Long.MAX_VALUE;
                    TeeInputStream.this.cyclicBufferLock.notifyAll();
                }
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMaxNonblockingReadLength() {
            Object object = TeeInputStream.this.cyclicBufferLock;
            synchronized (object) {
                return (int)((long)TeeInputStream.this.cyclicBufferValidSize - (this.offset - TeeInputStream.this.cyclicBufferOffset));
            }
        }

        @Override
        public void setPausableTimerContext(PausableTimerContext pausableTimerContext) {
            this.pausableTimerContext = pausableTimerContext;
        }

        private void resumeTimer() {
            if (this.pausableTimerContext != null) {
                this.pausableTimerContext.resume();
            }
        }

        private void pauseTimer() {
            if (this.pausableTimerContext != null) {
                this.pausableTimerContext.pause();
            }
        }
    }
}

