/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.vertexium.util.CloseableUtils;
import org.visallo.core.util.VisalloLogger;

public class LoggingThread
extends Thread {
    private InputStream inputStream;
    private OutputStream outputStream;
    private StringBuffer contentBuffer;
    private String prefix;
    private PrintWriter writer;
    private VisalloLogger logger;

    public LoggingThread(InputStream inputStream, VisalloLogger logger, String prefix) {
        this(inputStream, null, logger, null, prefix);
    }

    public LoggingThread(InputStream inputStream, OutputStream redirect, VisalloLogger logger, StringBuffer contentBuffer, String prefix) {
        this.inputStream = inputStream;
        this.outputStream = redirect;
        this.logger = logger;
        this.contentBuffer = contentBuffer;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isreader;
        BufferedReader reader;
        block7: {
            reader = null;
            isreader = null;
            try {
                String line;
                if (this.outputStream != null) {
                    this.writer = new PrintWriter(this.outputStream);
                }
                isreader = new InputStreamReader(this.inputStream);
                reader = new BufferedReader(isreader);
                while ((line = reader.readLine()) != null) {
                    if (this.prefix != null) {
                        line = this.prefix + line;
                    }
                    this.append(line);
                    this.log(line);
                }
                if (this.writer == null) break block7;
                this.writer.flush();
            }
            catch (IOException ioe) {
                try {
                    ioe.printStackTrace();
                }
                catch (Throwable throwable) {
                    CloseableUtils.closeQuietly(reader);
                    CloseableUtils.closeQuietly(isreader);
                    CloseableUtils.closeQuietly((Closeable)this.writer);
                    throw throwable;
                }
                CloseableUtils.closeQuietly(reader);
                CloseableUtils.closeQuietly((Closeable)isreader);
                CloseableUtils.closeQuietly((Closeable)this.writer);
            }
        }
        CloseableUtils.closeQuietly((Closeable)reader);
        CloseableUtils.closeQuietly((Closeable)isreader);
        CloseableUtils.closeQuietly((Closeable)this.writer);
    }

    protected void append(String output) {
        if (this.writer != null) {
            this.writer.println(output);
        }
        if (this.contentBuffer != null) {
            this.contentBuffer.append(output.trim());
            this.contentBuffer.append('\n');
        }
    }

    protected void log(String output) {
        if (this.logger != null) {
            this.logger.info("%s", output);
        }
    }
}

