/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class FFprobeVideoFiltersUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FFprobeVideoFiltersUtil.class);

    public static Integer getRotation(JSONObject json) {
        if (json == null) {
            return 0;
        }
        JSONArray streamsJson = json.optJSONArray("streams");
        if (streamsJson != null) {
            for (int i = 0; i < streamsJson.length(); ++i) {
                Double optionalRotate;
                JSONObject tagsJson;
                JSONObject streamsIndexJson = streamsJson.optJSONObject(i);
                if (streamsIndexJson == null || (tagsJson = streamsIndexJson.optJSONObject("tags")) == null || Double.isNaN(optionalRotate = Double.valueOf(tagsJson.optDouble("rotate")))) continue;
                Integer rotate = optionalRotate.intValue() % 360;
                return rotate;
            }
        }
        LOGGER.debug("Could not retrieve a \"rotate\" value from the JSON object.", new Object[0]);
        return 0;
    }

    private static String[] getRotateTransforms(Integer videoRotation) {
        if (videoRotation == null) {
            return null;
        }
        if (videoRotation % 360 == 90) {
            return new String[]{"transpose=1"};
        }
        if (videoRotation % 360 == 180) {
            return new String[]{"transpose=1,transpose=1"};
        }
        if (videoRotation % 360 == 270) {
            return new String[]{"transpose=2"};
        }
        return null;
    }

    private static String[] getScaleTransforms(Integer videoRotation) {
        if (videoRotation != null && (videoRotation == 90 || videoRotation == 270)) {
            return new String[]{"scale=trunc(oh*a/2)*2:480"};
        }
        return new String[]{"scale=720:trunc(ow/a/2)*2"};
    }

    public static String[] getFFmpegVideoFilterOptions(Integer videoRotation) {
        String[] ffmpegScaleOptions;
        ArrayList<String> transforms = new ArrayList<String>();
        String[] ffmpegRotationOptions = FFprobeVideoFiltersUtil.getRotateTransforms(videoRotation);
        if (ffmpegRotationOptions != null) {
            for (String transform : ffmpegRotationOptions) {
                transforms.add(transform);
            }
        }
        if ((ffmpegScaleOptions = FFprobeVideoFiltersUtil.getScaleTransforms(videoRotation)) != null) {
            for (String transform : ffmpegScaleOptions) {
                transforms.add(transform);
            }
        }
        if (transforms.isEmpty()) {
            return null;
        }
        return new String[]{"-vf", Joiner.on((String)",").join(transforms)};
    }
}

