/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.ArrayList;
import java.util.List;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class AutoDependencyTreeRunner {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(AutoDependencyTreeRunner.class);
    private List<DependencyNode> dependencyNodes = new ArrayList<DependencyNode>();

    public void add(Runnable ... newRunnables) {
        for (int i = 0; i < newRunnables.length; ++i) {
            if (i == 0) {
                this.addDependencyNode(newRunnables[i], null);
                continue;
            }
            this.addDependencyNode(newRunnables[i], newRunnables[i - 1]);
        }
    }

    private void addDependencyNode(Runnable runnable, Runnable dependency) {
        DependencyNode dependencyNode = this.findOrAddDependencyNode(runnable);
        if (dependency != null) {
            dependencyNode.addDependency(this.findOrAddDependencyNode(dependency));
        }
    }

    private DependencyNode findOrAddDependencyNode(Runnable runnable) {
        DependencyNode dependencyNode = this.findDependencyNode(runnable);
        if (dependencyNode == null) {
            dependencyNode = new DependencyNode(runnable);
            this.dependencyNodes.add(dependencyNode);
        }
        return dependencyNode;
    }

    private DependencyNode findDependencyNode(Runnable runnable) {
        for (DependencyNode dependencyNode : this.dependencyNodes) {
            if (!dependencyNode.equals(runnable)) continue;
            return dependencyNode;
        }
        return null;
    }

    public void dryRun() {
        this.run(true);
    }

    public void run() {
        this.run(false);
    }

    private void run(boolean dryRun) {
        ArrayList<DependencyNode> ranNodes = new ArrayList<DependencyNode>();
        for (DependencyNode dependencyNode : this.dependencyNodes) {
            this.run(dependencyNode, ranNodes, dryRun);
        }
    }

    private void run(DependencyNode dependencyNode, List<DependencyNode> ranNodes, boolean dryRun) {
        for (DependencyNode dependent : dependencyNode.getDependents()) {
            if (ranNodes.contains(dependent)) continue;
            this.run(dependent, ranNodes, dryRun);
            ranNodes.add(dependent);
        }
        if (!ranNodes.contains(dependencyNode)) {
            LOGGER.debug("Running " + dependencyNode, new Object[0]);
            if (!dryRun) {
                dependencyNode.getRunnable().run();
            }
            ranNodes.add(dependencyNode);
        }
    }

    private static class DependencyNode {
        private final Runnable runnable;
        private final List<DependencyNode> dependents = new ArrayList<DependencyNode>();

        public DependencyNode(Runnable runnable) {
            this.runnable = runnable;
        }

        public void addDependency(DependencyNode dependentNode) {
            this.dependents.add(dependentNode);
        }

        public List<DependencyNode> getDependents() {
            return this.dependents;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public String toString() {
            return this.getRunnable().toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Runnable) {
                return obj == this.runnable;
            }
            if (obj instanceof DependencyNode) {
                return ((DependencyNode)obj).getRunnable() == this.runnable;
            }
            throw new RuntimeException("Not supported");
        }
    }
}

