/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import java.util.ArrayList;
import java.util.List;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class InMemoryAuthorizationRepository
implements AuthorizationRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(InMemoryAuthorizationRepository.class);
    private List<String> authorizations = new ArrayList<String>();

    @Override
    public void addAuthorizationToGraph(String ... auths) {
        for (String auth : auths) {
            LOGGER.info("Adding authorization to graph user %s", auth);
            this.authorizations.add(auth);
        }
    }

    @Override
    public void removeAuthorizationFromGraph(String auth) {
        LOGGER.info("Removing authorization to graph user %s", auth);
        this.authorizations.remove(auth);
    }

    @Override
    public List<String> getGraphAuthorizations() {
        LOGGER.info("getting authorizations", new Object[0]);
        return new ArrayList<String>(this.authorizations);
    }
}

