/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.textHighlighting;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.util.IterableUtils;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.core.model.textHighlighting.OffsetItem;
import org.visallo.web.clientapi.model.SandboxStatus;

public class VertexOffsetItem
extends OffsetItem {
    private final Vertex termMention;
    private final SandboxStatus sandboxStatus;
    private final Authorizations authorizations;

    public VertexOffsetItem(Vertex termMention, SandboxStatus sandboxStatus, Authorizations authorizations) {
        this.termMention = termMention;
        this.sandboxStatus = sandboxStatus;
        this.authorizations = authorizations;
        String[] authArray = this.authorizations.getAuthorizations();
        boolean hasTermMentionAuth = false;
        for (String auth : authArray) {
            if (!"termMention".equals(auth)) continue;
            hasTermMentionAuth = true;
        }
        Preconditions.checkArgument((boolean)hasTermMentionAuth, (Object)"termMention is a required auth");
    }

    @Override
    public long getStart() {
        return VisalloProperties.TERM_MENTION_START_OFFSET.getPropertyValue((Element)this.termMention, 0L);
    }

    @Override
    public long getEnd() {
        return VisalloProperties.TERM_MENTION_END_OFFSET.getPropertyValue((Element)this.termMention, 0L);
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2002/07/owl#Thing";
    }

    public String getConceptIri() {
        return (String)VisalloProperties.TERM_MENTION_CONCEPT_TYPE.getPropertyValue((Element)this.termMention);
    }

    @Override
    public String getId() {
        return this.termMention.getId();
    }

    @Override
    public String getProcess() {
        return (String)VisalloProperties.TERM_MENTION_PROCESS.getPropertyValue((Element)this.termMention);
    }

    @Override
    public String getOutVertexId() {
        return (String)IterableUtils.singleOrDefault((Iterable)this.termMention.getVertexIds(Direction.IN, "http://visallo.org/termMention#hasTermMention", this.authorizations), null);
    }

    @Override
    public String getResolvedToVertexId() {
        return (String)IterableUtils.singleOrDefault((Iterable)this.termMention.getVertexIds(Direction.OUT, "http://visallo.org/termMention#resolvedTo", this.authorizations), null);
    }

    @Override
    public String getResolvedToEdgeId() {
        return (String)VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.getPropertyValue((Element)this.termMention);
    }

    @Override
    public TermMentionFor getTermMentionFor() {
        return (TermMentionFor)((Object)VisalloProperties.TERM_MENTION_FOR_TYPE.getPropertyValue((Element)this.termMention));
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return this.sandboxStatus;
    }

    @Override
    public String getTitle() {
        return (String)VisalloProperties.TERM_MENTION_TITLE.getPropertyValue((Element)this.termMention);
    }

    @Override
    public boolean shouldHighlight() {
        return super.shouldHighlight();
    }

    @Override
    public JSONObject getInfoJson() {
        try {
            JSONObject infoJson = super.getInfoJson();
            infoJson.put("title", (Object)this.getTitle());
            if (this.getConceptIri() != null) {
                infoJson.put("http://visallo.org#conceptType", (Object)this.getConceptIri());
            }
            return infoJson;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getCssClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        TermMentionFor termMentionFor = this.getTermMentionFor();
        if (termMentionFor == null) {
            termMentionFor = TermMentionFor.VERTEX;
        }
        classes.add(termMentionFor.toString().toLowerCase());
        if (this.getResolvedToVertexId() != null) {
            classes.add("resolved");
        }
        return classes;
    }
}

