/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.termMention;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.stream.Stream;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingEdgeMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.JoinIterable;
import org.visallo.core.model.PropertyJustificationMetadata;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.StreamUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.clientapi.model.ClientApiTermMentionsResponse;

public class TermMentionRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(TermMentionRepository.class);
    public static final String VISIBILITY_STRING = "termMention";
    public static final String OWL_IRI = "http://visallo.org/termMention";
    private final Graph graph;

    @Inject
    public TermMentionRepository(Graph graph, AuthorizationRepository authorizationRepository) {
        this.graph = graph;
        authorizationRepository.addAuthorizationToGraph(VISIBILITY_STRING);
    }

    public Iterable<Vertex> findByOutVertexAndProperty(String outVertexId, final String propertyKey, final String propertyName, Authorizations authorizations) {
        authorizations = this.getAuthorizations(authorizations);
        return new FilterIterable<Vertex>(this.findByOutVertex(outVertexId, authorizations)){

            protected boolean isIncluded(Vertex v) {
                String vertexPropertyKey = (String)VisalloProperties.TERM_MENTION_PROPERTY_KEY.getPropertyValue((Element)v);
                if (!propertyKey.equals(vertexPropertyKey)) {
                    return false;
                }
                String vertexPropertyName = VisalloProperties.TERM_MENTION_PROPERTY_NAME.getPropertyValue((Element)v, null);
                if (VisalloProperties.TEXT.getPropertyName().equals(propertyName) && vertexPropertyName == null) {
                    return true;
                }
                return propertyName.equals(vertexPropertyName);
            }
        };
    }

    public Iterable<Vertex> findByOutVertex(String outVertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizationsWithTermMention);
        return outVertex.getVertices(Direction.OUT, "http://visallo.org/termMention#hasTermMention", authorizationsWithTermMention);
    }

    public Iterable<Vertex> findByVertexId(String vertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex vertex = this.graph.getVertex(vertexId, authorizationsWithTermMention);
        String[] labels = new String[]{"http://visallo.org/termMention#hasTermMention", "http://visallo.org/termMention#resolvedTo"};
        return vertex.getVertices(Direction.BOTH, labels, authorizationsWithTermMention);
    }

    public Iterable<Vertex> findByEdge(Edge edge, Authorizations authorizations) {
        return new JoinIterable(new Iterable[]{this.findByVertexId(edge.getVertexId(Direction.IN), authorizations), this.findByVertexId(edge.getVertexId(Direction.OUT), authorizations)});
    }

    public Iterable<Vertex> findByVertexIdForVertex(final String vertexId, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByVertexId(vertexId, authorizations)){

            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue((Element)termMention);
                if (forElementId == null || !forElementId.equals(vertexId)) {
                    return false;
                }
                TermMentionFor forType = (TermMentionFor)((Object)VisalloProperties.TERM_MENTION_FOR_TYPE.getPropertyValue((Element)termMention));
                return forType != null && forType == TermMentionFor.VERTEX;
            }
        };
    }

    public Iterable<Vertex> findByEdgeForEdge(final Edge edge, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByEdge(edge, authorizations)){

            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue((Element)termMention);
                if (forElementId == null || !forElementId.equals(edge.getId())) {
                    return false;
                }
                TermMentionFor forType = (TermMentionFor)((Object)VisalloProperties.TERM_MENTION_FOR_TYPE.getPropertyValue((Element)termMention));
                return forType != null && forType == TermMentionFor.EDGE;
            }
        };
    }

    public Iterable<Vertex> findByVertexIdAndProperty(final String vertexId, final String propertyKey, final String propertyName, final Visibility propertyVisibility, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByVertexId(vertexId, authorizations)){

            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue((Element)termMention);
                if (forElementId == null || !forElementId.equals(vertexId)) {
                    return false;
                }
                return TermMentionRepository.this.isTermMentionForProperty(termMention, propertyKey, propertyName, propertyVisibility);
            }
        };
    }

    public Iterable<Vertex> findByEdgeIdAndProperty(final Edge edge, final String propertyKey, final String propertyName, final Visibility propertyVisibility, Authorizations authorizations) {
        return new FilterIterable<Vertex>(this.findByEdge(edge, authorizations)){

            protected boolean isIncluded(Vertex termMention) {
                String forElementId = (String)VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue((Element)termMention);
                if (forElementId == null || !forElementId.equals(edge.getId())) {
                    return false;
                }
                return TermMentionRepository.this.isTermMentionForProperty(termMention, propertyKey, propertyName, propertyVisibility);
            }
        };
    }

    private boolean isTermMentionForProperty(Vertex termMention, String propertyKey, String propertyName, Visibility propertyVisibility) {
        TermMentionFor forType = (TermMentionFor)((Object)VisalloProperties.TERM_MENTION_FOR_TYPE.getPropertyValue((Element)termMention));
        if (forType == null || forType != TermMentionFor.PROPERTY) {
            return false;
        }
        String refPropertyKey = (String)VisalloProperties.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)termMention);
        if (refPropertyKey == null || !refPropertyKey.equals(propertyKey)) {
            return false;
        }
        String refPropertyName = (String)VisalloProperties.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)termMention);
        if (refPropertyName == null || !refPropertyName.equals(propertyName)) {
            return false;
        }
        String refPropertyVisibilityString = (String)VisalloProperties.TERM_MENTION_REF_PROPERTY_VISIBILITY.getPropertyValue((Element)termMention);
        return refPropertyVisibilityString != null && refPropertyVisibilityString.equals(propertyVisibility.getVisibilityString());
    }

    public Vertex findById(String termMentionId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        return this.graph.getVertex(termMentionId, authorizationsWithTermMention);
    }

    public void updateVisibility(Vertex termMention, Visibility newVisibility, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Visibility newVisibilityWithTermMention = VisalloVisibility.and(newVisibility, VISIBILITY_STRING);
        ExistingElementMutation m = termMention.prepareMutation();
        m.alterElementVisibility(newVisibilityWithTermMention);
        for (Property property : termMention.getProperties()) {
            m.alterPropertyVisibility(property, newVisibilityWithTermMention);
        }
        Property refPropertyVisibility = VisalloProperties.TERM_MENTION_REF_PROPERTY_VISIBILITY.getProperty((Element)termMention);
        if (refPropertyVisibility != null) {
            VisalloProperties.TERM_MENTION_REF_PROPERTY_VISIBILITY.setProperty((ElementMutation<?>)m, newVisibility.getVisibilityString(), refPropertyVisibility.getMetadata(), newVisibilityWithTermMention);
        }
        m.save(authorizationsWithTermMention);
        for (Edge edge : termMention.getEdges(Direction.BOTH, authorizationsWithTermMention)) {
            ExistingEdgeMutation edgeMutation = edge.prepareMutation();
            edgeMutation.alterElementVisibility(newVisibilityWithTermMention);
            for (Property property : edge.getProperties()) {
                edgeMutation.alterPropertyVisibility(property, newVisibilityWithTermMention);
            }
            edgeMutation.save(authorizationsWithTermMention);
        }
    }

    public Iterable<Vertex> findResolvedTo(String inVertexId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex inVertex = this.graph.getVertex(inVertexId, authorizationsWithTermMention);
        return inVertex.getVertices(Direction.IN, "http://visallo.org/termMention#resolvedTo", authorizationsWithTermMention);
    }

    public Stream<Vertex> findResolvedToForRef(String inVertexId, String refPropertyKey, String refPropertyName, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)refPropertyKey, (Object)"refPropertyKey cannot be null");
        Preconditions.checkNotNull((Object)refPropertyName, (Object)"refPropertyName cannot be null");
        return StreamUtil.stream(this.findResolvedTo(inVertexId, authorizations)).filter(vertex -> {
            String vertexRefPropertyKey = VisalloProperties.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)vertex, null);
            String vertexRefPropertyName = VisalloProperties.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)vertex, null);
            return refPropertyKey.equals(vertexRefPropertyKey) && refPropertyName.equals(vertexRefPropertyName);
        });
    }

    public Stream<Vertex> findResolvedToForRefElement(String inVertexId, Authorizations authorizations) {
        return StreamUtil.stream(this.findResolvedTo(inVertexId, authorizations)).filter(vertex -> {
            String vertexRefPropertyKey = VisalloProperties.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)vertex, null);
            String vertexRefPropertyName = VisalloProperties.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)vertex, null);
            return vertexRefPropertyKey == null && vertexRefPropertyName == null;
        });
    }

    public void delete(Vertex termMention, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        this.graph.softDeleteVertex(termMention, authorizationsWithTermMention);
    }

    public void markHidden(Vertex termMention, Visibility hiddenVisibility, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        this.graph.markVertexHidden(termMention, hiddenVisibility, authorizationsWithTermMention);
    }

    public Iterable<Vertex> findByEdgeId(String outVertexId, final String edgeId, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        Vertex outVertex = this.graph.getVertex(outVertexId, authorizationsWithTermMention);
        return new FilterIterable<Vertex>(outVertex.getVertices(Direction.OUT, "http://visallo.org/termMention#hasTermMention", authorizationsWithTermMention)){

            protected boolean isIncluded(Vertex v) {
                String vertexEdgeId = (String)VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.getPropertyValue((Element)v);
                return edgeId.equals(vertexEdgeId);
            }
        };
    }

    public Vertex findOutVertex(Vertex termMention, Authorizations authorizations) {
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        return (Vertex)IterableUtils.singleOrDefault((Iterable)termMention.getVertices(Direction.IN, "http://visallo.org/termMention#hasTermMention", authorizationsWithTermMention), null);
    }

    public Authorizations getAuthorizations(Authorizations authorizations) {
        return this.graph.createAuthorizations(authorizations, new String[]{VISIBILITY_STRING});
    }

    public void addJustification(Vertex vertex, String justificationText, ClientApiSourceInfo sourceInfo, VisalloVisibility visalloVisibility, Authorizations authorizations) {
        if (justificationText != null) {
            PropertyJustificationMetadata propertyJustificationMetadata = new PropertyJustificationMetadata(justificationText);
            this.removeSourceInfoEdgeFromVertex(vertex.getId(), vertex.getId(), null, null, visalloVisibility, authorizations);
            VisalloProperties.JUSTIFICATION.setProperty((Element)vertex, propertyJustificationMetadata, visalloVisibility.getVisibility(), authorizations);
        } else if (sourceInfo != null) {
            Vertex outVertex = this.graph.getVertex(sourceInfo.vertexId, authorizations);
            VisalloProperties.JUSTIFICATION.removeProperty((Element)vertex, authorizations);
            this.addSourceInfoToVertex(vertex, sourceInfo.vertexId, TermMentionFor.VERTEX, null, null, null, sourceInfo.snippet, sourceInfo.textPropertyKey, sourceInfo.textPropertyName, sourceInfo.startOffset, sourceInfo.endOffset, outVertex, visalloVisibility.getVisibility(), authorizations);
        }
    }

    public <T extends Element> void addSourceInfo(T element, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex outVertex, Visibility visibility, Authorizations authorizations) {
        if (element instanceof Vertex) {
            this.addSourceInfoToVertex((Vertex)element, forElementId, forType, propertyKey, propertyName, propertyVisibility, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, outVertex, visibility, authorizations);
        } else {
            this.addSourceInfoEdgeToEdge((Edge)element, forElementId, forType, propertyKey, propertyName, propertyVisibility, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, outVertex, visibility, authorizations);
        }
    }

    public void addSourceInfoToVertex(Vertex vertex, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex outVertex, Visibility visibility, Authorizations authorizations) {
        visibility = VisalloVisibility.and(visibility, VISIBILITY_STRING);
        String termMentionVertexId = vertex.getId() + "hasSource" + outVertex.getId();
        if (propertyKey != null) {
            termMentionVertexId = termMentionVertexId + ":" + propertyKey;
        }
        if (propertyName != null) {
            termMentionVertexId = termMentionVertexId + ":" + propertyName;
        }
        if (propertyVisibility != null) {
            termMentionVertexId = termMentionVertexId + ":" + propertyVisibility;
        }
        VertexBuilder m = this.graph.prepareVertex(termMentionVertexId, visibility);
        VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.setProperty((ElementMutation<?>)m, forElementId, visibility);
        VisalloProperties.TERM_MENTION_FOR_TYPE.setProperty((ElementMutation<?>)m, forType, visibility);
        if (propertyKey != null) {
            VisalloProperties.TERM_MENTION_REF_PROPERTY_KEY.setProperty((ElementMutation<?>)m, propertyKey, visibility);
        }
        if (propertyName != null) {
            VisalloProperties.TERM_MENTION_REF_PROPERTY_NAME.setProperty((ElementMutation<?>)m, propertyName, visibility);
        }
        if (propertyVisibility != null) {
            VisalloProperties.TERM_MENTION_REF_PROPERTY_VISIBILITY.setProperty((ElementMutation<?>)m, propertyVisibility.getVisibilityString(), visibility);
        }
        VisalloProperties.TERM_MENTION_SNIPPET.setProperty((ElementMutation<?>)m, snippet, visibility);
        VisalloProperties.TERM_MENTION_PROPERTY_KEY.setProperty((ElementMutation<?>)m, textPropertyKey, visibility);
        if (textPropertyName == null) {
            LOGGER.warn("not providing a property name for a term mention is deprecate", new Object[0]);
        } else {
            VisalloProperties.TERM_MENTION_PROPERTY_NAME.setProperty((ElementMutation<?>)m, textPropertyName, visibility);
        }
        VisalloProperties.TERM_MENTION_START_OFFSET.setProperty((ElementMutation<?>)m, startOffset, visibility);
        VisalloProperties.TERM_MENTION_END_OFFSET.setProperty((ElementMutation<?>)m, endOffset, visibility);
        Vertex termMention = m.save(authorizations);
        this.graph.addEdge("http://visallo.org/termMention#hasTermMention" + termMentionVertexId, outVertex, termMention, "http://visallo.org/termMention#hasTermMention", visibility, authorizations);
        this.graph.addEdge("http://visallo.org/termMention#resolvedTo" + termMentionVertexId, termMention, vertex, "http://visallo.org/termMention#resolvedTo", visibility, authorizations);
        this.graph.flush();
        LOGGER.debug("added source info: %s", termMention.getId());
    }

    public void addSourceInfoEdgeToEdge(Edge edge, String forElementId, TermMentionFor forType, String propertyKey, String propertyName, Visibility propertyVisibility, String snippet, String textPropertyKey, String textPropertyName, long startOffset, long endOffset, Vertex originalVertex, Visibility visibility, Authorizations authorizations) {
        Vertex inVertex = edge.getVertex(Direction.IN, authorizations);
        Vertex outVertex = edge.getVertex(Direction.OUT, authorizations);
        this.addSourceInfoToVertex(inVertex, forElementId, forType, propertyKey, propertyName, propertyVisibility, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, originalVertex, visibility, authorizations);
        this.addSourceInfoToVertex(outVertex, forElementId, forType, propertyKey, propertyName, propertyVisibility, snippet, textPropertyKey, textPropertyName, startOffset, endOffset, originalVertex, visibility, authorizations);
    }

    public void removeSourceInfoEdge(Element element, String propertyKey, String propertyName, VisalloVisibility visalloVisibility, Authorizations authorizations) {
        if (element instanceof Vertex) {
            this.removeSourceInfoEdgeFromVertex(element.getId(), element.getId(), propertyKey, propertyName, visalloVisibility, authorizations);
        } else {
            this.removeSourceInfoEdgeFromEdge((Edge)element, propertyKey, propertyName, visalloVisibility, authorizations);
        }
    }

    public void removeSourceInfoEdgeFromVertex(String vertexId, String sourceInfoElementId, String propertyKey, String propertyName, VisalloVisibility visalloVisibility, Authorizations authorizations) {
        Vertex termMention = this.findTermMention(vertexId, sourceInfoElementId, propertyKey, propertyName, visalloVisibility.getVisibility(), authorizations);
        if (termMention != null) {
            this.graph.softDeleteVertex(termMention, authorizations);
        }
    }

    public void removeSourceInfoEdgeFromEdge(Edge edge, String propertyKey, String propertyName, VisalloVisibility visalloVisibility, Authorizations authorizations) {
        String inVertexId = edge.getVertexId(Direction.IN);
        String outVertexId = edge.getVertexId(Direction.OUT);
        this.removeSourceInfoEdgeFromVertex(inVertexId, edge.getId(), propertyKey, propertyName, visalloVisibility, authorizations);
        this.removeSourceInfoEdgeFromVertex(outVertexId, edge.getId(), propertyKey, propertyName, visalloVisibility, authorizations);
    }

    private Vertex findTermMention(String vertexId, String forElementId, String propertyKey, String propertyName, Visibility propertyVisibility, Authorizations authorizations) {
        Authorizations authorizationsWithTermMentions = this.getAuthorizations(authorizations);
        Vertex vertex = this.graph.getVertex(vertexId, authorizationsWithTermMentions);
        Iterable termMentions = vertex.getVertices(Direction.IN, "http://visallo.org/termMention#resolvedTo", authorizationsWithTermMentions);
        for (Vertex termMention : termMentions) {
            if (forElementId != null && !forElementId.equals(VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue((Element)termMention)) || propertyKey != null && !propertyKey.equals(VisalloProperties.TERM_MENTION_REF_PROPERTY_KEY.getPropertyValue((Element)termMention)) || propertyName != null && !propertyName.equals(VisalloProperties.TERM_MENTION_REF_PROPERTY_NAME.getPropertyValue((Element)termMention)) || propertyVisibility != null && !propertyVisibility.toString().equals(VisalloProperties.TERM_MENTION_REF_PROPERTY_VISIBILITY.getPropertyValue((Element)termMention))) continue;
            return termMention;
        }
        return null;
    }

    public ClientApiSourceInfo getSourceInfoForEdge(Edge edge, Authorizations authorizations) {
        String inVertexId = edge.getVertexId(Direction.IN);
        Vertex termMention = this.findTermMention(inVertexId, edge.getId(), null, null, null, authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    public ClientApiSourceInfo getSourceInfoForVertex(Vertex vertex, Authorizations authorizations) {
        Vertex termMention = this.findTermMention(vertex.getId(), vertex.getId(), null, null, null, authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    public ClientApiSourceInfo getSourceInfoForEdgeProperty(Edge edge, String propertyKey, String propertyName, Visibility visibility, Authorizations authorizations) {
        String inVertexId = edge.getVertexId(Direction.IN);
        Vertex termMention = this.findTermMention(inVertexId, edge.getId(), propertyKey, propertyName, visibility, authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    public ClientApiSourceInfo getSourceInfoForVertexProperty(String vertexId, Property property, Authorizations authorizations) {
        Vertex termMention = this.findTermMention(vertexId, vertexId, property.getKey(), property.getName(), property.getVisibility(), authorizations);
        return this.getSourceInfoFromTermMention(termMention, authorizations);
    }

    private ClientApiSourceInfo getSourceInfoFromTermMention(Vertex termMention, Authorizations authorizations) {
        if (termMention == null) {
            return null;
        }
        Authorizations authorizationsWithTermMention = this.getAuthorizations(authorizations);
        ClientApiSourceInfo result = new ClientApiSourceInfo();
        result.vertexId = (String)IterableUtils.single((Iterable)termMention.getVertexIds(Direction.IN, "http://visallo.org/termMention#hasTermMention", authorizationsWithTermMention));
        result.textPropertyKey = (String)VisalloProperties.TERM_MENTION_PROPERTY_KEY.getPropertyValue((Element)termMention);
        result.textPropertyName = (String)VisalloProperties.TERM_MENTION_PROPERTY_NAME.getPropertyValue((Element)termMention);
        result.startOffset = (Long)VisalloProperties.TERM_MENTION_START_OFFSET.getPropertyValue((Element)termMention);
        result.endOffset = (Long)VisalloProperties.TERM_MENTION_END_OFFSET.getPropertyValue((Element)termMention);
        result.snippet = (String)VisalloProperties.TERM_MENTION_SNIPPET.getPropertyValue((Element)termMention);
        return result;
    }

    public ClientApiTermMentionsResponse toClientApi(Iterable<Vertex> termMentions, String workspaceId, Authorizations authorizations) {
        authorizations = this.getAuthorizations(authorizations);
        ClientApiTermMentionsResponse termMentionsResponse = new ClientApiTermMentionsResponse();
        termMentionsResponse.getTermMentions().addAll(ClientApiConverter.toClientApi(termMentions, workspaceId, true, authorizations));
        return termMentionsResponse;
    }
}

