/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.artifactThumbnails;

import com.v5analytics.simpleorm.Entity;
import com.v5analytics.simpleorm.Field;
import com.v5analytics.simpleorm.Id;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;

@Entity(tableName="artifactThumbnail")
public class ArtifactThumbnail {
    @Id
    private String id;
    @Field
    private byte[] data;
    @Field
    private String format;

    protected ArtifactThumbnail() {
    }

    public ArtifactThumbnail(String artifactVertexId, String type, byte[] data, String format, int width, int height) {
        this.id = ArtifactThumbnail.createId(artifactVertexId, type, width, height);
        this.data = data;
        this.format = format;
    }

    public static String createId(String artifactVertexId, String type, int width, int height) {
        return artifactVertexId + ":" + type + ":" + StringUtils.leftPad((String)Integer.toString(width), (int)8, (char)'0') + ":" + StringUtils.leftPad((String)Integer.toString(height), (int)8, (char)'0');
    }

    public byte[] getData() {
        return this.data;
    }

    public String getFormat() {
        return this.format;
    }

    public BufferedImage getImage() {
        try {
            byte[] data = this.getData();
            return ImageIO.read(new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load image", e);
        }
    }
}

