/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.ingest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.ingest.FileImportSupportingFileHandler;
import org.visallo.core.model.Description;
import org.visallo.core.model.Name;
import org.visallo.core.model.properties.VisalloProperties;

@Name(value="Metadata Import")
@Description(value="Imports a .metadata.json file and assigns it to a metadata JSON property on that vertex")
public class MetadataFileImportSupportingFileHandler
extends FileImportSupportingFileHandler {
    private static final String METADATA_JSON_FILE_NAME_SUFFIX = ".metadata.json";

    @Override
    public boolean isSupportingFile(File f) {
        return f.getName().endsWith(METADATA_JSON_FILE_NAME_SUFFIX);
    }

    @Override
    public FileImportSupportingFileHandler.AddSupportingFilesResult addSupportingFiles(VertexBuilder vertexBuilder, File f, Visibility visibility) throws FileNotFoundException {
        File mappingJsonFile = MetadataFileImportSupportingFileHandler.getMetadataFile(f);
        if (mappingJsonFile.exists()) {
            final FileInputStream mappingJsonInputStream = new FileInputStream(mappingJsonFile);
            StreamingPropertyValue mappingJsonValue = new StreamingPropertyValue((InputStream)mappingJsonInputStream, byte[].class);
            mappingJsonValue.searchIndex(false);
            VisalloProperties.METADATA_JSON.setProperty((ElementMutation<?>)vertexBuilder, mappingJsonValue, visibility);
            return new FileImportSupportingFileHandler.AddSupportingFilesResult(){

                @Override
                public void close() throws IOException {
                    mappingJsonInputStream.close();
                }
            };
        }
        return null;
    }

    public static File getMetadataFile(File f) {
        return new File(f.getParentFile(), f.getName() + METADATA_JSON_FILE_NAME_SUFFIX);
    }
}

