(function(){var moment,VERSION="2.0.0",round=Math.round,i,languages={},hasModule=typeof module!=="undefined"&&module.exports,aspNetJsonRegex=/^\/?Date\((\-?\d+)/i,aspNetTimeSpanJsonRegex=/(\-)?(\d*)?\.?(\d+)\:(\d+)\:(\d+)\.?(\d{3})?/,formattingTokens=/(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|SS?S?|X|zz?|ZZ?|.)/g,localFormattingTokens=/(\[[^\[]*\])|(\\)?(LT|LL?L?L?|l{1,4})/g,parseMultipleFormatChunker=/([0-9a-zA-Z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)/gi,parseTokenOneOrTwoDigits=/\d\d?/,parseTokenOneToThreeDigits=/\d{1,3}/,parseTokenThreeDigits=/\d{3}/,parseTokenFourDigits=/\d{1,4}/,parseTokenSixDigits=/[+\-]?\d{1,6}/,parseTokenWord=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,parseTokenTimezone=/Z|[\+\-]\d\d:?\d\d/i,parseTokenT=/T/i,parseTokenTimestampMs=/[\+\-]?\d+(\.\d{1,3})?/,isoRegex=/^\s*\d{4}-\d\d-\d\d((T| )(\d\d(:\d\d(:\d\d(\.\d\d?\d?)?)?)?)?([\+\-]\d\d:?\d\d)?)?/,isoFormat="YYYY-MM-DDTHH:mm:ssZ",isoTimes=[["HH:mm:ss.S",/(T| )\d\d:\d\d:\d\d\.\d{1,3}/],["HH:mm:ss",/(T| )\d\d:\d\d:\d\d/],["HH:mm",/(T| )\d\d:\d\d/],["HH",/(T| )\d\d/]],parseTimezoneChunker=/([\+\-]|\d\d)/gi,proxyGettersAndSetters="Date|Hours|Minutes|Seconds|Milliseconds".split("|"),unitMillisecondFactors={Milliseconds:1,Seconds:1e3,Minutes:6e4,Hours:36e5,Days:864e5,Months:2592e6,Years:31536e6},unitAliases={ms:"millisecond",s:"second",m:"minute",h:"hour",d:"day",w:"week",M:"month",y:"year"},formatFunctions={},ordinalizeTokens="DDD w W M D d".split(" "),paddedTokens="M D H h m s w W".split(" "),formatTokenFunctions={M:function(){return this.month()+1},MMM:function(format){return this.lang().monthsShort(this,format)},MMMM:function(format){return this.lang().months(this,format)},D:function(){return this.date()},DDD:function(){return this.dayOfYear()},d:function(){return this.day()},dd:function(format){return this.lang().weekdaysMin(this,format)},ddd:function(format){return this.lang().weekdaysShort(this,format)},dddd:function(format){return this.lang().weekdays(this,format)},w:function(){return this.week()},W:function(){return this.isoWeek()},YY:function(){return leftZeroFill(this.year()%100,2)},YYYY:function(){return leftZeroFill(this.year(),4)},YYYYY:function(){return leftZeroFill(this.year(),5)},gg:function(){return leftZeroFill(this.weekYear()%100,2)},gggg:function(){return this.weekYear()},ggggg:function(){return leftZeroFill(this.weekYear(),5)},GG:function(){return leftZeroFill(this.isoWeekYear()%100,2)},GGGG:function(){return this.isoWeekYear()},GGGGG:function(){return leftZeroFill(this.isoWeekYear(),5)},e:function(){return this.weekday()},E:function(){return this.isoWeekday()},a:function(){return this.lang().meridiem(this.hours(),this.minutes(),true)},A:function(){return this.lang().meridiem(this.hours(),this.minutes(),false)},H:function(){return this.hours()},h:function(){return this.hours()%12||12},m:function(){return this.minutes()},s:function(){return this.seconds()},S:function(){return~~(this.milliseconds()/100)},SS:function(){return leftZeroFill(~~(this.milliseconds()/10),2)},SSS:function(){return leftZeroFill(this.milliseconds(),3)},Z:function(){var a=-this.zone(),b="+";if(a<0){a=-a;b="-"}return b+leftZeroFill(~~(a/60),2)+":"+leftZeroFill(~~a%60,2)},ZZ:function(){var a=-this.zone(),b="+";if(a<0){a=-a;b="-"}return b+leftZeroFill(~~(10*a/6),4)},z:function(){return this.zoneAbbr()},zz:function(){return this.zoneName()},X:function(){return this.unix()}};function padToken(func,count){return function(a){return leftZeroFill(func.call(this,a),count)}}function ordinalizeToken(func,period){return function(a){return this.lang().ordinal(func.call(this,a),period)}}while(ordinalizeTokens.length){i=ordinalizeTokens.pop();formatTokenFunctions[i+"o"]=ordinalizeToken(formatTokenFunctions[i],i)}while(paddedTokens.length){i=paddedTokens.pop();formatTokenFunctions[i+i]=padToken(formatTokenFunctions[i],2)}formatTokenFunctions.DDDD=padToken(formatTokenFunctions.DDD,3);function Language(){}function Moment(config){extend(this,config)}function Duration(duration){var data=this._data={},years=duration.years||duration.year||duration.y||0,months=duration.months||duration.month||duration.M||0,weeks=duration.weeks||duration.week||duration.w||0,days=duration.days||duration.day||duration.d||0,hours=duration.hours||duration.hour||duration.h||0,minutes=duration.minutes||duration.minute||duration.m||0,seconds=duration.seconds||duration.second||duration.s||0,milliseconds=duration.milliseconds||duration.millisecond||duration.ms||0;this._milliseconds=milliseconds+seconds*1e3+minutes*6e4+hours*36e5;this._days=days+weeks*7;this._months=months+years*12;data.milliseconds=milliseconds%1e3;seconds+=absRound(milliseconds/1e3);data.seconds=seconds%60;minutes+=absRound(seconds/60);data.minutes=minutes%60;hours+=absRound(minutes/60);data.hours=hours%24;days+=absRound(hours/24);days+=weeks*7;data.days=days%30;months+=absRound(days/30);data.months=months%12;years+=absRound(months/12);data.years=years}function extend(a,b){for(var i in b){if(b.hasOwnProperty(i)){a[i]=b[i]}}return a}function absRound(number){if(number<0){return Math.ceil(number)}else{return Math.floor(number)}}function leftZeroFill(number,targetLength){var output=number+"";while(output.length<targetLength){output="0"+output}return output}function addOrSubtractDurationFromMoment(mom,duration,isAdding,ignoreUpdateOffset){var milliseconds=duration._milliseconds,days=duration._days,months=duration._months,minutes,hours,currentDate;if(milliseconds){mom._d.setTime(+mom._d+milliseconds*isAdding)}if(days||months){minutes=mom.minute();hours=mom.hour()}if(days){mom.date(mom.date()+days*isAdding)}if(months){currentDate=mom.date();mom.date(1).month(mom.month()+months*isAdding).date(Math.min(currentDate,mom.daysInMonth()))}if(milliseconds&&!ignoreUpdateOffset){moment.updateOffset(mom)}if(days||months){mom.minute(minutes);mom.hour(hours)}}function isArray(input){return Object.prototype.toString.call(input)==="[object Array]"}function compareArrays(array1,array2){var len=Math.min(array1.length,array2.length),lengthDiff=Math.abs(array1.length-array2.length),diffs=0,i;for(i=0;i<len;i++){if(~~array1[i]!==~~array2[i]){diffs++}}return diffs+lengthDiff}function normalizeUnits(units){return units?unitAliases[units]||units.toLowerCase().replace(/(.)s$/,"$1"):units}Language.prototype={set:function(config){var prop,i;for(i in config){prop=config[i];if(typeof prop==="function"){this[i]=prop}else{this["_"+i]=prop}}},_months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),months:function(m){return this._months[m.month()]},_monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),monthsShort:function(m){return this._monthsShort[m.month()]},monthsParse:function(monthName){var i,mom,regex;if(!this._monthsParse){this._monthsParse=[]}for(i=0;i<12;i++){if(!this._monthsParse[i]){mom=moment([2e3,i]);regex="^"+this.months(mom,"")+"|^"+this.monthsShort(mom,"");this._monthsParse[i]=new RegExp(regex.replace(".",""),"i")}if(this._monthsParse[i].test(monthName)){return i}}},_weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdays:function(m){return this._weekdays[m.day()]},_weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysShort:function(m){return this._weekdaysShort[m.day()]},_weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),weekdaysMin:function(m){return this._weekdaysMin[m.day()]},weekdaysParse:function(weekdayName){var i,mom,regex;if(!this._weekdaysParse){this._weekdaysParse=[]}for(i=0;i<7;i++){if(!this._weekdaysParse[i]){mom=moment([2e3,1]).day(i);regex="^"+this.weekdays(mom,"")+"|^"+this.weekdaysShort(mom,"")+"|^"+this.weekdaysMin(mom,"");this._weekdaysParse[i]=new RegExp(regex.replace(".",""),"i")}if(this._weekdaysParse[i].test(weekdayName)){return i}}},_longDateFormat:{LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D YYYY",LLL:"MMMM D YYYY LT",LLLL:"dddd, MMMM D YYYY LT"},longDateFormat:function(key){var output=this._longDateFormat[key];if(!output&&this._longDateFormat[key.toUpperCase()]){output=this._longDateFormat[key.toUpperCase()].replace(/MMMM|MM|DD|dddd/g,function(val){return val.slice(1)});this._longDateFormat[key]=output}return output},isPM:function(input){return(input+"").toLowerCase()[0]==="p"},_meridiemParse:/[ap]\.?m?\.?/i,meridiem:function(hours,minutes,isLower){if(hours>11){return isLower?"pm":"PM"}else{return isLower?"am":"AM"}},_calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},calendar:function(key,mom){var output=this._calendar[key];return typeof output==="function"?output.apply(mom):output},_relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},relativeTime:function(number,withoutSuffix,string,isFuture){var output=this._relativeTime[string];return typeof output==="function"?output(number,withoutSuffix,string,isFuture):output.replace(/%d/i,number)},pastFuture:function(diff,output){var format=this._relativeTime[diff>0?"future":"past"];return typeof format==="function"?format(output):format.replace(/%s/i,output)},ordinal:function(number){return this._ordinal.replace("%d",number)},_ordinal:"%d",preparse:function(string){return string},postformat:function(string){return string},week:function(mom){return weekOfYear(mom,this._week.dow,this._week.doy).week},_week:{dow:0,doy:6}};function loadLang(key,values){values.abbr=key;if(!languages[key]){languages[key]=new Language}languages[key].set(values);return languages[key]}function getLangDefinition(key){if(!key){return moment.fn._lang}if(!languages[key]&&hasModule){require("./lang/"+key)}return languages[key]}function removeFormattingTokens(input){if(input.match(/\[.*\]/)){return input.replace(/^\[|\]$/g,"")}return input.replace(/\\/g,"")}function makeFormatFunction(format){var array=format.match(formattingTokens),i,length;for(i=0,length=array.length;i<length;i++){if(formatTokenFunctions[array[i]]){array[i]=formatTokenFunctions[array[i]]}else{array[i]=removeFormattingTokens(array[i])}}return function(mom){var output="";for(i=0;i<length;i++){output+=array[i]instanceof Function?array[i].call(mom,format):array[i]}return output}}function formatMoment(m,format){var i=5;function replaceLongDateFormatTokens(input){return m.lang().longDateFormat(input)||input}while(i--&&localFormattingTokens.test(format)){format=format.replace(localFormattingTokens,replaceLongDateFormatTokens)}if(!formatFunctions[format]){formatFunctions[format]=makeFormatFunction(format)}return formatFunctions[format](m)}function getParseRegexForToken(token,config){switch(token){case"DDDD":return parseTokenThreeDigits;case"YYYY":return parseTokenFourDigits;case"YYYYY":return parseTokenSixDigits;case"S":case"SS":case"SSS":case"DDD":return parseTokenOneToThreeDigits;case"MMM":case"MMMM":case"dd":case"ddd":case"dddd":return parseTokenWord;case"a":case"A":return getLangDefinition(config._l)._meridiemParse;case"X":return parseTokenTimestampMs;case"Z":case"ZZ":return parseTokenTimezone;case"T":return parseTokenT;case"MM":case"DD":case"YY":case"HH":case"hh":case"mm":case"ss":case"M":case"D":case"d":case"H":case"h":case"m":case"s":return parseTokenOneOrTwoDigits;default:return new RegExp(token.replace("\\",""))}}function timezoneMinutesFromString(string){var tzchunk=(parseTokenTimezone.exec(string)||[])[0],parts=(tzchunk+"").match(parseTimezoneChunker)||["-",0,0],minutes=+(parts[1]*60)+~~parts[2];return parts[0]==="+"?-minutes:minutes}function addTimeToArrayFromToken(token,input,config){var a,b,datePartArray=config._a;switch(token){case"M":case"MM":datePartArray[1]=input==null?0:~~input-1;break;case"MMM":case"MMMM":a=getLangDefinition(config._l).monthsParse(input);if(a!=null){datePartArray[1]=a}else{config._isValid=false}break;case"D":case"DD":case"DDD":case"DDDD":if(input!=null){datePartArray[2]=~~input}break;case"YY":datePartArray[0]=~~input+(~~input>68?1900:2e3);break;case"YYYY":case"YYYYY":datePartArray[0]=~~input;break;case"a":case"A":config._isPm=getLangDefinition(config._l).isPM(input);break;case"H":case"HH":case"h":case"hh":datePartArray[3]=~~input;break;case"m":case"mm":datePartArray[4]=~~input;break;case"s":case"ss":datePartArray[5]=~~input;break;case"S":case"SS":case"SSS":datePartArray[6]=~~(("0."+input)*1e3);break;case"X":config._d=new Date(parseFloat(input)*1e3);break;case"Z":case"ZZ":config._useUTC=true;config._tzm=timezoneMinutesFromString(input);break}if(input==null){config._isValid=false}}function dateFromArray(config){var i,date,input=[];if(config._d){return}for(i=0;i<7;i++){config._a[i]=input[i]=config._a[i]==null?i===2?1:0:config._a[i]}input[3]+=~~((config._tzm||0)/60);input[4]+=~~((config._tzm||0)%60);date=new Date(0);if(config._useUTC){date.setUTCFullYear(input[0],input[1],input[2]);date.setUTCHours(input[3],input[4],input[5],input[6])}else{date.setFullYear(input[0],input[1],input[2]);date.setHours(input[3],input[4],input[5],input[6])}config._d=date}function makeDateFromStringAndFormat(config){var tokens=config._f.match(formattingTokens),string=config._i,i,parsedInput;config._a=[];for(i=0;i<tokens.length;i++){parsedInput=(getParseRegexForToken(tokens[i],config).exec(string)||[])[0];if(parsedInput){string=string.slice(string.indexOf(parsedInput)+parsedInput.length)}if(formatTokenFunctions[tokens[i]]){addTimeToArrayFromToken(tokens[i],parsedInput,config)}}if(string){config._il=string}if(config._isPm&&config._a[3]<12){config._a[3]+=12}if(config._isPm===false&&config._a[3]===12){config._a[3]=0}dateFromArray(config)}function makeDateFromStringAndArray(config){var tempConfig,tempMoment,bestMoment,scoreToBeat=99,i,currentScore;for(i=0;i<config._f.length;i++){tempConfig=extend({},config);tempConfig._f=config._f[i];makeDateFromStringAndFormat(tempConfig);tempMoment=new Moment(tempConfig);currentScore=compareArrays(tempConfig._a,tempMoment.toArray());if(tempMoment._il){currentScore+=tempMoment._il.length}if(currentScore<scoreToBeat){scoreToBeat=currentScore;bestMoment=tempMoment}}extend(config,bestMoment)}function makeDateFromString(config){var i,string=config._i,match=isoRegex.exec(string);if(match){config._f="YYYY-MM-DD"+(match[2]||" ");for(i=0;i<4;i++){if(isoTimes[i][1].exec(string)){config._f+=isoTimes[i][0];break}}if(parseTokenTimezone.exec(string)){config._f+=" Z"}makeDateFromStringAndFormat(config)}else{config._d=new Date(string)}}function makeDateFromInput(config){var input=config._i,matched=aspNetJsonRegex.exec(input);if(input===undefined){config._d=new Date}else if(matched){config._d=new Date(+matched[1])}else if(typeof input==="string"){makeDateFromString(config)}else if(isArray(input)){config._a=input.slice(0);dateFromArray(config)}else{config._d=input instanceof Date?new Date(+input):new Date(input)}}function substituteTimeAgo(string,number,withoutSuffix,isFuture,lang){return lang.relativeTime(number||1,!!withoutSuffix,string,isFuture)}function relativeTime(milliseconds,withoutSuffix,lang){var seconds=round(Math.abs(milliseconds)/1e3),minutes=round(seconds/60),hours=round(minutes/60),days=round(hours/24),years=round(days/365),args=seconds<45&&["s",seconds]||minutes===1&&["m"]||minutes<45&&["mm",minutes]||hours===1&&["h"]||hours<22&&["hh",hours]||days===1&&["d"]||days<=25&&["dd",days]||days<=45&&["M"]||days<345&&["MM",round(days/30)]||years===1&&["y"]||["yy",years];args[2]=withoutSuffix;args[3]=milliseconds>0;args[4]=lang;return substituteTimeAgo.apply({},args)}function weekOfYear(mom,firstDayOfWeek,firstDayOfWeekOfYear){var end=firstDayOfWeekOfYear-firstDayOfWeek,daysToDayOfWeek=firstDayOfWeekOfYear-mom.day(),adjustedMoment;if(daysToDayOfWeek>end){daysToDayOfWeek-=7}if(daysToDayOfWeek<end-7){daysToDayOfWeek+=7}adjustedMoment=moment(mom).add("d",daysToDayOfWeek);return{week:Math.ceil(adjustedMoment.dayOfYear()/7),year:adjustedMoment.year()}}function makeMoment(config){var input=config._i,format=config._f;if(input===null||input===""){return null}if(typeof input==="string"){config._i=input=getLangDefinition().preparse(input)}if(moment.isMoment(input)){config=extend({},input);config._d=new Date(+input._d)}else if(format){if(isArray(format)){makeDateFromStringAndArray(config)}else{makeDateFromStringAndFormat(config)}}else{makeDateFromInput(config)}return new Moment(config)}moment=function(input,format,lang){return makeMoment({_i:input,_f:format,_l:lang,_isUTC:false})};moment.utc=function(input,format,lang){return makeMoment({_useUTC:true,_isUTC:true,_l:lang,_i:input,_f:format})};moment.unix=function(input){return moment(input*1e3)};moment.duration=function(input,key){var isDuration=moment.isDuration(input),isNumber=typeof input==="number",duration=isDuration?input._data:isNumber?{}:input,matched=aspNetTimeSpanJsonRegex.exec(input),sign,ret;if(isNumber){if(key){duration[key]=input}else{duration.milliseconds=input}}else if(matched){sign=matched[1]==="-"?-1:1;duration={y:0,d:~~matched[2]*sign,h:~~matched[3]*sign,m:~~matched[4]*sign,s:~~matched[5]*sign,ms:~~matched[6]*sign}}ret=new Duration(duration);if(isDuration&&input.hasOwnProperty("_lang")){ret._lang=input._lang}return ret};moment.version=VERSION;moment.defaultFormat=isoFormat;moment.updateOffset=function(){};moment.lang=function(key,values){var i;if(!key){return moment.fn._lang._abbr}if(values){loadLang(key,values)}else if(!languages[key]){getLangDefinition(key)}moment.duration.fn._lang=moment.fn._lang=getLangDefinition(key)};moment.langData=function(key){if(key&&key._lang&&key._lang._abbr){key=key._lang._abbr}return getLangDefinition(key)};moment.isMoment=function(obj){return obj instanceof Moment};moment.isDuration=function(obj){return obj instanceof Duration};moment.fn=Moment.prototype={clone:function(){return moment(this)},valueOf:function(){return+this._d+(this._offset||0)*6e4},unix:function(){return Math.floor(+this/1e3)},toString:function(){return this.format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")},toDate:function(){return this._offset?new Date(+this):this._d},toISOString:function(){return formatMoment(moment(this).utc(),"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]")},toArray:function(){var m=this;return[m.year(),m.month(),m.date(),m.hours(),m.minutes(),m.seconds(),m.milliseconds()]},isValid:function(){if(this._isValid==null){if(this._a){this._isValid=!compareArrays(this._a,(this._isUTC?moment.utc(this._a):moment(this._a)).toArray())}else{this._isValid=!isNaN(this._d.getTime())}}return!!this._isValid},utc:function(){return this.zone(0)},local:function(){this.zone(0);this._isUTC=false;return this},format:function(inputString){var output=formatMoment(this,inputString||moment.defaultFormat);return this.lang().postformat(output)},add:function(input,val){var dur;if(typeof input==="string"){dur=moment.duration(+val,input)}else{dur=moment.duration(input,val)}addOrSubtractDurationFromMoment(this,dur,1);return this},subtract:function(input,val){var dur;if(typeof input==="string"){dur=moment.duration(+val,input)}else{dur=moment.duration(input,val)}addOrSubtractDurationFromMoment(this,dur,-1);return this},diff:function(input,units,asFloat){var that=this._isUTC?moment(input).zone(this._offset||0):moment(input).local(),zoneDiff=(this.zone()-that.zone())*6e4,diff,output;units=normalizeUnits(units);if(units==="year"||units==="month"){diff=(this.daysInMonth()+that.daysInMonth())*432e5;output=(this.year()-that.year())*12+(this.month()-that.month());output+=(this-moment(this).startOf("month")-(that-moment(that).startOf("month")))/diff;if(units==="year"){output=output/12}}else{diff=this-that-zoneDiff;output=units==="second"?diff/1e3:units==="minute"?diff/6e4:units==="hour"?diff/36e5:units==="day"?diff/864e5:units==="week"?diff/6048e5:diff}return asFloat?output:absRound(output)},from:function(time,withoutSuffix){return moment.duration(this.diff(time)).lang(this.lang()._abbr).humanize(!withoutSuffix)},fromNow:function(withoutSuffix){return this.from(moment(),withoutSuffix)},calendar:function(){var diff=this.diff(moment().startOf("day"),"days",true),format=diff<-6?"sameElse":diff<-1?"lastWeek":diff<0?"lastDay":diff<1?"sameDay":diff<2?"nextDay":diff<7?"nextWeek":"sameElse";return this.format(this.lang().calendar(format,this))},isLeapYear:function(){var year=this.year();return year%4===0&&year%100!==0||year%400===0},isDST:function(){return this.zone()<this.clone().month(0).zone()||this.zone()<this.clone().month(5).zone()},day:function(input){var day=this._isUTC?this._d.getUTCDay():this._d.getDay();if(input!=null){if(typeof input==="string"){input=this.lang().weekdaysParse(input);if(typeof input!=="number"){return this}}return this.add({d:input-day})}else{return day}},month:function(input){var utc=this._isUTC?"UTC":"";if(input!=null){if(typeof input==="string"){input=this.lang().monthsParse(input);if(typeof input!=="number"){return this}}this._d["set"+utc+"Month"](input);moment.updateOffset(this);return this}else{return this._d["get"+utc+"Month"]()}},startOf:function(units){units=normalizeUnits(units);switch(units){case"year":this.month(0);case"month":this.date(1);case"week":case"day":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}if(units==="week"){this.weekday(0)}return this},endOf:function(units){return this.startOf(units).add(units,1).subtract("ms",1)},isAfter:function(input,units){units=typeof units!=="undefined"?units:"millisecond";return+this.clone().startOf(units)>+moment(input).startOf(units)},isBefore:function(input,units){units=typeof units!=="undefined"?units:"millisecond";return+this.clone().startOf(units)<+moment(input).startOf(units)},isSame:function(input,units){units=typeof units!=="undefined"?units:"millisecond";return+this.clone().startOf(units)===+moment(input).startOf(units)},min:function(other){other=moment.apply(null,arguments);return other<this?this:other},max:function(other){other=moment.apply(null,arguments);return other>this?this:other},zone:function(input){var offset=this._offset||0;if(input!=null){if(typeof input==="string"){input=timezoneMinutesFromString(input)}if(Math.abs(input)<16){input=input*60}this._offset=input;this._isUTC=true;if(offset!==input){addOrSubtractDurationFromMoment(this,moment.duration(offset-input,"m"),1,true)}}else{return this._isUTC?offset:this._d.getTimezoneOffset()}return this},zoneAbbr:function(){return this._isUTC?"UTC":""},zoneName:function(){return this._isUTC?"Coordinated Universal Time":""},daysInMonth:function(){return moment.utc([this.year(),this.month()+1,0]).date()},dayOfYear:function(input){var dayOfYear=round((moment(this).startOf("day")-moment(this).startOf("year"))/864e5)+1;return input==null?dayOfYear:this.add("d",input-dayOfYear)},weekYear:function(input){var year=weekOfYear(this,this.lang()._week.dow,this.lang()._week.doy).year;return input==null?year:this.add("y",input-year)},isoWeekYear:function(input){var year=weekOfYear(this,1,4).year;return input==null?year:this.add("y",input-year)},week:function(input){var week=this.lang().week(this);return input==null?week:this.add("d",(input-week)*7)},isoWeek:function(input){var week=weekOfYear(this,1,4).week;return input==null?week:this.add("d",(input-week)*7)},weekday:function(input){var weekday=(this._d.getDay()+7-this.lang()._week.dow)%7;return input==null?weekday:this.add("d",input-weekday)},isoWeekday:function(input){var weekday=(this._d.getDay()+6)%7;return input==null?weekday:this.add("d",input-weekday)},lang:function(key){if(key===undefined){return this._lang}else{this._lang=getLangDefinition(key);return this}}};function makeGetterAndSetter(name,key){moment.fn[name]=moment.fn[name+"s"]=function(input){var utc=this._isUTC?"UTC":"";if(input!=null){this._d["set"+utc+key](input);moment.updateOffset(this);return this}else{return this._d["get"+utc+key]()}}}for(i=0;i<proxyGettersAndSetters.length;i++){makeGetterAndSetter(proxyGettersAndSetters[i].toLowerCase().replace(/s$/,""),proxyGettersAndSetters[i])}makeGetterAndSetter("year","FullYear");moment.fn.days=moment.fn.day;moment.fn.months=moment.fn.month;moment.fn.weeks=moment.fn.week;moment.fn.isoWeeks=moment.fn.isoWeek;moment.fn.toJSON=moment.fn.toISOString;moment.duration.fn=Duration.prototype={weeks:function(){return absRound(this.days()/7)},valueOf:function(){return this._milliseconds+this._days*864e5+this._months%12*2592e6+~~(this._months/12)*31536e6},humanize:function(withSuffix){var difference=+this,output=relativeTime(difference,!withSuffix,this.lang());if(withSuffix){output=this.lang().pastFuture(difference,output)}return this.lang().postformat(output)},add:function(input,val){var dur=moment.duration(input,val);this._milliseconds+=dur._milliseconds;this._days+=dur._days;this._months+=dur._months;return this},subtract:function(input,val){var dur=moment.duration(input,val);this._milliseconds-=dur._milliseconds;this._days-=dur._days;this._months-=dur._months;return this},get:function(units){units=normalizeUnits(units);return this[units.toLowerCase()+"s"]()},as:function(units){units=normalizeUnits(units);return this["as"+units.charAt(0).toUpperCase()+units.slice(1)+"s"]()},lang:moment.fn.lang};function makeDurationGetter(name){moment.duration.fn[name]=function(){return this._data[name]}}function makeDurationAsGetter(name,factor){moment.duration.fn["as"+name]=function(){return+this/factor}}for(i in unitMillisecondFactors){if(unitMillisecondFactors.hasOwnProperty(i)){makeDurationAsGetter(i,unitMillisecondFactors[i]);makeDurationGetter(i.toLowerCase())}}makeDurationAsGetter("Weeks",6048e5);moment.duration.fn.asMonths=function(){return(+this-this.years()*31536e6)/2592e6+this.years()*12};moment.lang("en",{ordinal:function(number){var b=number%10,output=~~(number%100/10)===1?"th":b===1?"st":b===2?"nd":b===3?"rd":"th";return number+output}});if(hasModule){module.exports=moment}(function(){var chrono=function(){for(var attr in chrono){this[attr]=chrono[attr]}this.parsers={};for(var p in chrono.parsers)this.parsers[p]=chrono.parsers[p];this.refiners={};for(var r in chrono.refiners)this.refiners[r]=chrono.refiners[r];this.timezoneMap={};for(var r in chrono.timezoneMap)this.timezoneMap[r]=chrono.timezoneMap[r]};chrono.timezoneMap={};chrono.parsers={};chrono.refiners={};chrono.parse=function(text,referrenceDate,option){option=option||{};if(typeof referrenceDate==="string"){var _ref=moment(referrenceDate).zone(referrenceDate);option.timezoneOffset=_ref.zone();referrenceDate=_ref.toDate()}var results=this.integratedParse(text,referrenceDate,option);var results=this.integratedRefine(text,results,option);return results};chrono.parseDate=function(text,referrenceDate,timezoneOffset){var results=this.parse(text,referrenceDate);if(results.length>=1)return results[0].start.date(timezoneOffset);else return null};if(typeof exports=="undefined"){moment=moment||window.moment;window.chrono=chrono}else{if(typeof moment=="undefined")eval("var moment = require('./moment');");var fs=require("fs");function loadModuleDirs(dir){var module_dirs=fs.readdirSync(__dirname+"/"+dir);module_dirs=module_dirs.filter(function(name){return!name.match(/\./)});for(var i in module_dirs){var dirname=module_dirs[i];if(typeof dirname=="function")continue;var parser_files=fs.readdirSync(__dirname+"/"+dir+"/"+dirname);for(var j in parser_files){var filename=parser_files[j];if(typeof filename=="function")continue;if(!filename.match(/\.js$/))continue;eval(fs.readFileSync(__dirname+"/"+dir+"/"+dirname+"/"+filename)+"")}}}eval(fs.readFileSync(__dirname+"/timezone.js")+"");eval(fs.readFileSync(__dirname+"/parsers/ParseResult.js")+"");eval(fs.readFileSync(__dirname+"/parsers/Parser.js")+"");eval(fs.readFileSync(__dirname+"/parsers/IntegratedParsing.js")+"");loadModuleDirs("parsers");eval(fs.readFileSync(__dirname+"/refiners/IntegratedRefinement.js")+"");loadModuleDirs("refiners");module.exports=chrono}})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";chrono.timezoneMap={A:60,ACDT:630,ACST:570,ADT:-180,AEDT:660,AEST:600,AFT:270,AKDT:-480,AKST:-540,ALMT:360,AMST:-180,AMT:-240,ANAST:720,ANAT:720,AQTT:300,ART:-180,AST:-240,AWDT:540,AWST:480,AZOST:0,AZOT:-60,AZST:300,AZT:240,B:120,BNT:480,BOT:-240,BRST:-120,BRT:-180,BST:60,BTT:360,C:180,CAST:480,CAT:120,CCT:390,CDT:-300,CEST:120,CET:60,CHADT:825,CHAST:765,CKT:-600,CLST:-180,CLT:-240,COT:-300,CST:-360,CVT:-60,CXT:420,ChST:600,D:240,DAVT:420,E:300,EASST:-300,EAST:-360,EAT:180,ECT:-300,EDT:-240,EEST:180,EET:120,EGST:0,EGT:-60,EST:-300,ET:-300,F:360,FJST:780,FJT:720,FKST:-180,FKT:-240,FNT:-120,G:420,GALT:-360,GAMT:-540,GET:240,GFT:-180,GILT:720,GMT:0,GST:240,GYT:-240,H:480,HAA:-180,HAC:-300,HADT:-540,HAE:-240,HAP:-420,HAR:-360,HAST:-600,HAT:-90,HAY:-480,HKT:480,HLV:-210,HNA:-240,HNC:-360,HNE:-300,HNP:-480,HNR:-420,HNT:-150,HNY:-540,HOVT:420,I:540,ICT:420,IDT:180,IOT:360,IRDT:270,IRKST:540,IRKT:540,IRST:210,IST:60,JST:540,K:600,KGT:360,KRAST:480,KRAT:480,KST:540,KUYT:240,L:660,LHDT:660,LHST:630,LINT:840,M:720,MAGST:720,MAGT:720,MART:-510,MAWT:300,MDT:-360,MESZ:120,MEZ:60,MHT:720,MMT:390,MSD:240,MSK:240,MST:-420,MUT:240,MVT:300,MYT:480,N:-60,NCT:660,NDT:-90,NFT:690,NOVST:420,NOVT:360,NPT:345,NST:-150,NUT:-660,NZDT:780,NZST:720,O:-120,OMSST:420,OMST:420,P:-180,PDT:-420,PET:-300,PETST:720,PETT:720,PGT:600,PHOT:780,PHT:480,PKT:300,PMDT:-120,PMST:-180,PONT:660,PST:-480,PT:-480,PWT:540,PYST:-180,PYT:-240,Q:-240,R:-300,RET:240,S:-360,SAMT:240,SAST:120,SBT:660,SCT:240,SGT:480,SRT:-180,SST:-660,T:-420,TAHT:-600,TFT:300,TJT:300,TKT:780,TLT:540,TMT:300,TVT:720,U:-480,ULAT:480,UTC:0,UYST:-120,UYT:-180,UZT:300,V:-540,VET:-210,VLAST:660,VLAT:660,VUT:660,W:-600,WAST:120,WAT:60,WEST:60,WESZ:60,WET:0,WEZ:0,WFT:720,WGST:-120,WGT:-180,WIB:420,WIT:540,WITA:480,WST:780,WT:0,X:-660,Y:-720,YAKST:600,YAKT:600,YAPT:600,YEKST:360,YEKT:360,Z:0}})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function DateComponents(components){this.year=components.year;this.month=components.month;this.day=components.day;this.hour=components.hour;this.minute=components.minute;this.second=components.second;this.timezoneOffset=components.timezoneOffset;this.dayOfWeek=components.dayOfWeek;if(components.meridiem)this.meridiem=components.meridiem.toLowerCase();if(components.impliedComponents&&components.impliedComponents.length>0){this.impliedComponents=components.impliedComponents}this.isCertain=function(component){return this[component]!==undefined&&this[component]!==null&&(this.impliedComponents?this.impliedComponents.indexOf(component)<0:true)};this.date=function(timezoneOffset){if(timezoneOffset===undefined||timezoneOffset===null){timezoneOffset=this.timezoneOffset}else{if(this.isCertain("timezoneOffset"))timezoneOffset=this.timezoneOffset}if(timezoneOffset===undefined||timezoneOffset===null)timezoneOffset=(new Date).getTimezoneOffset();var dateMoment=moment(new Date(this.year,this.month,this.day));if(this.hour===undefined||this.hour===null)dateMoment.hours(12);else dateMoment.hours(this.hour);dateMoment.minutes(this.minute);dateMoment.seconds(this.second);dateMoment.add("minutes",timezoneOffset-(new Date).getTimezoneOffset());return dateMoment.toDate()};this.assign=function(component,value){this[component]=value;if(this.impliedComponents&&this.impliedComponents.indexOf(component)>=0){var index=this.impliedComponents.indexOf(component);this.impliedComponents.splice(index,1)}};this.imply=function(component,value){this[component]=value;if(!this.impliedComponents)this.impliedComponents=[];if(this.impliedComponents.indexOf(component)<0){this.impliedComponents.push(component)}};if(this.isCertain("hour")&&this.hour>12){this.assign("meridiem","pm")}}function ParseResult(result){this.start=new DateComponents(result.start);this.startDate=this.start.date();if(result.end){this.end=new DateComponents(result.end);this.endDate=this.end.date()}this.referenceDate=result.referenceDate;this.index=result.index;this.text=result.text;this.concordance=result.concordance;
if(result.timezoneOffset){this.timezoneOffset=result.timezoneOffset}}chrono.DateComponents=DateComponents;chrono.ParseResult=ParseResult})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function Parser(text,ref,opt){opt=opt||{};var timezoneMap=opt.timezoneMap||chrono.timezoneMap;var searchingIndex=0;var searchingText=text;var searchingFinished=false;var searchingResults=[];var parser={};parser.pattern=function(){return/./i};parser.extract=function(text,index){return null};parser.results=function(){return searchingResults};parser.finished=function(){return searchingFinished};parser.mergeOverlapResult=function(text,result1,result2){if(result2.index<result1.index){var tmp=result1;result1=result2;result2=tmp}var begin=result1.index+result1.text.length;var end=result2.index;if(end<begin&&result1.index<result2.index&&begin<result2.index+result2.text.length){var mergedIndex=result1.index;var mergedText=text.substring(result1.index,result2.index+result2.text.length);var impliedComponents1=result1.start.impliedComponents||[];var impliedComponents2=result2.start.impliedComponents||[];if(impliedComponents1.length<impliedComponents2.length){var tmp=result1;result1=result2;result2=tmp;impliedComponents1=result1.start.impliedComponents||[];impliedComponents2=result2.start.impliedComponents||[]}if(impliedComponents1.indexOf("day")<0||impliedComponents1.indexOf("month")<0||impliedComponents1.indexOf("year")<0)return;return new chrono.ParseResult({referenceDate:result1.ref,index:mergedIndex,start:result2.start,end:result2.end,text:mergedText,referenceDate:result1.referenceDate})}var textBetween=text.substring(begin,end);var OVERLAP_PATTERN=/^\s*(to|\-)\s*$/i;if(!textBetween.match(OVERLAP_PATTERN))return null;var mergedText=result1.text+textBetween+result2.text;var components1=new Object(result1.start);var components2=new Object(result2.start);var impliedComponents1=result1.start.impliedComponents||[];var impliedComponents2=result2.start.impliedComponents||[];impliedComponents1.forEach(function(unknown_component){if(components2.isCertain(unknown_component)){components1.assign(unknown_component,components2[unknown_component])}});impliedComponents2.forEach(function(unknown_component){if(components1.isCertain(unknown_component)){components2.assign(unknown_component,components1[unknown_component])}});if(moment(components2.date()).diff(moment(components1.date()))>0){return new chrono.ParseResult({referenceDate:result1.ref,index:result1.index,start:components1,end:components2,text:mergedText,referenceDate:result1.referenceDate})}else{return new chrono.ParseResult({referenceDate:result1.ref,index:result1.index,start:components2,end:components1,text:mergedText,referenceDate:result1.referenceDate})}};parser.extractTime=function(text,result){var SUFFIX_PATTERN=/^\s*,?\s*(at|from|T)?\s*,?\s*([0-9]{1,4}|noon|midnight)((\.|\:|\：)([0-9]{1,2})((\.|\:|\：)([0-9]{1,3}))?)?(\s*(AM|PM))?(Z)?(\W|$)/i;if(text.length<=result.index+result.text.length)return null;text=text.substr(result.index+result.text.length);var matchedTokens=text.match(SUFFIX_PATTERN);if(!matchedTokens)return null;var minute=0;var second=0;var hour=matchedTokens[2];if(hour.toLowerCase()=="noon"){result.start.meridiem="pm";hour=12}else if(hour.toLowerCase()=="midnight"){result.start.meridiem="am";hour=0}else hour=parseInt(hour);if(matchedTokens[5]){minute=matchedTokens[5];minute=parseInt(minute);if(minute>=60)return null}else if(hour>100){minute=hour%100;hour=(hour-minute)/100}if(matchedTokens[8]){second=matchedTokens[8];second=parseInt(second);if(second>=60)return null}if(matchedTokens[10]){if(hour>12)return null;if(matchedTokens[10].toLowerCase()=="am"){if(hour==12)hour=0}if(matchedTokens[10].toLowerCase()=="pm"){if(hour!=12)hour+=12}result.start.meridiem=matchedTokens[10].toLowerCase()}if(hour>=12)result.start.meridiem="pm";if(hour>24)return null;if(matchedTokens[11]){result.start.assign("timezoneOffset",0)}result.text=result.text+matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[12].length);if(result.start.hour==undefined){result.start.hour=hour;result.start.minute=minute;result.start.second=second}text=text.substr(matchedTokens[0].length-matchedTokens[12].length);var TO_SUFFIX_PATTERN=/^\s*(\-|\~|\〜|to|\?)\s*([0-9]{1,4})((\.|\:|\：)([0-9]{1,2})((\.|\:|\：)([0-9]{1,2}))?)?(\s*(AM|PM))?/i;matchedTokens=text.match(TO_SUFFIX_PATTERN);if(!matchedTokens){if(result.end&&result.end.hour==undefined){result.end.hour=hour;result.end.minute=minute;result.end.second=second}return new chrono.ParseResult(result)}var minute=0;var second=0;var hour=matchedTokens[2];hour=parseInt(hour);if(matchedTokens[5]){minute=matchedTokens[5];minute=parseInt(minute);if(minute>=60)return null}else if(hour>100){if(!matchedTokens[10])return null;minute=hour%100;hour=(hour-minute)/100}if(matchedTokens[8]){second=matchedTokens[8];second=parseInt(second);if(second>=60)return null}if(matchedTokens[10]){if(hour>12)return null;if(matchedTokens[10].toLowerCase()=="am"){if(hour==12){hour=0;if(!result.end)result.end=new chrono.DateComponents(result.start);result.end.day+=1}}if(matchedTokens[10].toLowerCase()=="pm"){if(hour!=12)hour+=12}if(!result.start.meridiem){if(matchedTokens[10].toLowerCase()=="am"){if(result.start.hour==12)result.start.hour=0}if(matchedTokens[10].toLowerCase()=="pm"){if(result.start.hour!=12)result.start.hour+=12}result.start.imply("meridiem",matchedTokens[10].toLowerCase())}}result.text=result.text+matchedTokens[0];if(!result.end){result.end=new chrono.DateComponents(result.start);result.end.hour=hour;result.end.minute=minute;result.end.second=second}else{result.end.hour=hour;result.end.minute=minute;result.end.second=second}if(matchedTokens[10])result.end.meridiem=matchedTokens[10].toLowerCase();if(hour>=12)result.end.meridiem="pm";return new chrono.ParseResult(result)};parser.extractTimezone=function(text,result){var PATTERN=/^\s*(GMT|UTC)?(\+|\-)(\d{1,2}):?(\d{2})/;if(text.length<=result.index+result.text.length)return null;text=text.substr(result.index+result.text.length);var matchedTokens=text.match(PATTERN);if(matchedTokens){var timezoneOffset=parseInt(matchedTokens[3])*60+parseInt(matchedTokens[4]);var timezoneOffset=parseInt(matchedTokens[2]+timezoneOffset)*-1;if(result.end)result.end.timezoneOffset=timezoneOffset;result.start.timezoneOffset=timezoneOffset;result.text+=matchedTokens[0];text=text.substr(matchedTokens[0].length)}var PATTERN=/^\s*\(?([A-Z]{1,4})\)?(\W|$)/;var matchedTokens=text.match(PATTERN);if(matchedTokens&&timezoneMap[matchedTokens[1]]!==undefined){var timezoneAbbr=matchedTokens[1];var timezoneOffset=-timezoneMap[timezoneAbbr];if(result.start.timezoneOffset===undefined){result.start.timezoneOffset=timezoneOffset;if(result.end)result.end.timezoneOffset=timezoneOffset}result.text+=matchedTokens[0].substring(0,matchedTokens[0].length-matchedTokens[2].length)}return result};parser.extractConcordance=function(text,result){var conLength=30;preText=text.substr(0,result.index);preText=preText.replace(/(\r\n|\n|\r)/gm," ");preText=preText.replace(/(\s+)/gm," ");if(preText.length>conLength)preText="..."+preText.substr(preText.length-conLength+3,conLength-3);else preText=preText.substr(0,conLength);posText=text.substr(result.index+result.text.length);posText=posText.replace(/(\r\n|\n|\r)/gm," ");posText=posText.replace(/(\s+)/gm," ");if(posText.length>conLength)posText=posText.substr(0,conLength-3)+"...";else posText=posText.substr(0,conLength);result.concordance=preText+result.text+posText;return new chrono.ParseResult(result)};parser.exec=function(){if(searchingFinished)return null;var index=searchingText.search(this.pattern());if(index<0){searchingFinished=true;return null}var matchedIndex=index+searchingIndex;var result=this.extract(text,matchedIndex);if(!result){searchingText=searchingText.substr(index+1);searchingIndex=matchedIndex+1;return null}if(result.start.hour===undefined||result.end&&result.end.hour===undefined){var timedResult=this.extractTime(text,result);result=timedResult||result}if(result.start.timezoneOffset===undefined||result.end&&result.end.timezoneOffset===undefined){var resultWithTimezone=this.extractTimezone(text,result);result=resultWithTimezone||result;if(opt.timezoneOffset){if(result.start.timezoneOffset===undefined){result.start.imply("timezoneOffset",opt.timezoneOffset)}if(result.end&&result.end.timezoneOffset===undefined){result.end.imply("timezoneOffset",opt.timezoneOffset)}}}if(searchingResults.length>0){var oldResult=searchingResults[searchingResults.length-1];var overlapResult=this.mergeOverlapResult(text,oldResult,result);result=overlapResult||result}this.extractConcordance(text,result);searchingResults.push(result);searchingText=text.substr(result.index+result.text.length+1);searchingIndex=result.index+result.text.length+1;return result};parser.execAll=function(){while(!this.finished())this.exec()};return parser}chrono.Parser=Parser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function integratedParse(text,ref,opt,parserTypes){opt=opt||{};ref=ref||new Date;parserTypes=parserTypes||Object.keys(this.parsers);opt.timezoneMap=opt.timezoneMap||this.timezoneMap;var currentParserIndex=0;var parsers=[];var results=[];for(var i=0;i<parserTypes.length;i++){if(this.parsers[parserTypes[i]])parsers.push(new this.parsers[parserTypes[i]](text,ref,opt))}while(currentParserIndex<parsers.length){var currenParser=parsers[currentParserIndex];while(!currenParser.finished()){var result=currenParser.exec();if(result)insertNewResult(results,result)}currentParserIndex++}return results}function insertNewResult(results,newResult){var index=0;while(index<results.length&&results[index].index<newResult.index)index++;if(index<results.length){var overlapped_index=index;while(overlapped_index<results.length&&results[overlapped_index].index<newResult.index+newResult.text.length){if(results[overlapped_index].text.length>=newResult.text.length)return results;overlapped_index++}results.splice(index,overlapped_index-index)}if(index-1>=0){var oldResult=results[index-1];if(newResult.index<oldResult.index+oldResult.text.length){if(oldResult.text.length>=newResult.text.length)return results;else{results.splice(index-1,1);index=index-1}}}results.splice(index,0,newResult);return results}chrono.integratedParse=integratedParse})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/([0-9]{1,2})\.([0-9]{1,2})\.([0-9]{4}|[0-9]{2})(\W|$)/i;function DEAllNumericFormParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var matchedTokens=text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[4].length);var days=parseInt(matchedTokens[1]);var months=parseInt(matchedTokens[2])-1;var years=parseInt(matchedTokens[3]);if(years<100){if(years>50)years=years+1900;else years=years+2e3}var date=moment([years,months,days]);if(date.date()!=days||date.month()!=months||date.year()!=years){return null}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:date.day()}})};return parser}chrono.parsers.DEAllNumericFormParser=DEAllNumericFormParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/(\W|^)((\,|\(|\（)\s*)?((diese[rn]?|letzte[rn]?|nächste[rn]?)\s*)?(Sonntag|So|Montag|Mo|Dienstag|Di|Mittwoch|Mi|Donnerstag|Do|Freitag|Fr|Samstag|Sonnabend|Sa)(\s*(\,|\)|\）))?(\W|$)/i;var DAYS_OFFSET={sonntag:0,so:0,montag:1,mo:1,dienstag:2,di:2,mittwoch:3,mi:3,donnerstag:4,"do":4,freitag:5,fr:5,samstag:6,sonnabend:6,sa:6};var startsWith=function(string,testPrefix){return string.lastIndexOf(testPrefix,0)===0};function DayOfWeekParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var matchedTokens=text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];index=index+matchedTokens[1].length;text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[9].length-matchedTokens[1].length);var prefix=matchedTokens[5];var dayOfWeek=matchedTokens[6];if(dayOfWeek=="do")return null;dayOfWeek=dayOfWeek.toLowerCase();var offset=DAYS_OFFSET[dayOfWeek];if(offset===undefined)return null;var date=moment(ref).clone();if(prefix){prefix=prefix.toLowerCase();if(startsWith(prefix,"letzte"))date.day(offset-7);else if(startsWith(prefix,"nächste"))date.day(offset+7);else if(startsWith(prefix,"diese")){date.day(offset)}}else{var ref_offset=date.day();if(offset>ref_offset)date.day(offset);else date.day(offset+7)}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:offset,impliedComponents:["day","month","year"]}})};return parser}chrono.parsers.DEDayOfWeekParser=DayOfWeekParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var DAYS_OFFSET={sonntag:0,montag:1,dienstag:2,mittwoch:3,donnerstag:4,freitag:5,samstag:6,so:0,mo:1,di:2,mi:3,"do":4,fr:5,sa:6};var MONTHS_OFFSET={januar:0,februar:1,"märz":2,april:3,mai:4,juni:5,juli:6,august:7,september:8,oktober:9,november:10,dezember:11,jan:0,feb:1,mrz:2,apr:3,jun:5,jul:6,aug:7,sep:8,okt:9,nov:10,dez:11};var regPattern=/(\W|^)((Sonntag|Montag|Dienstag|Mittwoch|Donnerstag|Freitag|Samstag|So|Mo|Di|Mi|Do|Fr|Sa)\s*,?\s*)?(den)?\s*([0-9]{1,2})(\.)?(\s*(to|\-|\s)\s*([0-9]{1,2})(\.)?)?\s*(Januar|Februar|März|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Jan|Feb|Mrz|Apr|Mai|Jun|Jul|Aug|Sep|Okt|Nov|Dez)((\s*[0-9]{2,4})(\s*BE)?)?(\W|$)/i;function DEMonthNameLittleEndianParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return regPattern};parser.extract=function(text,index){var impliedComponents=[];var date=null;var dayOfWeek=null;text=text.substr(index);var originalText=text;var remainingText=text;var matchedTokens=text.match(regPattern);text=matchedTokens[0];text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[15].length-matchedTokens[1].length);index=index+matchedTokens[1].length;var remainingText=remainingText.substr(matchedTokens[1].length+text.length);var originalText=text;if(matchedTokens[6])text=text.replace(matchedTokens[6],"");if(matchedTokens[7])text=text.replace(matchedTokens[7],"");var years=null;if(matchedTokens[12]){years=matchedTokens[13];years=parseInt(years);if(years<100){if(remainingText.match(/\s*(:|am|pm)/i)!=null){text=text.replace(matchedTokens[12],"");originalText=originalText.replace(matchedTokens[12],"");years=null}else{if(years>20)years=null;else years=years+2e3}}else if(matchedTokens[14]){text=text.replace(matchedTokens[14],"");years=years-543}}var days=parseInt(matchedTokens[5]);var months=MONTHS_OFFSET[matchedTokens[11].toLowerCase()];if(years){date=moment([years,months,days]);if(!date)return null}else{impliedComponents.push("year");date=moment([moment(ref).year(),months,days]);if(!date)return null;var nextYear=date.clone().add("y",1);var lastYear=date.clone().add("y",-1);if(Math.abs(nextYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=nextYear}else if(Math.abs(lastYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=lastYear}}if(matchedTokens[3])dayOfWeek=DAYS_OFFSET[matchedTokens[3].toLowerCase()];if(matchedTokens[9]){var endDay=parseInt(matchedTokens[9]);var startDay=parseInt(matchedTokens[5]);var endDate=date.clone();date.date(startDay);endDate.date(endDay);if(date.format("D")!=matchedTokens[5])return null;if(endDate.format("D")!=matchedTokens[9])return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek,impliedComponents:impliedComponents},end:{day:endDate.date(),month:endDate.month(),year:endDate.year(),impliedComponents:impliedComponents}})}else{if(date.format("D")!=matchedTokens[5])return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek,impliedComponents:impliedComponents}})}};return parser}chrono.parsers.DEMonthNameLittleEndianParser=DEMonthNameLittleEndianParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function DateOnlyParser(text,ref,opt){var PATTERN=/(\W|^)(the\s*)?([0-9]{1,2})(th|rd|nd|st)(\W|$)/i;opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var matchedTokens=text.substr(index).match(PATTERN);if(text.substr(index-1).search(PATTERN)==0)return;if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[1].length-matchedTokens[5].length);index=index+matchedTokens[1].length;var day=matchedTokens[3];day=parseInt(day);var date=moment(ref);date.date(day);if(day>31||date.date()!=day){return}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),impliedComponents:["month","year"]}})};return parser}chrono.parsers.DateOnlyParser=DateOnlyParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function DateTimeAgoParser(text,ref,opt){var PATTERN=/(\W|^)(?:within\s*)?([0-9]+)\s*(minutes?|hours?|days?)\s*ago(?=(?:\W|$))/i;opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var matchedTokens=text.substr(index).match(PATTERN);if(text.substr(index-1).search(PATTERN)==0)return;if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[1].length);index=index+matchedTokens[1].length;var num=matchedTokens[2];num=parseInt(num);var date=moment(ref);if(matchedTokens[3].match(/day/)){impliedComponents=[];date.add("d",-num);return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year()}})}if(matchedTokens[3].match(/hour/)){date.add("h",-num)}else if(matchedTokens[3].match(/minute/)){date.add("m",-num)}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),hour:date.hour(),minute:date.minute(),impliedComponents:["day","month","year"]}})};return parser}chrono.parsers.DateTimeAgoParser=DateTimeAgoParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function DateTimeDeadlineParser(text,ref,opt){var PATTERN=/(\W|^)(within|in)\s*([0-9]+)\s*(minutes?|hours?|days?)\s*(?=(?:\W|$))/i;opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var matchedTokens=text.substr(index).match(PATTERN);if(text.substr(index-1).search(PATTERN)==0)return;if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[1].length);index=index+matchedTokens[1].length;var num=matchedTokens[3];num=parseInt(num);var date=moment(ref);if(matchedTokens[4].match(/day/)){impliedComponents=[];date.add("d",num);return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),impliedComponents:[]}})}if(matchedTokens[4].match(/hour/)){date.add("h",num)}else if(matchedTokens[4].match(/minute/)){date.add("m",num)}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),hour:date.hour(),minute:date.minute(),impliedComponents:["day","month","year"]}})};return parser}chrono.parsers.DateTimeDeadlineParser=DateTimeDeadlineParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/(\W|^)((\,|\(|\（)\s*)?((this|last|next)\s*)?(Sunday|Sun|Monday|Mon|Tuesday|Tues|Tue|Wednesday|Wed|Thursday|Thurs|Thur|Friday|Fri|Saturday|Sat)(\s*(\,|\)|\）))?(\W|$)/i;var DAYS_OFFSET={sunday:0,sun:0,monday:1,mon:1,tuesday:2,tues:2,tue:2,wednesday:3,wed:3,thursday:4,thurs:4,thur:4,thu:4,friday:5,fri:5,saturday:6,sat:6};function DayOfWeekParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var matchedTokens=text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];index=index+matchedTokens[1].length;text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[9].length-matchedTokens[1].length);var prefix=matchedTokens[5];var dayOfWeek=matchedTokens[6];dayOfWeek=dayOfWeek.toLowerCase();var offset=DAYS_OFFSET[dayOfWeek];if(offset===undefined)return null;var date=moment(ref).clone();if(prefix){prefix=prefix.toLowerCase();if(prefix=="last")date.day(offset-7);else if(prefix=="next")date.day(offset+7);else if(prefix=="this")date.day(offset)}else{var ref_offset=date.day();if(offset>ref_offset)date.day(offset);else date.day(offset+7)}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:offset,impliedComponents:["day","month","year"]}})};return parser}chrono.parsers.DayOfWeekParser=DayOfWeekParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/(today|tonight|tomorrow|yesterday|last\s*night|([0-9]+)\s*day(s)\s*ago|([0-9]{1,2})(\.|\:|\：)([0-9]{2})|([0-9]{1,2}\s*\W?\s*)?([0-9]{1,2})\s*(AM|PM)|at\s*([0-9]{1,2}|noon|midnight)|(noon|midnight))(\W|$)/i;function GeneralDateParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(full_text,index){var matchedTokens=full_text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var impliedComponents=null;var text=matchedTokens[0].toLowerCase();text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[12].length);var ref_moment=moment(ref);if(opt.timezoneOffset!==undefined)ref_moment=ref_moment.zone(opt.timezoneOffset);var date=null;var lowercase_text=text.toLowerCase();if(lowercase_text=="today"||lowercase_text=="tonight"){date=ref_moment.clone()}else if(lowercase_text=="tomorrow"){if(ref_moment.hour()<4)date=ref_moment.clone().hour(6);else date=ref_moment.clone().add("d",1)}else if(lowercase_text=="yesterday")date=ref_moment.clone().add("d",-1);else if(lowercase_text.match("last"))date=ref_moment.clone().add("d",-1);else if(lowercase_text.match("ago")){var days_ago=matchedTokens[2];days_ago=parseInt(days_ago);date=ref_moment.clone().add("d",-days_ago)}else{if(full_text.charAt(index-1).match(/\d/))return null;if(full_text.match(/\d+(\.\d+)%/))return null;while(full_text.charAt(index)==" ")index++;impliedComponents=["year","month","day"];date=ref_moment.clone();text=""}var result=new chrono.ParseResult({referenceDate:ref_moment.toDate(),text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year(),impliedComponents:impliedComponents}});var resultWithTime=parser.extractTime(full_text,result);result=resultWithTime||result;if(result.text.replace(/\s/g,"").length==0)return null;if(lowercase_text.match("night")){if(!resultWithTime){result.start.day=date.date()+1;result.start.hour=0;result.start.minute=0;result.start.second=0;result.start.impliedComponents=["hour","minute","second"];result=new chrono.ParseResult(result)}else if(resultWithTime.start.hour<6){date.add("d",1);result.start.day=date.date();result.start.month=date.month();result.start.year=date.year();result=new chrono.ParseResult(result)}else if(resultWithTime.start.hour<12&&!resultWithTime.start.meridiem){result.start.hour=resultWithTime.start.hour+12;result.start.meridiem="pm";result.start.impliedComponents=result.start.impliedComponents||[];result.start.impliedComponents.push("meridiem");result=new chrono.ParseResult(result)}}return result};return parser}chrono.parsers.GeneralDateParser=GeneralDateParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/([0-9]{4})\-([0-9]{1,2})\-([0-9]{1,2})(T([0-9]{1,2}):([0-9]{1,2})(?::([0-9]{1,2})(?:\.\d+)?)?(Z|([+-]\d+):(\d+)))?(?=\W|$)/i;function InternationalStandardParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var matchedTokens=text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0];if(matchedTokens[4])text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[4].length);var date=moment(text,"YYYY-MM-DD");if(date.format("YYYY-M-D")!=text&&date.format("YYYY-MM-DD")!=text){return null}var result=new chrono.ParseResult({referenceDate:ref,text:matchedTokens[0],index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:date.day()}});if(matchedTokens[5]){result.start.assign("hour",parseInt(matchedTokens[5]));result.start.assign("minute",parseInt(matchedTokens[6]));if(matchedTokens[8].toLowerCase()=="z"){result.start.assign("timezoneOffset",0)}else{var hourOffset=parseInt(matchedTokens[9].toLowerCase());var minuteOffset=parseInt(matchedTokens[10].toLowerCase());var timezoneOffset=-hourOffset*60;if(timezoneOffset<0)timezoneOffset-=minuteOffset;else timezoneOffset+=minuteOffset;result.start.assign("timezoneOffset",timezoneOffset)}}if(matchedTokens[7]){result.start.assign("second",parseInt(matchedTokens[7]))}return result};return parser}chrono.parsers.InternationalStandardParser=InternationalStandardParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var DAYS_OFFSET={sunday:0,sun:0,monday:1,mon:1,tuesday:2,tue:2,wednesday:3,wed:3,thursday:4,thur:4,thu:4,friday:5,fri:5,saturday:6,sat:6};var regPattern=/(\W|^)((Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sun|Mon|Tue|Wed|Thu|Fri|Sat)\s*,?\s*)?([0-9]{1,2})(st|nd|rd|th)?(\s*(to|\-|\s)\s*([0-9]{1,2})(st|nd|rd|th)?)?\s*(?:of)?\s*(January|Jan|February|Feb|March|Mar|April|Apr|May|June|Jun|July|Jul|August|Aug|September|Sep|October|Oct|November|Nov|December|Dec)((\s*[0-9]{2,4})(\s*BE)?)?(\W|$)/i;function MonthNameLittleEndianParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return regPattern};parser.extract=function(text,index){var impliedComponents=[];var date=null;var dayOfWeek=null;text=text.substr(index);var originalText=text;var remainingText=text;var matchedTokens=text.match(regPattern);text=matchedTokens[0];text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[14].length-matchedTokens[1].length);index=index+matchedTokens[1].length;var remainingText=remainingText.substr(matchedTokens[1].length+text.length);var originalText=text;if(matchedTokens[5])text=text.replace(matchedTokens[5],"");if(matchedTokens[6])text=text.replace(matchedTokens[6],"");var years=null;if(matchedTokens[11]){years=matchedTokens[12];years=parseInt(years);if(years<100){if(remainingText.match(/\s*(:|am|pm)/i)!=null){text=text.replace(matchedTokens[11],"");originalText=originalText.replace(matchedTokens[11],"");years=null}else{if(years>20)years=null;else years=years+2e3}}else if(matchedTokens[13]){text=text.replace(matchedTokens[13],"");years=years-543}}if(years){text=matchedTokens[4]+" "+matchedTokens[10]+" "+years;date=moment(text,"DD MMMM YYYY");if(!date)return null}else{text=matchedTokens[4]+" "+matchedTokens[10];date=moment(text,"DD MMMM");if(!date)return null;impliedComponents.push("year");date.year(moment(ref).year());var nextYear=date.clone().add("y",1);var lastYear=date.clone().add("y",-1);if(Math.abs(nextYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=nextYear}else if(Math.abs(lastYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=lastYear}}if(matchedTokens[3])dayOfWeek=DAYS_OFFSET[matchedTokens[3].toLowerCase()];if(matchedTokens[8]){var endDay=parseInt(matchedTokens[8]);var startDay=parseInt(matchedTokens[4]);var endDate=date.clone();date.date(startDay);endDate.date(endDay);if(date.format("D")!=matchedTokens[4])return null;if(endDate.format("D")!=matchedTokens[8])return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek,impliedComponents:impliedComponents},end:{day:endDate.date(),month:endDate.month(),year:endDate.year(),impliedComponents:impliedComponents}})}else{if(date.format("D")!=matchedTokens[4])return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek,impliedComponents:impliedComponents}})}};var baseExtractTime=parser.extractTime;parser.extractTime=function(text,result){var DAY_OF_WEEK_SUFFIX_PATTERN=/(\,|\(|\s)*(Sun|Sunday|Mon|Monday|Tue|Tuesday|Wed|Wednesday|Thur|Thursday|Fri|Friday|Sat|Saturday)(\,|\)|\s)*/i;if(text.length<=result.index+result.text.length)return null;var suffix_text=text.substr(result.index+result.text.length);var matchedTokens=suffix_text.match(DAY_OF_WEEK_SUFFIX_PATTERN);if(matchedTokens&&suffix_text.indexOf(matchedTokens[0])==0){result.text=result.text+matchedTokens[0]}return baseExtractTime.call(this,text,result)};return parser}chrono.parsers.MonthNameLittleEndianParser=MonthNameLittleEndianParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var DAYS_OFFSET={sunday:0,sun:0,monday:1,mon:1,tuesday:2,tue:2,wednesday:3,wed:3,thursday:4,thur:4,thu:4,friday:5,fri:5,saturday:6,sat:6};var regFullPattern=/(\W|^)((Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sun|Mon|Tue|Wed|Thu|Fri|Sat)\s*,?\s*)?(Jan|January|Feb|February|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|September|Oct|October|Nov|November|Dec|December)\s*(([0-9]{1,2})(st|nd|rd|th)?\s*(to|\-)\s*)?([0-9]{1,2})(st|nd|rd|th)?(,)?(\s*[0-9]{4})(\s*BE)?(\W|$)/i;var regShortPattern=/(\W|^)((Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sun|Mon|Tue|Wed|Thu|Fri|Sat)\s*,?\s*)?(Jan|January|Feb|February|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|September|Oct|October|Nov|November|Dec|December)\s*(([0-9]{1,2})(st|nd|rd|th)?\s*(to|\-)\s*)?([0-9]{1,2})(st|nd|rd|th)?([^0-9]|$)/i;function MonthNameMiddleEndianParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return regShortPattern};parser.extract=function(text,index){var impliedComponents=[];var date=null;var dayOfWeek=null;var originalText="";text=text.substr(index);var matchedTokens=text.match(regFullPattern);if(matchedTokens&&text.indexOf(matchedTokens[0])==0){var text=matchedTokens[0];text=text.substring(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[14].length);index=index+matchedTokens[1].length;originalText=text;text=text.replace(matchedTokens[2],"");text=text.replace(matchedTokens[4],matchedTokens[4]+" ");if(matchedTokens[5])text=text.replace(matchedTokens[5],"");
if(matchedTokens[10])text=text.replace(matchedTokens[10],"");if(matchedTokens[11])text=text.replace(","," ");if(matchedTokens[13]){var years=matchedTokens[12];years=" "+(parseInt(years)-543);text=text.replace(matchedTokens[13],"");text=text.replace(matchedTokens[12],years)}text=text.replace(matchedTokens[9],parseInt(matchedTokens[9])+"");date=moment(text,"MMMM DD YYYY");if(!date)return null}else{matchedTokens=text.match(regShortPattern);if(!matchedTokens)return null;var text=matchedTokens[0];text=text.substring(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[11].length);index=index+matchedTokens[1].length;originalText=text;text=text.replace(matchedTokens[2],"");text=text.replace(matchedTokens[4],matchedTokens[4]+" ");if(matchedTokens[4])text=text.replace(matchedTokens[5],"");date=moment(text,"MMMM DD");if(!date)return null;impliedComponents.push("year");date.year(moment(ref).year());var nextYear=date.clone().add("y",1);var lastYear=date.clone().add("y",-1);if(Math.abs(nextYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=nextYear}else if(Math.abs(lastYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=lastYear}}if(matchedTokens[3])dayOfWeek=DAYS_OFFSET[matchedTokens[3].toLowerCase()];if(matchedTokens[5]){var endDay=parseInt(matchedTokens[9]);var startDay=parseInt(matchedTokens[6]);var endDate=date.clone();date.date(startDay);endDate.date(endDay);if(date.format("D")!=matchedTokens[6])return null;if(endDate.format("D")!=matchedTokens[9])return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek,impliedComponents:impliedComponents},end:{day:endDate.date(),month:endDate.month(),year:endDate.year(),impliedComponents:impliedComponents}})}else{if(date.format("D")!=parseInt(matchedTokens[9])+"")return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek,impliedComponents:impliedComponents}})}};var baseExtractTime=parser.extractTime;parser.extractTime=function(text,result){var DAY_OF_WEEK_SUFFIX_PATTERN=/(\,|\(|\s)*(Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sun|Mon|Tue|Wed|Thu|Fri|Sat)(\,|\)|\s)*/i;if(text.length<=result.index+result.text.length)return null;var suffix_text=text.substr(result.index+result.text.length,15);var matchedTokens=suffix_text.match(DAY_OF_WEEK_SUFFIX_PATTERN);if(matchedTokens&&suffix_text.indexOf(matchedTokens[0])==0){result.text=result.text+matchedTokens[0];var dayOfWeek=DAYS_OFFSET[matchedTokens[2].toLowerCase()];result.start.dayOfWeek=dayOfWeek}if(!result.start.impliedComponents||result.start.impliedComponents.indexOf("year")<0)return baseExtractTime.call(this,text,result);var YEAR_SUFFIX_PATTERN=/(\s*[0-9]{4})(\s*BE)?/i;if(text.length<=result.index+result.text.length)return null;var suffix_text=text.substr(result.index+result.text.length,15);var matchedTokens=suffix_text.match(YEAR_SUFFIX_PATTERN);if(matchedTokens&&suffix_text.indexOf(matchedTokens[0])==0){var years=matchedTokens[1];years=parseInt(years);if(years<100){if(years>20)years=null;else years=years+2e3}else if(matchedTokens[2]){years=years-543}var index=result.start.impliedComponents.indexOf("year");result.start.impliedComponents.splice(index,1);result.start.year=years;result.text=result.text+matchedTokens[0]}return baseExtractTime.call(this,text,result)};return parser}chrono.parsers.MonthNameMiddleEndianParser=MonthNameMiddleEndianParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var DAYS_OFFSET={sunday:0,sun:0,monday:1,mon:1,tuesday:2,wednesday:3,wed:3,thursday:4,thur:4,friday:5,fri:5,saturday:6,sat:6};var PATTERN=/(\W|^)(Sun|Sunday|Mon|Monday|Tue|Tuesday|Wed|Wednesday|Thur|Thursday|Fri|Friday|Sat|Saturday)?\s*\,?\s*([0-9]{1,2})[\/\.]([0-9]{1,2})([\/\.]([0-9]{4}|[0-9]{2}))?(\W|$)/i;function SlashParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var matchedTokens=text.substr(index).match(PATTERN);if(matchedTokens==null)return;if(matchedTokens[1]=="/"||matchedTokens[7]=="/")return;var text=matchedTokens[0].substr(matchedTokens[1].length,matchedTokens[0].length-matchedTokens[7].length);var orginalText=text;if(text.match(/^\d.\d$/))return;index+=matchedTokens[1].length;if(!matchedTokens[6]&&matchedTokens[0].indexOf("/")<0)return;var date=null;var years=matchedTokens[6]||moment(ref).year()+"";var month=matchedTokens[3];var day=matchedTokens[4];var dayOfWeek=null;if(matchedTokens[2])dayOfWeek=DAYS_OFFSET[matchedTokens[2].toLowerCase()];month=parseInt(month);day=parseInt(day);years=parseInt(years);if(month<1||month>12)return null;if(day<1||day>31)return null;if(years<100){if(years>50){years=years+2500-543}else{years=years+2e3}}text=month+"/"+day+"/"+years;date=moment(text,"M/D/YYYY");if(!date||date.date()!=day){date=moment(text,"D/M/YYYY");if(!date||date.date()!=month)return null}return new chrono.ParseResult({referenceDate:ref,text:orginalText,index:index,start:{day:date.date(),month:date.month(),year:date.year(),dayOfWeek:dayOfWeek}})};return parser}chrono.parsers.SlashParser=SlashParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/(วัน)?(อาทิตย์|จันทร์|อังคาร|พุธ|พฤหัสบดี|ศุกร์|เสาร์)(หน้า|นี้|ที่แล้ว|.|$)/i;var DAYS_OFFSET={"อาทิตย์":0,"จันทร์":1,"อังคาร":2,"พุธ":3,"พฤหัสบดี":4,"ศุกร์":5,"เสาร์":6};function THDayOfWeekParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.parsers.THGeneralDateParser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var matchedTokens=text.substr(index).match(PATTERN);if(matchedTokens==null)return;var text=matchedTokens[0];var dayOfWeek=matchedTokens[2];dayOfWeek=dayOfWeek.toLowerCase();var offset=DAYS_OFFSET[dayOfWeek];if(offset===undefined)return null;var date=moment(ref).clone();var suffix=matchedTokens[3];if(suffix=="นี้"){date.day(offset)}else if(suffix=="หน้า"){date.day(offset+7)}else if(suffix=="ที่แล้ว"){date.day(offset-7)}else{date.day(offset);text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[3].length)}return new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year()}})};return parser}chrono.parsers.THDayOfWeekParser=THDayOfWeekParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/(วันนี้|พรุ่งนี้|เมื่อวาน|เมื่อคืน|([1-9]+)\s*(วัน|คืน)(ก่อน|ที่แล้ว))(\W|$)/i;function THGeneralDateParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(full_text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var matchedTokens=full_text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0].toLowerCase();text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[5].length);var date=null;if(text=="วันนี้")date=moment(ref).clone();else if(text=="พรุ่งนี้")date=moment(ref).clone().add("d",1);else if(text=="เมื่อวาน")date=moment(ref).clone().add("d",-1);else if(text=="เมื่อคืน")date=moment(ref).clone().add("d",-1);else{var days_ago=matchedTokens[2];days_ago=parseInt(days_ago);date=moment(ref).clone().add("d",-days_ago)}var result=new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year()}});var resultWithTime=parser.extractTime(full_text,result);result=resultWithTime||result;if(text.match("คืน")){if(!resultWithTime){result.start.day=date.date()+1;result.start.hour=0;result.start.minute=0;result.start.second=0;result=new chrono.ParseResult(result)}else if(resultWithTime.start.hour<12){date.add("d",1);result.start.day=date.date();result.start.month=date.month();result.start.year=date.year();result=new chrono.ParseResult(result)}}return result};return parser}chrono.parsers.THGeneralDateParser=THGeneralDateParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var regFullPattern=/([0-9]{1,2})(\s*(ถึง|\-)?\s*([0-9]{1,2}))?\s+(มกราคม|ม.ค.|กุมภาพัน|ก.พ.|มีนาคม|มี.ค.|เมษายน|เม.ย.|พฤษภาคม|พ.ค.|มิถุนายน|ม.ย.|มิ.ย.|กรกฎาคม|ก.ค.|สิงหาคม|ส.ค.|กันยายน|ก.ย.|ตุลาคม|ต.ค.|พฤศจิกายน|พ.ย.|ธันวาคม|ธ.ค.)(พ.ศ.|ค.ศ.)?(\s+[0-9]{2,4})(\W|$)/i;var regShortPattern=/([0-9]{1,2})(\s*(ถึง|\-)?\s*([0-9]{1,2}))?\s+(มกราคม|ม.ค.|กุมภาพัน|ก.พ.|มีนาคม|มี.ค.|เมษายน|เม.ย.|พฤษภาคม|พ.ค.|มิถุนายน|ม.ย.|มิ.ย.|กรกฏาคม|ก.ค.|สิงหาคม|ส.ค.|กันยายน|ก.ย.|ตุลาคม|ต.ค.|พฤศจิกายน|พ.ย.|ธันวาคม|ธ.ค.)(\W|$)/i;var momthTranslation={"มกราคม":0,"ม.ค.":0,"กุมภาพัน":1,"ก.พ.":1,"มีนาคม":2,"มี.ค.":2,"เมษายน":3,"เม.ย.":4,"พฤษภาคม":4,"พ.ค.":4,"มิถุนายน":5,"มิ.ย.":5,"กรกฎาคม":6,"ก.ค.":6,"สิงหาคม":7,"ส.ค.":7,"กันยายน":8,"ก.ย.":8,"ตุลาคม":9,"ต.ค.":9,"พฤศจิกายน":10,"พ.ย.":10,"ธันวาคม":11,"ธ.ค.":11};function THMonthNameLittleEndianParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.parsers.THGeneralDateParser(text,ref,opt);parser.pattern=function(){return regShortPattern};parser.extract=function(text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var date=null;text=text.substr(index);originalText=text;var matchedTokens=text.match(regFullPattern);if(matchedTokens&&text.indexOf(matchedTokens[0])==0){text=matchedTokens[0];text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[8].length);originalText=text;var years=matchedTokens[7];years=parseInt(years);if(matchedTokens[3]&&matchedTokens[3]=="ค.ศ."){if(years<=30)years=years+2e3;else if(years<100)years=years+1900}else{if(years<543)years=years+2500;years=years-543}var months=momthTranslation[matchedTokens[5]];if(typeof months!="number")return null;var days=matchedTokens[1];days=parseInt(days);var formatedText=years+"-"+(months+1)+"-"+days;var date=moment(formatedText,"YYYY-MM-DD");if(date.format("YYYY-M-D")!=formatedText){return null}}else{matchedTokens=text.match(regShortPattern);if(!matchedTokens)return null;var text=matchedTokens[0];text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[6].length);originalText=text;var months=momthTranslation[matchedTokens[5]];if(typeof months!="number")return null;var days=matchedTokens[1];days=parseInt(days);var formatedText=months+1+"-"+days;var date=moment(formatedText,"MM-DD");if(date.format("M-D")!=formatedText){return null}date.year(moment(ref).year());var nextYear=date.clone().add("y",1);var lastYear=date.clone().add("y",-1);if(Math.abs(nextYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=nextYear}else if(Math.abs(lastYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=lastYear}}if(matchedTokens[4]){var endDay=parseInt(matchedTokens[4]);var startDay=parseInt(matchedTokens[1]);var endDate=date.clone();date.date(startDay);endDate.date(endDay);if(date.format("D")!=matchedTokens[1])return null;if(endDate.format("D")!=matchedTokens[4])return null;return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year()},end:{day:endDate.date(),month:endDate.month(),year:endDate.year()}})}return new chrono.ParseResult({referenceDate:ref,text:originalText,index:index,start:{day:date.date(),month:date.month(),year:date.year()}})};return parser}chrono.parsers.THMonthNameLittleEndianParser=THMonthNameLittleEndianParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/(今日|昨日|明日|([1-9]+)\s*日前)(\W|$)/i;function JPGeneralDateParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.Parser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(full_text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var matchedTokens=full_text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0].toLowerCase();text=matchedTokens[0].substr(0,matchedTokens[0].length-matchedTokens[3].length);var date=null;if(text=="今日")date=moment(ref).clone();else if(text=="明日")date=moment(ref).clone().add("d",1);else if(text=="昨日")date=moment(ref).clone().add("d",-1);else{var days_ago=matchedTokens[2];days_ago=parseInt(days_ago);date=moment(ref).clone().add("d",-days_ago)}var result=new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year()}});var resultWithTime=parser.extractTime(full_text,result);result=resultWithTime||result;return result};var baseExtractTime=parser.extractTime;parser.extractTime=function(text,result){var baseResult=baseExtractTime.call(this,text,result);if(baseResult)return baseResult;var SUFFIX_PATTERN=/\s*(午前|午後)?\s*([0-9]{1,2})時?(([0-9]{1,2})分)?/i;if(text.length<=result.index+result.text.length)return null;text=text.substr(result.index+result.text.length);var matchedTokens=text.match(SUFFIX_PATTERN);if(!matchedTokens||text.indexOf(matchedTokens[0])!=0)return null;var minute=0;var second=0;var hour=matchedTokens[2];hour=parseInt(hour);if(matchedTokens[1]){if(hour>12)return null;if(matchedTokens[1]=="午後"){hour+=12}}if(matchedTokens[4]){minute=matchedTokens[4];minute=parseInt(minute);if(minute>=60)return null}result.text=result.text+matchedTokens[0];if(result.start.hour==undefined){result.start.hour=hour;result.start.minute=minute;result.start.second=second}if(result.end&&result.end.hour==undefined){result.end.hour=hour;result.end.minute=minute;result.end.second=second}return new chrono.ParseResult(result)};return parser}chrono.parsers.JPGeneralDateParser=JPGeneralDateParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";var PATTERN=/((同|((平成)?([0-9０-９]{2,4})))年\s*)?([0-9０-９]{1,2})月\s*([0-9０-９]{1,2})日/i;function cleanZengakuNumber(str){var cleanStr=str;cleanStr=cleanStr.replace(/０/g,"0");cleanStr=cleanStr.replace(/１/g,"1");cleanStr=cleanStr.replace(/２/g,"2");cleanStr=cleanStr.replace(/３/g,"3");cleanStr=cleanStr.replace(/４/g,"4");cleanStr=cleanStr.replace(/５/g,"5");cleanStr=cleanStr.replace(/６/g,"6");cleanStr=cleanStr.replace(/７/g,"7");cleanStr=cleanStr.replace(/８/g,"8");cleanStr=cleanStr.replace(/９/g,"9");return cleanStr}function JPStandardDateParser(text,ref,opt){opt=opt||{};ref=ref||new Date;var parser=chrono.parsers.JPGeneralDateParser(text,ref,opt);parser.pattern=function(){return PATTERN};parser.extract=function(full_text,index){var results=this.results();var lastResult=results[results.length-1];if(lastResult){if(index<lastResult.index+lastResult.text.length)return null}var matchedTokens=full_text.substr(index).match(PATTERN);if(matchedTokens==null){finished=true;return}var text=matchedTokens[0].toLowerCase();var date=null;text=matchedTokens[0];var months=matchedTokens[6];months=cleanZengakuNumber(months);months=parseInt(months);if(!months||months==NaN)return null;var days=matchedTokens[7];days=cleanZengakuNumber(days);days=parseInt(days);if(!days||days==NaN)return null;var years=matchedTokens[5];if(years){years=cleanZengakuNumber(years);years=parseInt(years)}if(years&&years!==NaN){if(matchedTokens[4]=="平成"){years=years+1989}else if(years<100){years=years+2e3}var dateText=years+"-"+months+"-"+days;date=moment(dateText,"YYYY-MM-DD");if(date.format("YYYY-M-D")!=dateText)return null}else{var dateText=months+"-"+days;date=moment(dateText,"MM-DD");date.year(moment(ref).year());var nextYear=date.clone().add("y",1);var lastYear=date.clone().add("y",-1);if(Math.abs(nextYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=nextYear}else if(Math.abs(lastYear.diff(moment(ref)))<Math.abs(date.diff(moment(ref)))){date=lastYear}}var result=new chrono.ParseResult({referenceDate:ref,text:text,index:index,start:{day:date.date(),month:date.month(),year:date.year()}});var resultWithTime=parser.extractTime(full_text,result);result=resultWithTime||result;return result};var baseExtractTime=parser.extractTime;parser.extractTime=function(text,result){var DAY_OF_WEEK_SUFFIX_PATTERN=/(\,|\(|（|\s)*(月|火|水|木|金|土|日)(曜日|曜)?\s*(\,|）|\))/i;if(text.length<=result.index+result.text.length)return null;var suffix_text=text.substr(result.index+result.text.length);var matchedTokens=suffix_text.match(DAY_OF_WEEK_SUFFIX_PATTERN);if(matchedTokens&&suffix_text.indexOf(matchedTokens[0])==0){result.text=result.text+matchedTokens[0]}return baseExtractTime.call(this,text,result)};return parser}chrono.parsers.JPStandardDateParser=JPStandardDateParser})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function integratedRefine(text,results,opt){var orderedRefiners={};for(var name in this.refiners){var refiner=this.refiners[name];var order=refiner.order||0;orderedRefiners[order]=orderedRefiners[order]||[];orderedRefiners[order].push(refiner)}for(var order in orderedRefiners){orderedRefiners[order].forEach(function(refiner){results=refiner.refine(text,results,opt)})}return results}chrono.integratedRefine=integratedRefine})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function MergeComponentsRefine(text,results,opt){if(results.length<2)return results;var new_results=[];for(var i=0;i<results.length-1;i++){var refResult=results[i+1];var result=results[i];var textBetween=text.substring(result.index+result.text.length,refResult.index);var OVERLAP_PATTERN=/^\s*(of|on|\W)?\s*$/i;if(!textBetween.match(OVERLAP_PATTERN)){new_results.push(result);continue}if(result.start.hour===undefined){if(refResult.start.hour===undefined){new_results.push(result);continue}var dateComponents=new Object(result.start);var timeComponents=new Object(refResult.start)}else{if(refResult.start.hour!==undefined){new_results.push(result);continue}var timeComponents=new Object(result.start);var dateComponents=new Object(refResult.start)}dateComponents.hour=timeComponents.hour;dateComponents.minute=timeComponents.minute;dateComponents.second=timeComponents.second;dateComponents.meridiem=timeComponents.meridiem;dateComponents.impliedComponents=dateComponents.impliedComponents||[];result.start=new chrono.DateComponents(dateComponents);if(result.end||refResult.end){if(result.start.hour!==undefined){timeComponents=result.end||timeComponents;dateComponents=refResult.end||dateComponents}else{dateComponents=result.end||dateComponents;timeComponents=refResult.end||timeComponents}dateComponents.hour=timeComponents.hour;dateComponents.minute=timeComponents.minute;dateComponents.second=timeComponents.second;dateComponents.impliedComponents=dateComponents.impliedComponents||[];result.end=new chrono.DateComponents(dateComponents)}result.text=result.text+textBetween+refResult.text;new_results.push(new chrono.ParseResult(result));i++}if(i<results.length)new_results.push(results[i]);return new_results}chrono.refiners.MergeComponentsRefine={refine:MergeComponentsRefine}})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function MissingComponentsRefine(text,results,opt){if(results.length<2)return results;for(var i=0;i<results.length;i++){var refResult=null;var result=results[i];if(!results[i+1])refResult=results[i-1];else if(!results[i-1])refResult=results[i+1];else{var nextResult=results[i+1];var distanceNextResult=nextResult.index-(result.index+result.text.length);var prevResult=results[i-1];var distancePrevResult=result.index-(prevResult.index+prevResult.text.length);if(distancePrevResult>distanceNextResult)refResult=nextResult;else refResult=prevResult}var impliedComponents=result.start.impliedComponents||[];var refImpliedComponents=refResult.start.impliedComponents||[];if(result.start.hour===undefined)impliedComponents.push("hour");if(result.start.minute===undefined)impliedComponents.push("minute");impliedComponents.forEach(function(component){if(refResult.start.isCertain(component)){result.start.imply(component,refResult.start[component])}});result.startDate=result.start.date();if(!result.start.isCertain("day")&&!result.start.isCertain("month")&&result.start.isCertain("dayOfWeek")){var date=moment(result.start.date());date.day(result.start.dayOfWeek);result.start.day=date.date();result.start.month=date.month()}if(result.start.dayOfWeek===undefined||impliedComponents.indexOf("dayOfWeek")>=0){var date=moment(result.start.date());result.start.imply("dayOfWeek",date.day())}result.startDate=result.start.date()}return results}chrono.refiners.MissingComponentsRefiner={refine:MissingComponentsRefine,order:500}})();(function(){if(typeof chrono=="undefined")throw"Cannot find the chrono main module";function RemoveReplicateRefine(text,results,opt){var improved_results=[];var PREFIX_TYPO_PATTERN=/(\W)\s*$/;var SUFFIX_TYPO_PATTERN=/^\s*(\W)/;for(var i=0;i<results.length;i++){appendResults(improved_results,results[i])}return improved_results}function appendResults(results,newResult){var index=0;while(index<results.length&&results[index].index<newResult.index)index++;if(index<results.length){var overlapped_index=index;while(overlapped_index<results.length&&results[overlapped_index].index<newResult.index+newResult.text.length){if(results[overlapped_index].text.length>=newResult.text.length)return results;overlapped_index++}results.splice(index,overlapped_index-index)}if(index-1>=0){var oldResult=results[index-1];if(newResult.index<oldResult.index+oldResult.text.length){if(oldResult.text.length>=newResult.text.length)return results;else{results.splice(index-1,1);index=index-1}}}results.splice(index,0,newResult);return results}chrono.refiners.RemoveReplicateRefiner={refine:RemoveReplicateRefine,order:1e3}})()})();