/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.tree;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import java.util.Stack;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.storynode.pigeon.option.Option;

public class BTree<T extends Comparable<T>>
implements Iterable<T> {
    private final int minDegree;
    private final transient Class<T> marker;
    private Node<T> root;

    public BTree(Class<T> clazz, int minDegree) {
        this.minDegree = minDegree;
        this.marker = clazz;
        this.root = null;
    }

    public void insert(T key) {
        if (this.root == null) {
            this.root = this.spawn(true);
            this.root.keys[0] = key;
            this.root.numKeys = 1;
        } else if (this.root.numKeys == 2 * this.minDegree - 1) {
            Node<T> newNode = this.spawn(false);
            newNode.children[0] = this.root;
            newNode.splitChild(0, this.root);
            int i = 0;
            if (newNode.keys[0].compareTo(key) < 0) {
                ++i;
            }
            newNode.children[i].insertNonFull(key);
            this.root = newNode;
        } else {
            this.root.insertNonFull(key);
        }
    }

    public Option<Node<T>> get(T key) {
        return Option.of(this.search(this.root, key));
    }

    @Nullable
    private Node<T> search(Node<T> node, T key) {
        int i;
        for (i = 0; i < node.numKeys && key.compareTo(node.keys[i]) > 0; ++i) {
        }
        if (i < node.numKeys && node.keys[i].equals(key)) {
            return node;
        }
        if (node.isLeaf()) {
            return null;
        }
        return this.search(node.children[i], key);
    }

    public String toString() {
        if (this.root != null) {
            return this.root.toString().trim();
        }
        return "{}";
    }

    protected Node<T> spawn(boolean isLeaf) {
        return new Node(this, isLeaf);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this.root);
    }

    public static class Node<T extends Comparable<T>> {
        private int numKeys;
        private final BTree<T> treeRef;
        private final T[] keys;
        private final Node<T>[] children;
        private final boolean isLeaf;

        @Contract(pure=true)
        protected Node(@NotNull BTree<T> parent, boolean isLeaf) {
            if (parent == null) {
                Node.$$$reportNull$$$0(0);
            }
            this.treeRef = parent;
            this.keys = (Comparable[])Array.newInstance(this.treeRef.marker, 2 * this.treeRef.minDegree - 1);
            this.children = new Node[2 * parent.minDegree];
            this.numKeys = 0;
            this.isLeaf = isLeaf;
        }

        public BTree<T> tree() {
            return this.treeRef;
        }

        private void splitChild(int i, Node<T> child) {
            int j;
            Node<T> newNode = new Node<T>(this.tree(), child.isLeaf());
            int minDegree = this.tree().minDegree;
            newNode.numKeys = minDegree - 1;
            if (minDegree - 1 >= 0) {
                System.arraycopy(child.keys, minDegree, newNode.keys, 0, minDegree - 1);
            }
            if (!child.isLeaf() && minDegree >= 0) {
                System.arraycopy(child.children, minDegree, newNode.children, 0, minDegree);
            }
            child.numKeys = minDegree - 1;
            for (j = this.numKeys; j >= i + 1; --j) {
                this.children[j + 1] = this.children[j];
            }
            this.children[i + 1] = newNode;
            for (j = this.numKeys - 1; j >= i; --j) {
                this.keys[j + 1] = this.keys[j];
            }
            this.keys[i] = child.keys[minDegree - 1];
            ++this.numKeys;
        }

        private void insertNonFull(T key) {
            if (this.isLeaf()) {
                for (i = this.numKeys - 1; i >= 0 && this.keys[i].compareTo(key) > 0; --i) {
                    this.keys[i + 1] = this.keys[i];
                }
                this.keys[i + 1] = key;
                ++this.numKeys;
            } else {
                while (i >= 0 && this.keys[i].compareTo(key) > 0) {
                    --i;
                }
                if (this.children[++i].numKeys == 2 * this.tree().minDegree - 1) {
                    this.splitChild(i, this.children[i]);
                    if (this.keys[i].compareTo(key) < 0) {
                        ++i;
                    }
                }
                this.children[i].insertNonFull(key);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(keys: [");
            for (int i = 0; i < this.numKeys; ++i) {
                sb.append(this.keys[i]);
                if (i >= this.numKeys - 1) continue;
                sb.append(", ");
            }
            sb.append("], ");
            sb.append("left: ");
            if (this.children[0] != null) {
                sb.append(this.children[0]);
            } else {
                sb.append("null");
            }
            sb.append(", right: ");
            if (this.children[1] != null) {
                sb.append(this.children[1]);
            } else {
                sb.append("null");
            }
            sb.append(")");
            return sb.toString();
        }

        @Generated
        public boolean isLeaf() {
            return this.isLeaf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/storynode/pigeon/tree/BTree$Node", "<init>"));
        }
    }

    public static class Iterator<T extends Comparable<T>>
    implements java.util.Iterator<T> {
        private final Stack<Node<T>> nodeStack = new Stack();
        private final Stack<Integer> indexStack = new Stack();

        public Iterator(Node<T> root) {
            this.pushLeft(root);
        }

        private void pushLeft(Node<T> node) {
            while (node != null) {
                this.nodeStack.push(node);
                this.indexStack.push(0);
                if (node.isLeaf()) break;
                node = node.children[0];
            }
        }

        @Override
        public boolean hasNext() {
            return !this.nodeStack.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in B-Tree");
            }
            Node<T> node = this.nodeStack.peek();
            int index = this.indexStack.pop();
            Object result = node.keys[index];
            if (index + 1 < node.numKeys) {
                this.indexStack.push(index + 1);
            } else {
                this.nodeStack.pop();
            }
            if (!node.isLeaf()) {
                this.pushLeft(node.children[index + 1]);
            }
            return result;
        }
    }
}

