/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.result;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.error.UnwrapException;
import org.storynode.pigeon.protocol.ThrowingSupplier;
import org.storynode.pigeon.protocol.Wrapped;
import org.storynode.pigeon.result.Err;
import org.storynode.pigeon.result.Ok;
import org.storynode.pigeon.tuple.Pair;

public abstract class Result<T, E>
implements Wrapped<T> {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T, E> Result<T, E> ok(@NotNull T inner) {
        return new Ok(Objects.requireNonNull(inner));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T, E> Result<T, E> err(@NotNull E error) {
        return new Err(Objects.requireNonNull(error));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T, E> Result<T, E> error(@NotNull E error) {
        return Result.err(error);
    }

    @NotNull
    public static <T, E extends Throwable> Result<T, E> of(ThrowingSupplier<T> fn) {
        try {
            return Result.ok(fn.getWithException());
        }
        catch (Throwable throwable) {
            return Result.error(throwable);
        }
    }

    public abstract boolean isOk();

    @Override
    public abstract T unwrap() throws UnwrapException;

    public abstract E unwrapError();

    public abstract T orElseGet(Supplier<T> var1);

    public abstract <U> Result<U, E> map(@NotNull Function<? super T, ? extends U> var1);

    public abstract <U> Result<U, E> flatMap(@NotNull Function<? super T, ? extends Result<U, E>> var1);

    public abstract <U> Result<T, U> mapError(Function<? super E, ? extends U> var1);

    public abstract Result<T, E> ifOkOrElse(Consumer<T> var1, Consumer<E> var2);

    public abstract T orElse(T var1);

    public boolean isOkAnd(Predicate<T> predicate) {
        return this.isOk() && predicate.test(this.unwrap());
    }

    public boolean isErr() {
        return !this.isOk();
    }

    public boolean isErrAnd(Predicate<E> predicate) {
        return this.isErr() && predicate.test(this.unwrapError());
    }

    public Result<T, E> ifOk(Consumer<T> whenOk) {
        return this.ifOkOrElse(whenOk, null);
    }

    public Result<T, E> ifError(Consumer<E> whenError) {
        return this.ifOkOrElse(null, whenError);
    }

    public abstract <U> Result<U, E> and(Result<U, E> var1);

    public abstract <U> Result<U, E> andThen(Function<T, Result<U, E>> var1);

    public Pair<T, E> toTuple() {
        if (this.isOk()) {
            return new Pair<T, Object>(this.unwrap(), null);
        }
        return new Pair<Object, E>(null, this.unwrapError());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Result otherResult = (Result)other;
        return otherResult.isOk() && this.isOk() && this.unwrap().equals(otherResult.unwrap()) || otherResult.isErr() && this.isErr() && this.unwrapError().equals(otherResult.unwrapError());
    }
}

