/*
 * Decompiled with CFR 0.152.
 */
package org.storynode.pigeon.option;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.storynode.pigeon.option.Option;

public class Some<T>
extends Option<T> {
    private final T value;

    protected Some(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @Override
    public boolean isSome() {
        return true;
    }

    @Override
    public void ifPresent(@NotNull Consumer<T> func) {
        func.accept(this.unwrap());
    }

    @Override
    public void ifPresentOrElse(@NotNull Consumer<T> whenPresent, Runnable otherwise) {
        whenPresent.accept(this.unwrap());
    }

    @Override
    public Option<T> filter(Predicate<? super T> predicate) {
        return predicate.test(this.value) ? this : Some.none();
    }

    @Override
    public <U> Option<U> map(@NotNull Function<T, U> mapper) {
        return Option.some(mapper.apply(this.value));
    }

    @Override
    public <U> Option<U> flatMap(@NotNull Function<? super T, ? extends Option<? extends U>> mapper) {
        return mapper.apply(this.value);
    }

    @Override
    public Option<? extends T> or(@NotNull Supplier<? extends Option<? extends T>> supplier) {
        return this;
    }

    @Override
    public T orElseGet(@NotNull Supplier<T> supplier) {
        return this.unwrap();
    }

    @Override
    public T orElse(T other) {
        return this.unwrap();
    }

    @Override
    public T orElseThrow() {
        return this.value;
    }

    @Override
    public <E extends Throwable> T orElseThrow(@NotNull Supplier<E> throwable) {
        return this.value;
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.value);
    }

    public T value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.value, ((Some)obj).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Some[value=" + String.valueOf(this.value) + "]";
    }

    @Override
    public T unwrap() {
        return this.value;
    }
}

