/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.encoding.LdapShaPasswordEncoder;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.util.Assert;

public final class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog(PasswordComparisonAuthenticator.class);
    private PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder();
    private String passwordAttributeName = "userPassword";

    public PasswordComparisonAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    @Override
    public DirContextOperations authenticate(Authentication authentication) {
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        DirContextOperations user = null;
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        SpringSecurityLdapTemplate ldapTemplate = new SpringSecurityLdapTemplate(this.getContextSource());
        for (String userDn : this.getUserDns(username)) {
            try {
                user = ldapTemplate.retrieveEntry(userDn, this.getUserAttributes());
            }
            catch (NameNotFoundException ignore) {
                // empty catch block
            }
            if (user == null) continue;
            break;
        }
        if (user == null && this.getUserSearch() != null) {
            user = this.getUserSearch().searchForUser(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + username, (Object)username);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing LDAP compare of password attribute '" + this.passwordAttributeName + "' for user '" + user.getDn() + "'"));
        }
        String encodedPassword = this.passwordEncoder.encodePassword(password, null);
        byte[] passwordBytes = Utf8.encode((CharSequence)encodedPassword);
        if (!ldapTemplate.compare(user.getDn().toString(), this.passwordAttributeName, passwordBytes)) {
            throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
        }
        return user;
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        Assert.hasLength((String)passwordAttribute, (String)"passwordAttributeName must not be empty or null");
        this.passwordAttributeName = passwordAttribute;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
    }
}

