/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Map;
import java.util.Optional;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.configuration.SpringDocWebServerConfiguration;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;

public abstract class ActuatorProvider
implements ApplicationContextAware {
    protected ManagementServerProperties managementServerProperties;
    protected WebEndpointProperties webEndpointProperties;
    protected SpringDocWebServerConfiguration.SpringDocWebServerContext springDocWebServerContext;
    protected SpringDocConfigProperties springDocConfigProperties;
    protected ApplicationContext applicationContext;

    protected ActuatorProvider(Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties, SpringDocWebServerConfiguration.SpringDocWebServerContext springDocWebServerContext, SpringDocConfigProperties springDocConfigProperties) {
        managementServerProperties.ifPresent(managementServerProperties1 -> {
            this.managementServerProperties = managementServerProperties1;
        });
        webEndpointProperties.ifPresent(webEndpointProperties1 -> {
            this.webEndpointProperties = webEndpointProperties1;
        });
        this.springDocConfigProperties = springDocConfigProperties;
        this.springDocWebServerContext = springDocWebServerContext;
    }

    public static Tag getTag() {
        Tag actuatorTag = new Tag();
        actuatorTag.setName("Actuator");
        actuatorTag.setDescription("Monitor and interact");
        actuatorTag.setExternalDocs(new ExternalDocumentation().url("https://docs.spring.io/spring-boot/docs/current/actuator-api/html/").description("Spring Boot Actuator Web API Documentation"));
        return actuatorTag;
    }

    public boolean isRestController(String operationPath, HandlerMethod handlerMethod) {
        return operationPath.startsWith("/") && !AbstractOpenApiResource.isHiddenRestControllers(handlerMethod.getBeanType()) && AbstractOpenApiResource.containsResponseBody(handlerMethod);
    }

    public boolean isUseManagementPort() {
        return this.springDocConfigProperties.isUseManagementPort();
    }

    public String getBasePath() {
        return this.webEndpointProperties.getBasePath();
    }

    public String getContextPath() {
        return "";
    }

    public String getActuatorPath() {
        return this.managementServerProperties.getBasePath();
    }

    public int getApplicationPort() {
        return this.springDocWebServerContext.getApplicationPort().get();
    }

    public int getActuatorPort() {
        return this.springDocWebServerContext.getActuatorPort().get();
    }

    public abstract Map getMethods();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

