/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.Operation;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.web.method.HandlerMethod;

public class ActuatorOperationCustomizer
implements OperationCustomizer {
    private final ActuatorProvider actuatorProvider;
    private int methodCount;

    public ActuatorOperationCustomizer(ActuatorProvider actuatorProvider) {
        this.actuatorProvider = actuatorProvider;
    }

    @Override
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        if (operation.getTags() != null && operation.getTags().contains(this.actuatorProvider.getTag().getName())) {
            operation.setSummary(handlerMethod.toString());
            operation.setOperationId(operation.getOperationId() + "_" + this.methodCount++);
        }
        return operation;
    }
}

