/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.sampling;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.springaicommunity.mcp.method.sampling.AbstractMcpSamplingMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncMcpSamplingMethodCallback
extends AbstractMcpSamplingMethodCallback
implements Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> {
    private AsyncMcpSamplingMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public Mono<McpSchema.CreateMessageResult> apply(McpSchema.CreateMessageRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        try {
            Object[] args = this.buildArgs(this.method, null, request);
            this.method.setAccessible(true);
            Object result = this.method.invoke(this.bean, args);
            if (result instanceof Mono) {
                Mono monoResult = (Mono)result;
                return monoResult;
            }
            if (result instanceof McpSchema.CreateMessageResult) {
                return Mono.just((Object)((McpSchema.CreateMessageResult)result));
            }
            return Mono.error((Throwable)new AbstractMcpSamplingMethodCallback.McpSamplingMethodException("Method must return Mono<CreateMessageResult> or CreateMessageResult: " + this.method.getName()));
        }
        catch (Exception e) {
            return Mono.error((Throwable)new AbstractMcpSamplingMethodCallback.McpSamplingMethodException("Error invoking sampling method: " + this.method.getName(), e));
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!Mono.class.isAssignableFrom(returnType) && !McpSchema.CreateMessageResult.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must return Mono<CreateMessageResult> or CreateMessageResult: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    @Override
    protected boolean isExchangeType(Class<?> paramType) {
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpSamplingMethodCallback.AbstractBuilder<Builder, AsyncMcpSamplingMethodCallback> {
        @Override
        public AsyncMcpSamplingMethodCallback build() {
            this.validate();
            return new AsyncMcpSamplingMethodCallback(this);
        }
    }
}

