/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.complete;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.method.complete.AbstractMcpCompleteMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncStatelessMcpCompleteMethodCallback
extends AbstractMcpCompleteMethodCallback
implements BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> {
    private AsyncStatelessMcpCompleteMethodCallback(Builder builder) {
        super(builder.method, builder.bean, builder.prompt, builder.uri, builder.uriTemplateManagerFactory);
        this.validateMethod(this.method);
    }

    @Override
    public Mono<McpSchema.CompleteResult> apply(McpTransportContext context, McpSchema.CompleteRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        return Mono.defer(() -> {
            try {
                Object[] args = this.buildArgs(this.method, context, request);
                this.method.setAccessible(true);
                Object result = this.method.invoke(this.bean, args);
                if (result instanceof Mono) {
                    return ((Mono)result).map(r -> this.convertToCompleteResult(r));
                }
                return Mono.just((Object)this.convertToCompleteResult(result));
            }
            catch (Exception e) {
                return Mono.error((Throwable)new AbstractMcpCompleteMethodCallback.McpCompleteMethodException("Error invoking complete method: " + this.method.getName(), e));
            }
        });
    }

    private McpSchema.CompleteResult convertToCompleteResult(Object result) {
        if (result == null) {
            return new McpSchema.CompleteResult(new McpSchema.CompleteResult.CompleteCompletion(List.of(), Integer.valueOf(0), Boolean.valueOf(false)));
        }
        if (result instanceof McpSchema.CompleteResult) {
            return (McpSchema.CompleteResult)result;
        }
        if (result instanceof McpSchema.CompleteResult.CompleteCompletion) {
            return new McpSchema.CompleteResult((McpSchema.CompleteResult.CompleteCompletion)result);
        }
        if (result instanceof List) {
            List list = (List)result;
            ArrayList<String> values = new ArrayList<String>();
            for (Object item : list) {
                if (item instanceof String) {
                    values.add((String)item);
                    continue;
                }
                throw new IllegalArgumentException("List items must be of type String");
            }
            return new McpSchema.CompleteResult(new McpSchema.CompleteResult.CompleteCompletion(values, Integer.valueOf(values.size()), Boolean.valueOf(false)));
        }
        if (result instanceof String) {
            return new McpSchema.CompleteResult(new McpSchema.CompleteResult.CompleteCompletion(List.of((String)result), Integer.valueOf(1), Boolean.valueOf(false)));
        }
        throw new IllegalArgumentException("Unsupported return type: " + result.getClass().getName());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void validateReturnType(Method method) {
        boolean validReturnType;
        Class<?> returnType = method.getReturnType();
        boolean bl = validReturnType = McpSchema.CompleteResult.class.isAssignableFrom(returnType) || McpSchema.CompleteResult.CompleteCompletion.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
        if (!validReturnType) {
            throw new IllegalArgumentException("Method must return either CompleteResult, CompleteCompletion, List<String>, String, or Mono<T>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    @Override
    protected boolean isExchangeType(Class<?> paramType) {
        return McpTransportContext.class.isAssignableFrom(paramType);
    }

    public static class Builder
    extends AbstractMcpCompleteMethodCallback.AbstractBuilder<Builder, AsyncStatelessMcpCompleteMethodCallback> {
        public Builder() {
            this.uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();
        }

        @Override
        public AsyncStatelessMcpCompleteMethodCallback build() {
            this.validate();
            return new AsyncStatelessMcpCompleteMethodCallback(this);
        }
    }
}

