/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import com.google.protobuf.CodedInputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.proto.gen.ProtoSampleNodes;
import org.spf4j.ui.FlameStackPanel;
import org.spf4j.ui.ZStackPanel;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "SE_BAD_FIELD"})
public class StackDumpJInternalFrame
extends JInternalFrame {
    private SampleNode samples;
    private JScrollPane ssScrollPanel;

    public StackDumpJInternalFrame(String sampleFile, boolean isPro) throws IOException {
        super(sampleFile);
        this.initComponents();
        if (sampleFile.endsWith("ssdump")) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sampleFile));){
                CodedInputStream is = CodedInputStream.newInstance((InputStream)bis);
                is.setRecursionLimit(Short.MAX_VALUE);
                this.samples = org.spf4j.stackmonitor.proto.Converter.fromProtoToSampleNode(ProtoSampleNodes.SampleNode.parseFrom(is));
            }
        } else {
            this.samples = Converter.load((File)new File(sampleFile));
        }
        if (this.samples == null) {
            this.samples = new SampleNode(new StackTraceElement[]{new StackTraceElement("NO SAMPLES", "", "", -1)}, 0);
        }
        if (isPro) {
            this.ssScrollPanel.setViewportView(new ZStackPanel(this.samples));
        } else {
            this.ssScrollPanel.setViewportView(new FlameStackPanel(this.samples));
        }
        this.ssScrollPanel.setVisible(true);
        this.pack();
    }

    @SuppressFBWarnings
    private void initComponents() {
        this.ssScrollPanel = new JScrollPane();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.ssScrollPanel.setAutoscrolls(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ssScrollPanel, -1, 412, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ssScrollPanel, -1, 328, Short.MAX_VALUE));
        this.pack();
    }
}

