/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.spf4j.base.Arrays;
import org.spf4j.base.Pair;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TimeSeries;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.TableDef;

public final class Charts {
    private Charts() {
    }

    public static boolean canGenerateMinMaxAvgCount(TableDef info) {
        int found = 0;
        for (ColumnDef colDef : info.getColumns()) {
            switch (colDef.getName()) {
                case "min": 
                case "max": 
                case "total": 
                case "count": {
                    ++found;
                    break;
                }
            }
        }
        return found >= 4;
    }

    public static boolean canGenerateCount(TableDef info) {
        int found = 0;
        for (ColumnDef colDef : info.getColumns()) {
            switch (colDef.getName()) {
                case "count": {
                    ++found;
                    break;
                }
            }
        }
        return found >= 1;
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"})
    public static boolean canGenerateHeatChart(TableDef info) {
        for (ColumnDef colDef : info.getColumns()) {
            if (!colDef.name.startsWith("Q") || !colDef.name.contains("_")) continue;
            return true;
        }
        return false;
    }

    public static JFreeChart createHeatJFreeChart(File database, List<TableDef> table, long startTime, long endTime) throws IOException {
        TimeSeries data = TSDBQuery.getTimeSeries((File)database, (long[])TSDBQuery.getIds(table), (long)startTime, (long)endTime);
        return Charts.createHeatJFreeChart(data, table.get(0));
    }

    public static JFreeChart createHeatJFreeChart(TimeSeries data, TableDef info) {
        Pair<long[], double[][]> mData = org.spf4j.perf.impl.chart.Charts.fillGaps(data.getTimeStamps(), data.getValues(), info.getSampleTime(), info.getColumns().size());
        ColumnDef columnDef = TSDBQuery.getColumnDef((TableDef)info, (String)"total");
        return org.spf4j.perf.impl.chart.Charts.createHeatJFreeChart(TSDBQuery.getColumnNames((TableDef)info), (double[][])mData.getSecond(), data.getTimeStamps()[0], info.getSampleTime().intValue(), columnDef.getUnitOfMeasurement(), "Measurements distribution for " + info.getName() + ", sampleTime " + info.getSampleTime() + "ms, generated by spf4j");
    }

    public static JFreeChart createMinMaxAvgJFreeChart(TimeSeries data, TableDef info) {
        long[][] vals = data.getValues();
        double[] min = Arrays.getColumnAsDoubles((long[][])vals, (int)TSDBQuery.getColumnIndex((TableDef)info, (String)"min"));
        double[] max = Arrays.getColumnAsDoubles((long[][])vals, (int)TSDBQuery.getColumnIndex((TableDef)info, (String)"max"));
        int totalColumnIndex = TSDBQuery.getColumnIndex((TableDef)info, (String)"total");
        double[] total = Arrays.getColumnAsDoubles((long[][])vals, (int)totalColumnIndex);
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)TSDBQuery.getColumnIndex((TableDef)info, (String)"count"));
        for (int i = 0; i < count.length; ++i) {
            if (count[i] != 0.0) continue;
            min[i] = 0.0;
            max[i] = 0.0;
        }
        long[] timestamps = data.getTimeStamps();
        return org.spf4j.perf.impl.chart.Charts.createTimeSeriesJFreeChart("Min,Max,Avg chart for " + info.getName() + ", sampleTime " + info.getSampleTime() + "ms, generated by spf4j", timestamps, new String[]{"min", "max", "avg"}, TSDBQuery.getColumnDef((TableDef)info, (String)"total").getUnitOfMeasurement(), (double[][])new double[][]{min, max, Arrays.divide((double[])total, (double[])count)});
    }

    public static JFreeChart createMinMaxAvgJFreeChart(File database, List<TableDef> table, long startTime, long endTime) throws IOException {
        TimeSeries data = TSDBQuery.getTimeSeries((File)database, (long[])TSDBQuery.getIds(table), (long)startTime, (long)endTime);
        return Charts.createMinMaxAvgJFreeChart(data, table.get(0));
    }

    public static JFreeChart createCountJFreeChart(TimeSeries data, TableDef info) {
        long[][] vals = data.getValues();
        double[] count = Arrays.getColumnAsDoubles((long[][])vals, (int)TSDBQuery.getColumnIndex((TableDef)info, (String)"count"));
        long[] timestamps = data.getTimeStamps();
        return org.spf4j.perf.impl.chart.Charts.createTimeSeriesJFreeChart("count chart for " + info.getName() + ", sampleTime " + info.getSampleTime() + " ms, generated by spf4j", timestamps, new String[]{"count"}, "count", (double[][])new double[][]{count});
    }

    public static JFreeChart createCountJFreeChart(File database, List<TableDef> info, long startTime, long endTime) throws IOException {
        TimeSeries data = TSDBQuery.getTimeSeries((File)database, (long[])TSDBQuery.getIds(info), (long)startTime, (long)endTime);
        return Charts.createCountJFreeChart(data, info.get(0));
    }

    public static List<JFreeChart> createJFreeCharts(TimeSeries data, TableDef info) {
        long[][] vals = data.getValues();
        ArrayList<JFreeChart> result = new ArrayList<JFreeChart>();
        HashMap<String, Pair> measurementsByUom = new HashMap<String, Pair>();
        int i = 0;
        for (ColumnDef colDef : info.getColumns()) {
            String uom = colDef.getUnitOfMeasurement();
            Pair meas = (Pair)measurementsByUom.get(uom);
            if (meas == null) {
                meas = Pair.of(new ArrayList(), new ArrayList());
                measurementsByUom.put(uom, meas);
            }
            ((List)meas.getFirst()).add(colDef.getName());
            ((List)meas.getSecond()).add(Arrays.getColumnAsDoubles((long[][])vals, (int)i));
            ++i;
        }
        long[] timestamps = data.getTimeStamps();
        for (Map.Entry entry : measurementsByUom.entrySet()) {
            Pair p = (Pair)entry.getValue();
            List measurementNames = (List)p.getFirst();
            List measurements = (List)p.getSecond();
            result.add(org.spf4j.perf.impl.chart.Charts.createTimeSeriesJFreeChart("chart for " + info.getName() + ", sampleTime " + info.getSampleTime() + " ms, generated by spf4j", timestamps, measurementNames.toArray(new String[measurementNames.size()]), (String)entry.getKey(), (double[][])measurements.toArray((T[])new double[measurements.size()][])));
        }
        return result;
    }

    public static List<JFreeChart> createJFreeCharts(File database, List<TableDef> td, long startTime, long endTime) throws IOException {
        TimeSeries data = TSDBQuery.getTimeSeries((File)database, (long[])TSDBQuery.getIds(td), (long)startTime, (long)endTime);
        return Charts.createJFreeCharts(data, td.get(0));
    }
}

