/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor.proto;

import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.spf4j.base.Method;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.proto.gen.ProtoSampleNodes;

public final class Converter {
    private Converter() {
    }

    public static void saveToFile(@Nonnull String fileName, @Nonnull SampleNode input) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));){
            Converter.fromSampleNodeToProto(input).writeTo(bos);
        }
    }

    public static ProtoSampleNodes.Method fromMethodToProto(Method m) {
        return ProtoSampleNodes.Method.newBuilder().setMethodName(m.getMethodName()).setDeclaringClass(m.getDeclaringClass()).build();
    }

    public static ProtoSampleNodes.SampleNode fromSampleNodeToProto(SampleNode node) {
        ProtoSampleNodes.SampleNode.Builder resultBuilder = ProtoSampleNodes.SampleNode.newBuilder().setCount(node.getSampleCount());
        TMap subNodes = node.getSubNodes();
        if (subNodes != null) {
            for (Map.Entry entry : subNodes.entrySet()) {
                resultBuilder.addSubNodes(ProtoSampleNodes.SamplePair.newBuilder().setMethod(Converter.fromMethodToProto((Method)entry.getKey())).setNode(Converter.fromSampleNodeToProto((SampleNode)entry.getValue())).build());
            }
        }
        return resultBuilder.build();
    }

    public static SampleNode fromProtoToSampleNode(ProtoSampleNodes.SampleNodeOrBuilder node) {
        THashMap subNodes = null;
        List<ProtoSampleNodes.SamplePair> sns = node.getSubNodesList();
        if (sns != null) {
            subNodes = new THashMap();
            for (ProtoSampleNodes.SamplePair pair : sns) {
                ProtoSampleNodes.Method method = pair.getMethod();
                subNodes.put((Object)new Method(method.getDeclaringClass(), method.getMethodName()), (Object)Converter.fromProtoToSampleNode(pair.getNode()));
            }
        }
        return new SampleNode(node.getCount(), (TMap)subNodes);
    }
}

