/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.tsdb;

import com.google.common.base.Charsets;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.spf4j.io.ByteArrayBuilder;

@Deprecated
public final class TSTable {
    private final long location;
    private long nextTableInfo;
    private long firstDataFragment;
    private long lastDataFragment;
    private final String tableName;
    private final int sampleTime;
    private final byte[] tableMetaData;
    private final String[] columnNames;
    private final byte[][] columnMetaData;
    private final Map<String, Integer> nameToIndex;

    TSTable(String tableName, byte[] tableMetaData, String[] columnNames, byte[][] columnMetaData, int sampleTime, long location) {
        this.location = location;
        this.nextTableInfo = 0L;
        this.firstDataFragment = 0L;
        this.lastDataFragment = 0L;
        this.tableName = tableName;
        this.sampleTime = sampleTime;
        this.tableMetaData = tableMetaData;
        this.columnNames = columnNames;
        this.columnMetaData = columnMetaData;
        this.nameToIndex = new HashMap<String, Integer>(columnNames.length + columnNames.length / 3);
        for (int i = 0; i < columnNames.length; ++i) {
            this.nameToIndex.put(columnNames[i], i);
        }
    }

    TSTable(TSTable copyOf) {
        this.location = copyOf.location;
        this.nextTableInfo = copyOf.nextTableInfo;
        this.firstDataFragment = copyOf.firstDataFragment;
        this.lastDataFragment = copyOf.lastDataFragment;
        this.tableName = copyOf.tableName;
        this.sampleTime = copyOf.sampleTime;
        this.tableMetaData = copyOf.tableMetaData;
        this.columnNames = copyOf.columnNames;
        this.columnMetaData = copyOf.columnMetaData;
        this.nameToIndex = copyOf.nameToIndex;
    }

    TSTable(RandomAccessFile raf) throws IOException {
        this(raf, raf.getFilePointer());
    }

    TSTable(RandomAccessFile raf, long location) throws IOException {
        int i;
        this.location = location;
        raf.seek(location);
        this.nextTableInfo = raf.readLong();
        this.firstDataFragment = raf.readLong();
        this.lastDataFragment = raf.readLong();
        this.tableName = raf.readUTF();
        this.sampleTime = raf.readInt();
        int grMetaSize = raf.readInt();
        this.tableMetaData = new byte[grMetaSize];
        raf.readFully(this.tableMetaData);
        short nrColumns = raf.readShort();
        this.columnNames = new String[nrColumns];
        this.nameToIndex = new HashMap<String, Integer>(nrColumns + nrColumns / 3);
        for (i = 0; i < this.columnNames.length; ++i) {
            String colName;
            this.columnNames[i] = colName = raf.readUTF();
            this.nameToIndex.put(colName, i);
        }
        this.columnMetaData = new byte[raf.readInt()][];
        for (i = 0; i < this.columnMetaData.length; ++i) {
            int metaLength = raf.readInt();
            byte[] colMetaData = new byte[metaLength];
            raf.readFully(colMetaData);
            this.columnMetaData[i] = colMetaData;
        }
    }

    void writeTo(DataOutput dos) throws IOException {
        dos.writeLong(this.nextTableInfo);
        dos.writeLong(this.firstDataFragment);
        dos.writeLong(this.lastDataFragment);
        dos.writeUTF(this.tableName);
        dos.writeInt(this.sampleTime);
        dos.writeInt(this.tableMetaData.length);
        dos.write(this.tableMetaData);
        dos.writeShort(this.columnNames.length);
        for (String columnName : this.columnNames) {
            dos.writeUTF(columnName);
        }
        dos.writeInt(this.columnMetaData.length);
        for (byte[] colMeta : this.columnMetaData) {
            dos.writeInt(colMeta.length);
            dos.write(colMeta);
        }
    }

    void writeTo(RandomAccessFile raf) throws IOException {
        try (ByteArrayBuilder bos = new ByteArrayBuilder();){
            DataOutputStream dos = new DataOutputStream((OutputStream)bos);
            this.writeTo(dos);
            raf.seek(this.location);
            raf.write(bos.getBuffer(), 0, bos.size());
        }
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    void setNextColumnInfo(long pnextColumnInfo, RandomAccessFile raf) throws IOException {
        this.nextTableInfo = pnextColumnInfo;
        raf.seek(this.location);
        raf.writeLong(this.nextTableInfo);
    }

    void setFirstDataFragment(long pfirstDataFragment, RandomAccessFile raf) throws IOException {
        this.firstDataFragment = pfirstDataFragment;
        raf.seek(this.location + 8L);
        raf.writeLong(this.firstDataFragment);
    }

    void setLastDataFragment(long plastDataFragment, RandomAccessFile raf) throws IOException {
        this.lastDataFragment = plastDataFragment;
        raf.seek(this.location + 16L);
        raf.writeLong(this.lastDataFragment);
    }

    public long getNextTSTable() {
        return this.nextTableInfo;
    }

    public long getLocation() {
        return this.location;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getFirstDataFragment() {
        return this.firstDataFragment;
    }

    public long getLastDataFragment() {
        return this.lastDataFragment;
    }

    public byte[][] getColumnMetaData() {
        return (byte[][])this.columnMetaData.clone();
    }

    public String[] getColumnMetaDataAsStrings() {
        String[] result = new String[this.columnMetaData.length];
        for (int i = 0; i < this.columnMetaData.length; ++i) {
            result[i] = new String(this.columnMetaData[i], Charsets.UTF_8);
        }
        return result;
    }

    public int getColumnIndex(String columnName) {
        Integer result = this.nameToIndex.get(columnName);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public int getSampleTime() {
        return this.sampleTime;
    }

    public byte[] getTableMetaData() {
        return (byte[])this.tableMetaData.clone();
    }

    public int getColumnNumber() {
        return this.columnNames.length;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public String toString() {
        return "TSTable{location=" + this.location + ", nextColumnInfo=" + this.nextTableInfo + ", firstDataFragment=" + this.firstDataFragment + ", lastDataFragment=" + this.lastDataFragment + ", groupName=" + this.tableName + ", sampleTime=" + this.sampleTime + ", columnNames=" + Arrays.toString(this.columnNames) + ", nameToIndex=" + this.nameToIndex + '}';
    }
}

