/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.stackmonitor.Sampler;
import org.spf4j.stackmonitor.StackCollector;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class Spf4jRunListener
extends RunListener {
    private final Sampler sampler = new Sampler(Integer.getInteger("spf4j.junit.sampleTimeMillis", 5).intValue(), Integer.getInteger("spf4j.junit.dumpAfterMillis", Integer.MAX_VALUE).intValue(), (StackCollector)new FastStackCollector(true, new String[0]));
    private final File destinationFolder = new File(System.getProperty("spf4j.junit.destinationFolder", "target/junit-ssdump"));

    public Spf4jRunListener() {
        if (!this.destinationFolder.mkdirs() && !this.destinationFolder.canWrite()) {
            throw new ExceptionInInitializerError("Unable to write to " + this.destinationFolder);
        }
    }

    public void testFailure(Failure failure) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        this.sampler.stop();
        File dumpToFile = this.sampler.dumpToFile(new File(this.destinationFolder, failure.getTestHeader() + ".ssdump2"));
        if (dumpToFile != null) {
            System.out.print("Profile saved to " + dumpToFile);
        }
    }

    public void testFinished(Description description) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        this.sampler.stop();
        File dumpToFile = this.sampler.dumpToFile(new File(this.destinationFolder, description.getDisplayName() + ".ssdump2"));
        if (dumpToFile != null) {
            System.out.print("Profile saved to " + dumpToFile);
        }
    }

    public void testStarted(Description description) {
        this.sampler.start();
    }

    public String toString() {
        return "Spf4jRunListener{sampler=" + this.sampler + '}';
    }
}

