/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.spf4j.avro.schema.SchemaUtils;
import org.spf4j.avro.schema.SchemaVisitor;
import org.spf4j.avro.schema.SchemaVisitorAction;

public final class SchemasWithClasses
implements SchemaVisitor<Map<String, Schema>> {
    private final Map<String, Schema> schemas = new HashMap<String, Schema>();

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public SchemaVisitorAction visitTerminal(Schema schema) {
        switch (schema.getType()) {
            case FIXED: 
            case ENUM: {
                this.schemas.put(SchemaUtils.getJavaClassName(schema), schema);
            }
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction visitNonTerminal(Schema schema) {
        if (schema.getType() == Schema.Type.RECORD) {
            this.schemas.put(SchemaUtils.getJavaClassName(schema), schema);
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction afterVisitNonTerminal(Schema terminal) {
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public Map<String, Schema> get() {
        return this.schemas;
    }

    public String toString() {
        return "SchemasWithClasses{schemas=" + this.schemas + '}';
    }
}

